/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TasksManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.widgets.Shell;

public class ChartWizard
extends WizardBase {
    public static final String WIZARD_ID = "org.eclipse.birt.chart.ui.ChartWizard";
    private static final int CHART_WIZARD_WIDTH_MINMUM = 680;
    private static final int CHART_WIZARD_HEIGHT_MINMUM = 670;
    public static final double DEFAULT_CHART_BLOCK_HEIGHT = 130.0;
    public static final double DEFAULT_CHART_BLOCK_WIDTH = 212.0;
    public static final double DEFAULT_CHART_WITHOUT_AXIS_BLOCK_HEIGHT = 130.0;
    public static final double DEFAULT_CHART_WITHOUT_AXIS_BLOCK_WIDTH = 212.0;
    public static boolean POPUP_CLOSING_BY_USER = true;
    private static Map lastTask = new HashMap(3);
    private ChartAdapter adapter = new ChartAdapter(this);

    public ChartWizard() {
        this(null);
    }

    public ChartWizard(Shell parentShell) {
        super(parentShell, WIZARD_ID, 680, 670, Messages.getString("ChartWizard.Title.ChartBuilder"), UIHelper.getImage("icons/obj16/chartselector.gif"), Messages.getString("ChartWizard.Label.SelectChartTypeDataFormat"), UIHelper.getImage("icons/wizban/chartwizardtaskbar.gif"));
    }

    public void addTask(String sTaskID) {
        super.addTask(sTaskID);
        ITask task = TasksManager.instance().getTask(sTaskID);
        if (task instanceof ITaskChangeListener) {
            this.adapter.addListener((ITaskChangeListener)task);
        }
    }

    private void resizeChart(Chart chartModelCurrent) {
        if (chartModelCurrent.getBlock().getBounds() == null || chartModelCurrent.getBlock().getBounds().getWidth() == 0.0 || chartModelCurrent.getBlock().getBounds().getHeight() == 0.0) {
            if (chartModelCurrent instanceof ChartWithoutAxesImpl) {
                chartModelCurrent.getBlock().setBounds(BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)130.0));
            } else {
                chartModelCurrent.getBlock().setBounds(BoundsImpl.create((double)0.0, (double)0.0, (double)212.0, (double)130.0));
            }
        }
    }

    private void removeAllAdapters(Chart chart) {
        chart.eAdapters().remove((Object)this.adapter);
        TreeIterator iterator = chart.eAllContents();
        while (iterator.hasNext()) {
            Object oModel = iterator.next();
            if (!(oModel instanceof EObject)) continue;
            ((EObject)oModel).eAdapters().remove((Object)this.adapter);
        }
    }

    public void dispose() {
        if (this.getContext() != null) {
            this.getContext().getDataServiceProvider().dispose();
            Chart chart = this.getContext().getModel();
            if (chart != null) {
                this.resizeChart(chart);
                this.removeAllAdapters(chart);
                ChartCacheManager.getInstance().dispose();
            }
        }
        super.dispose();
    }

    public EContentAdapter getAdapter() {
        return this.adapter;
    }

    protected ChartWizardContext getContext() {
        return (ChartWizardContext)this.context;
    }

    public String[] validate() {
        return this.getContext().getUIServiceProvider().validate(this.getContext().getModel(), this.getContext().getExtendedItem());
    }

    public IWizardContext open(String[] sTasks, String topTaskId, IWizardContext initialContext) {
        Chart chart = ((ChartWizardContext)initialContext).getModel();
        if (chart == null) {
            this.setTitle(Messages.getString("ChartWizard.Title.NewChart"));
        } else {
            this.setTitle(Messages.getString("ChartWizard.Title.EditChart"));
            chart.eAdapters().add((Object)this.adapter);
        }
        if (chart == null) {
            topTaskId = null;
        } else if (topTaskId == null) {
            topTaskId = (String)lastTask.get(initialContext.getWizardID());
        }
        return super.open(sTasks, topTaskId, initialContext);
    }

    public void detachPopup() {
        POPUP_CLOSING_BY_USER = false;
        super.detachPopup();
        POPUP_CLOSING_BY_USER = true;
    }

    public void switchTo(String sTaskID) {
        lastTask.put(this.getContext().getWizardID(), sTaskID);
        super.switchTo(sTaskID);
    }
}

