/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ChartCacheManager {
    private static final int DEFAULT_SERIES_TYPE_NUMBER = 7;
    private static Map instances;
    private static String currentInstanceId;
    private static final String DEFAULT_INSTANCE = "default";
    private List cacheSeries = new ArrayList(3);
    private Map cacheSubtypes = new HashMap(7);
    static final /* synthetic */ boolean $assertionsDisabled;

    private ChartCacheManager() {
    }

    public static ChartCacheManager getInstance() {
        if (currentInstanceId == null) {
            ChartCacheManager.switchInstance(DEFAULT_INSTANCE);
        }
        return (ChartCacheManager)instances.get(currentInstanceId);
    }

    public static ChartCacheManager getInstance(String instanceId) {
        ChartCacheManager.switchInstance(instanceId);
        return ChartCacheManager.getInstance();
    }

    public static void switchInstance(String instanceId) {
        if (!$assertionsDisabled && instanceId == null) {
            throw new AssertionError();
        }
        currentInstanceId = instanceId;
        if (!instances.containsKey(instanceId)) {
            instances.put(instanceId, new ChartCacheManager());
        }
    }

    public Series findSeries(String seriesClass, int seriesIndex) {
        if (!$assertionsDisabled && seriesIndex < 0) {
            throw new AssertionError();
        }
        while (this.cacheSeries.size() <= seriesIndex) {
            this.cacheSeries.add(new HashMap(7));
        }
        Map map = (Map)this.cacheSeries.get(seriesIndex);
        if (!map.containsKey(seriesClass)) {
            return null;
        }
        return (Series)EcoreUtil.copy((EObject)((Series)map.get(seriesClass)));
    }

    public void cacheSeries(List seriesDefinitions) {
        for (int i = 0; i < seriesDefinitions.size(); ++i) {
            Series series = ((SeriesDefinition)seriesDefinitions.get(i)).getDesignTimeSeries();
            if (this.cacheSeries.size() <= i) {
                this.cacheSeries.add(new HashMap(7));
            }
            ((Map)this.cacheSeries.get(i)).put(series.getClass().getName(), EcoreUtil.copy((EObject)series));
        }
        this.removeSeries(seriesDefinitions.size());
    }

    public void cacheSeries(int seriesIndex, Series series) {
        if (!$assertionsDisabled && seriesIndex < 0) {
            throw new AssertionError();
        }
        while (this.cacheSeries.size() <= seriesIndex) {
            this.cacheSeries.add(new HashMap(7));
        }
        ((Map)this.cacheSeries.get(seriesIndex)).put(series.getClass().getName(), EcoreUtil.copy((EObject)series));
    }

    public void removeSeries(int seriesSize) {
        while (this.cacheSeries.size() > seriesSize) {
            this.cacheSeries.remove(seriesSize);
        }
    }

    public void dispose() {
        this.cacheSeries.clear();
        this.cacheSubtypes.clear();
        instances.remove(currentInstanceId);
        currentInstanceId = null;
    }

    public void cacheSubtype(String chartType, String subtype) {
        this.cacheSubtypes.put(chartType, subtype);
    }

    public String findSubtype(String chartType) {
        return (String)this.cacheSubtypes.get(chartType);
    }

    static {
        $assertionsDisabled = !ChartCacheManager.class.desiredAssertionStatus();
        instances = new HashMap(3);
        currentInstanceId = null;
    }
}

