/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.Line;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Area
extends Line {
    private Fill getSeriesPaletteEntry() {
        int iThisSeriesIndex;
        Fill fPaletteEntry = null;
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se)) >= 0) {
            EList ePalette = sd.getSeriesPalette().getEntries();
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((EObject)ePalette.get(iThisSeriesIndex % ePalette.size())));
            this.updateTranslucency(fPaletteEntry, se);
        }
        return fPaletteEntry;
    }

    private int getFirstNonNullIndex(DataPointHints[] dpha) {
        for (int i = 0; i < dpha.length; ++i) {
            if (dpha[i].getOrthogonalValue() == null) continue;
            return i;
        }
        return -1;
    }

    private int getLastNonNullIndex(DataPointHints[] dpha) {
        for (int i = dpha.length - 1; i >= 0; --i) {
            if (dpha[i].getOrthogonalValue() == null) continue;
            return i;
        }
        return -1;
    }

    protected boolean validateShowAsTape() {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        AreaSeries as = (AreaSeries)this.getSeries();
        if (!as.isStacked()) {
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        } else {
            Axis[] axaOrthogonal = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            if (axaOrthogonal.length > 1) {
                return false;
            }
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                Iterator itr = axaOrthogonal[0].getSeriesDefinitions().iterator();
                while (itr.hasNext()) {
                    SeriesDefinition sd = (SeriesDefinition)itr.next();
                    Iterator sitr = sd.getRunTimeSeries().iterator();
                    while (sitr.hasNext()) {
                        Series se = (Series)sitr.next();
                        if (se instanceof AreaSeries && se.isStacked()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected void renderAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints isrh, Location[] loa, boolean bShowAsTape, double tapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        Fill seriesPalette = this.getSeriesPaletteEntry();
        double zeroLocation = 0.0;
        if (this.isDimension3D()) {
            zeroLocation = ((SeriesRenderingHints3D)isrh).getPlotBaseLocation();
        } else {
            SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
            zeroLocation = srh.getZeroLocation();
            Bounds boClientArea = srh.getClientAreaBounds(true);
            double dSeriesThickness = srh.getSeriesThickness();
            if (((ChartWithAxes)this.getModel()).getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
            }
            if (((ChartWithAxes)this.getModel()).isTransposed()) {
                if (zeroLocation < boClientArea.getLeft()) {
                    zeroLocation = boClientArea.getLeft();
                }
                if (zeroLocation > boClientArea.getLeft() + boClientArea.getWidth()) {
                    zeroLocation = boClientArea.getLeft() + boClientArea.getWidth();
                }
            } else {
                if (zeroLocation < boClientArea.getTop()) {
                    zeroLocation = boClientArea.getTop();
                }
                if (zeroLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                    zeroLocation = boClientArea.getTop() + boClientArea.getHeight();
                }
            }
        }
        CurveRenderer cr = new CurveRenderer((ChartWithAxes)this.getModel(), (BaseRenderer)this, lia, loa, zeroLocation, bShowAsTape, tapeWidth, true, this.getSeries().isSetTranslucent() && this.getSeries().isTranslucent(), this.getSeries().isStacked() || this.getAxis().isPercent(), true, true, seriesPalette != null ? seriesPalette : paletteEntry, usePaletteLineColor, true);
        cr.draw(ipr);
    }

    protected void renderDataPoints(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh, DataPointHints[] dpha, LineAttributes lia, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        int i;
        int pindex;
        int i2;
        ColorDefinition sideColor;
        ColorDefinition tapeColor;
        Fill fillColor;
        Line3DRenderEvent lre3d;
        PolygonRenderEvent pre;
        LineRenderEvent lre;
        Fill seriesPalette = this.getSeriesPaletteEntry();
        if (seriesPalette != null) {
            paletteEntry = seriesPalette;
        }
        Location[] loaPlane = null;
        Location3D[] loaPlane3d = null;
        double[] lastX = null;
        double[] lastY = null;
        double[] lastFixedX = null;
        double[] lastFixedY = null;
        Location3D[] loa3d = null;
        boolean isTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        boolean bRendering3d = this.isDimension3D();
        double zeroLocation = 0.0;
        double plotBaseLocation = 0.0;
        double plotHeight = 0.0;
        Series as = this.getSeries();
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3d) {
            srh3d = (SeriesRenderingHints3D)isrh;
            loa3d = (Location3D[])loa;
            plotBaseLocation = srh3d.getPlotBaseLocation();
            plotHeight = srh3d.getPlotHeight();
            zeroLocation = this.shear(plotBaseLocation, plotHeight, srh3d.getPlotZeroLocation());
        } else {
            srh = (SeriesRenderingHints)isrh;
            zeroLocation = srh.getZeroLocation();
            Bounds boClientArea = srh.getClientAreaBounds(true);
            double dSeriesThickness = srh.getSeriesThickness();
            if (((ChartWithAxes)this.getModel()).getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
            }
            if (isTransposed) {
                if (zeroLocation < boClientArea.getLeft()) {
                    zeroLocation = boClientArea.getLeft();
                }
                if (zeroLocation > boClientArea.getLeft() + boClientArea.getWidth()) {
                    zeroLocation = boClientArea.getLeft() + boClientArea.getWidth();
                }
            } else {
                if (zeroLocation < boClientArea.getTop()) {
                    zeroLocation = boClientArea.getTop();
                }
                if (zeroLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                    zeroLocation = boClientArea.getTop() + boClientArea.getHeight();
                }
            }
        }
        LineRenderEvent lineRenderEvent = bRendering3d ? null : (lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)as), LineRenderEvent.class));
        PolygonRenderEvent polygonRenderEvent = bRendering3d ? null : (pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)as), PolygonRenderEvent.class));
        Line3DRenderEvent line3DRenderEvent = bRendering3d ? (Line3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)as), Line3DRenderEvent.class) : (lre3d = null);
        Polygon3DRenderEvent pre3d = bRendering3d ? (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)as), Polygon3DRenderEvent.class) : null;
        boolean isUseLastState = this.getSeries().isStacked() || this.getAxis().isPercent();
        DeferredCache dc = this.getDeferredCache();
        if (paletteEntry instanceof ColorDefinition && usePaletteLineColor) {
            lia = LineAttributesImpl.copyInstance((LineAttributes)lia);
            lia.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)paletteEntry)));
        }
        if (!bRendering3d) {
            dTapeWidth = srh.getSeriesThickness();
        }
        ArrayList<double[]> points = new ArrayList<double[]>();
        ArrayList<double[]> fixedPoints = new ArrayList<double[]>();
        if (isUseLastState) {
            Object o;
            int i3;
            List lst;
            Object obj = this.getRunTimeContext().getState((Object)AreaSeries.class);
            lastX = null;
            lastY = null;
            if (obj instanceof List && ((List)obj).size() > 0) {
                lst = (List)obj;
                for (i3 = 0; i3 < lst.size(); ++i3) {
                    o = lst.get(i3);
                    if (o instanceof double[]) {
                        if (lastX == null) {
                            lastX = new double[lst.size()];
                            lastY = new double[lastX.length];
                        }
                    } else {
                        lastX = null;
                        lastY = null;
                        break;
                    }
                    lastX[i3] = ((double[])o)[0];
                    lastY[i3] = ((double[])o)[1];
                }
            }
            if ((obj = this.getRunTimeContext().getState((Object)"fixed_stacked_series_index_key")) instanceof Integer && ((Integer)obj).intValue() == this.getPrevVisibleSiblingSeriesIndex(this.iSeriesIndex)) {
                obj = this.getRunTimeContext().getState((Object)"fixed_stacked_series_location_key");
                lastFixedX = null;
                lastFixedY = null;
                if (obj instanceof List && ((List)obj).size() > 0) {
                    lst = (List)obj;
                    for (i3 = 0; i3 < lst.size(); ++i3) {
                        o = lst.get(i3);
                        if (o instanceof double[]) {
                            if (lastFixedX == null) {
                                lastFixedX = new double[lst.size()];
                                lastFixedY = new double[lastFixedX.length];
                            }
                        } else {
                            lastFixedX = null;
                            lastFixedY = null;
                            break;
                        }
                        lastFixedX[i3] = ((double[])o)[0];
                        lastFixedY[i3] = ((double[])o)[1];
                    }
                }
            }
        }
        if (bRendering3d) {
            lre3d.setLineAttributes(lia);
        } else {
            lre.setLineAttributes(lia);
        }
        if (paletteEntry instanceof ColorDefinition) {
            fillColor = ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)paletteEntry));
            tapeColor = ((ColorDefinition)fillColor).brighter();
            sideColor = ((ColorDefinition)fillColor).darker();
        } else {
            fillColor = paletteEntry;
            if (fillColor instanceof Gradient) {
                tapeColor = ((Gradient)fillColor).getStartColor().brighter();
                sideColor = ((Gradient)fillColor).getStartColor().darker();
            } else {
                tapeColor = lia.getColor().brighter();
                sideColor = lia.getColor().darker();
            }
        }
        if (this.getSeries().isSetTranslucent() && this.getSeries().isTranslucent()) {
            if (fillColor instanceof ColorDefinition) {
                fillColor = ((ColorDefinition)fillColor).translucent();
            }
            tapeColor = tapeColor.translucent();
            sideColor = sideColor.translucent();
        }
        int findex = this.getFirstNonNullIndex(dpha);
        int lindex = this.getLastNonNullIndex(dpha);
        if (findex < 0) {
            return;
        }
        if (bRendering3d) {
            loaPlane3d = new Location3D[]{Location3DImpl.create((double)0.0, (double)0.0, (double)0.0), Location3DImpl.create((double)0.0, (double)0.0, (double)0.0), Location3DImpl.create((double)0.0, (double)0.0, (double)0.0), Location3DImpl.create((double)0.0, (double)0.0, (double)0.0)};
            for (int i4 = 1; i4 < dpha.length; ++i4) {
                int pindex2;
                if (Area.isNaN((Object)dpha[i4].getOrthogonalValue()) || (pindex2 = this.getPreviousNonNullIndex(i4, dpha)) == -1) continue;
                double y = this.shear(plotBaseLocation, plotHeight, loa3d[pindex2].getY());
                if (zeroLocation <= y) {
                    loaPlane3d[0].set(loa3d[pindex2].getX(), y, loa3d[pindex2].getZ() - dTapeWidth);
                    loaPlane3d[1].set(loa3d[i4].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i4].getY()), loa3d[i4].getZ() - dTapeWidth);
                    loaPlane3d[2].set(loa3d[i4].getX(), zeroLocation, loa3d[i4].getZ() - dTapeWidth);
                    loaPlane3d[3].set(loa3d[pindex2].getX(), zeroLocation, loa3d[pindex2].getZ() - dTapeWidth);
                } else {
                    loaPlane3d[0].set(loa3d[pindex2].getX(), zeroLocation, loa3d[pindex2].getZ() - dTapeWidth);
                    loaPlane3d[1].set(loa3d[i4].getX(), zeroLocation, loa3d[i4].getZ() - dTapeWidth);
                    loaPlane3d[2].set(loa3d[i4].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i4].getY()), loa3d[i4].getZ() - dTapeWidth);
                    loaPlane3d[3].set(loa3d[pindex2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[pindex2].getY()), loa3d[pindex2].getZ() - dTapeWidth);
                }
                pre3d.setOutline(null);
                pre3d.setPoints3D(loaPlane3d);
                pre3d.setBackground(fillColor);
                pre3d.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i4]));
                dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
            }
            if (findex != -1) {
                if (zeroLocation < loa3d[findex].getY()) {
                    loaPlane3d[0] = (Location3D)EcoreUtil.copy((EObject)loa3d[findex]);
                    loaPlane3d[0].setY(this.shear(plotBaseLocation, plotHeight, loaPlane3d[0].getY()));
                    loaPlane3d[1] = Location3DImpl.create((double)loa3d[findex].getX(), (double)this.shear(plotBaseLocation, plotHeight, loa3d[findex].getY()), (double)(loa3d[findex].getZ() - dTapeWidth));
                    loaPlane3d[2] = Location3DImpl.create((double)loa3d[findex].getX(), (double)zeroLocation, (double)(loa3d[findex].getZ() - dTapeWidth));
                    loaPlane3d[3] = Location3DImpl.create((double)loa3d[findex].getX(), (double)zeroLocation, (double)loa3d[findex].getZ());
                } else {
                    loaPlane3d[0] = (Location3D)EcoreUtil.copy((EObject)loa3d[findex]);
                    loaPlane3d[0].setY(this.shear(plotBaseLocation, plotHeight, loaPlane3d[0].getY()));
                    loaPlane3d[1] = Location3DImpl.create((double)loa3d[findex].getX(), (double)zeroLocation, (double)loa3d[findex].getZ());
                    loaPlane3d[2] = Location3DImpl.create((double)loa3d[findex].getX(), (double)zeroLocation, (double)(loa3d[findex].getZ() - dTapeWidth));
                    loaPlane3d[3] = Location3DImpl.create((double)loa3d[findex].getX(), (double)this.shear(plotBaseLocation, plotHeight, loa3d[findex].getY()), (double)(loa3d[findex].getZ() - dTapeWidth));
                }
                pre3d.setOutline(null);
                pre3d.setBackground((Fill)tapeColor);
                pre3d.setPoints3D(loaPlane3d);
                pre3d.setSourceObject((Object)StructureSource.createSeries((Series)as));
                dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                if (lindex != -1 && findex != lindex) {
                    loaPlane3d[0].set(loa3d[findex].getX(), zeroLocation, loa3d[findex].getZ());
                    loaPlane3d[1].set(loa3d[findex].getX(), zeroLocation, loa3d[findex].getZ() - dTapeWidth);
                    loaPlane3d[2].set(loa3d[lindex].getX(), zeroLocation, loa3d[lindex].getZ() - dTapeWidth);
                    loaPlane3d[3].set(loa3d[lindex].getX(), zeroLocation, loa3d[lindex].getZ());
                    pre3d.setOutline(null);
                    pre3d.setDoubleSided(true);
                    pre3d.setPoints3D(loaPlane3d);
                    pre3d.setBackground(fillColor);
                    pre3d.setSourceObject((Object)StructureSource.createSeries((Series)as));
                    dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                    pre3d.setDoubleSided(false);
                }
            }
        }
        for (i2 = 0; i2 < dpha.length; ++i2) {
            double lastLocation;
            if (bRendering3d) {
                points.add(new double[]{loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ()});
            } else {
                points.add(new double[]{loa[i2].getX(), loa[i2].getY()});
                if (isTransposed) {
                    if (i2 == findex && i2 > 0) {
                        fixedPoints.add(new double[]{this.fixNaN(zeroLocation, Double.NaN, i2 - 1, findex, lindex, loa, lastX, false), loa[i2 - 1].getY()});
                    }
                    fixedPoints.add(new double[]{this.fixNaN(zeroLocation, loa[i2].getX(), i2, findex, lindex, loa, lastX, false), loa[i2].getY()});
                    if (i2 == lindex && i2 != dpha.length - 1) {
                        fixedPoints.add(new double[]{this.fixNaN(zeroLocation, Double.NaN, i2 + 1, findex, lindex, loa, lastX, false), loa[i2 + 1].getY()});
                    }
                } else {
                    if (i2 == findex && i2 > 0) {
                        fixedPoints.add(new double[]{loa[i2 - 1].getX(), this.fixNaN(zeroLocation, Double.NaN, i2 - 1, findex, lindex, loa, lastY, true)});
                    }
                    fixedPoints.add(new double[]{loa[i2].getX(), this.fixNaN(zeroLocation, loa[i2].getY(), i2, findex, lindex, loa, lastY, true)});
                    if (i2 == lindex && i2 != dpha.length - 1) {
                        fixedPoints.add(new double[]{loa[i2 + 1].getX(), this.fixNaN(zeroLocation, Double.NaN, i2 + 1, findex, lindex, loa, lastY, true)});
                    }
                }
            }
            pindex = this.getPreviousNonNullIndex(i2, dpha);
            if (i2 == 0 || pindex < 0 && dpha[i2].getOrthogonalValue() == null) continue;
            if (pindex < 0) {
                pindex = i2 - 1;
            }
            if (!bShowAsTape) continue;
            if (bRendering3d) {
                if (Area.isNaN((Object)dpha[i2].getOrthogonalValue())) continue;
                loaPlane3d[0].set(loa3d[pindex].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[pindex].getY()), loa3d[pindex].getZ());
                loaPlane3d[1].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ());
                loaPlane3d[2].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ() - dTapeWidth);
                loaPlane3d[3].set(loa3d[pindex].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[pindex].getY()), loa3d[pindex].getZ() - dTapeWidth);
                pre3d.setOutline(null);
                pre3d.setBackground((Fill)tapeColor);
                pre3d.setPoints3D(loaPlane3d);
                pre3d.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i2]));
                dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                if (i2 != lindex) continue;
                if (this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()) > zeroLocation) {
                    loaPlane3d[0].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ());
                    loaPlane3d[1].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ());
                    loaPlane3d[2].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ() - dTapeWidth);
                    loaPlane3d[3].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ() - dTapeWidth);
                } else {
                    loaPlane3d[0].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ());
                    loaPlane3d[1].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ() - dTapeWidth);
                    loaPlane3d[2].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ() - dTapeWidth);
                    loaPlane3d[3].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ());
                }
                pre3d.setOutline(null);
                pre3d.setBackground((Fill)sideColor);
                pre3d.setPoints3D(loaPlane3d);
                pre3d.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i2]));
                dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                continue;
            }
            double loX = loa[i2].getX();
            double loY = loa[i2].getY();
            double loXp = loa[i2 - 1].getX();
            double loYp = loa[i2 - 1].getY();
            if (isTransposed) {
                loX = this.fixNaN(zeroLocation, loX, i2, findex, lindex, loa, lastX, false);
                loXp = this.fixNaN(zeroLocation, loXp, i2 - 1, findex, lindex, loa, lastX, false);
            } else {
                loY = this.fixNaN(zeroLocation, loY, i2, findex, lindex, loa, lastY, true);
                loYp = this.fixNaN(zeroLocation, loYp, i2 - 1, findex, lindex, loa, lastY, true);
            }
            if (loaPlane == null) {
                loaPlane = new Location[]{LocationImpl.create((double)loXp, (double)loYp), LocationImpl.create((double)loX, (double)loY), LocationImpl.create((double)(loX + dTapeWidth), (double)(loY - dTapeWidth)), LocationImpl.create((double)(loXp + dTapeWidth), (double)(loYp - dTapeWidth))};
            } else {
                loaPlane[0].set(loXp, loYp);
                loaPlane[1].set(loX, loY);
                loaPlane[2].set(loX + dTapeWidth, loY - dTapeWidth);
                loaPlane[3].set(loXp + dTapeWidth, loYp - dTapeWidth);
            }
            pre.setOutline(null);
            pre.setBackground((Fill)tapeColor);
            pre.setPoints(loaPlane);
            pre.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i2]));
            dc.addPlane((PrimitiveRenderEvent)pre, 2);
            if (i2 == lindex && !this.isRightToLeft()) {
                loaPlane[0].set(loX, loY);
                loaPlane[1].set(loX + dTapeWidth, loY - dTapeWidth);
                if (isTransposed) {
                    lastLocation = this.getLastFixedValue(zeroLocation, loX, loY, lastFixedX, lastFixedY, false);
                    loaPlane[2].set(lastLocation + dTapeWidth, loY - dTapeWidth);
                    loaPlane[3].set(lastLocation, loY);
                } else {
                    lastLocation = this.getLastFixedValue(zeroLocation, loX, loY, lastFixedX, lastFixedY, true);
                    loaPlane[2].set(loX + dTapeWidth, lastLocation - dTapeWidth);
                    loaPlane[3].set(loX, lastLocation);
                }
                pre.setOutline(null);
                pre.setBackground((Fill)sideColor);
                pre.setPoints(loaPlane);
                pre.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i2]));
                dc.addPlane((PrimitiveRenderEvent)pre, 2);
                continue;
            }
            if (pindex != findex || !this.isRightToLeft()) continue;
            loaPlane[0].set(loa[pindex].getX(), loa[pindex].getY());
            loaPlane[1].set(loa[pindex].getX() + dTapeWidth, loa[pindex].getY() - dTapeWidth);
            if (isTransposed) {
                lastLocation = this.getLastFixedValue(zeroLocation, loa[pindex].getX(), loa[pindex].getY(), lastFixedX, lastFixedY, false);
                loaPlane[2].set(lastLocation + dTapeWidth, loa[pindex].getY() - dTapeWidth);
                loaPlane[3].set(lastLocation, loa[pindex].getY());
            } else {
                lastLocation = this.getLastFixedValue(zeroLocation, loa[pindex].getX(), loa[pindex].getY(), lastFixedX, lastFixedY, true);
                loaPlane[2].set(loa[pindex].getX() + dTapeWidth, lastLocation - dTapeWidth);
                loaPlane[3].set(loa[pindex].getX(), lastLocation);
            }
            pre.setOutline(null);
            pre.setBackground((Fill)sideColor);
            pre.setPoints(loaPlane);
            dc.addPlane((PrimitiveRenderEvent)pre, 2);
        }
        if (bRendering3d) {
            for (i2 = 1; i2 < dpha.length; ++i2) {
                if (Area.isNaN((Object)dpha[i2].getOrthogonalValue()) || (pindex = this.getPreviousNonNullIndex(i2, dpha)) == -1) continue;
                if (zeroLocation <= this.shear(plotBaseLocation, plotHeight, loa3d[pindex].getY())) {
                    loaPlane3d[0].set(loa3d[pindex].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[pindex].getY()), loa3d[pindex].getZ());
                    loaPlane3d[1].set(loa3d[pindex].getX(), zeroLocation, loa3d[pindex].getZ());
                    loaPlane3d[2].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ());
                    loaPlane3d[3].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ());
                } else {
                    loaPlane3d[0].set(loa3d[pindex].getX(), zeroLocation, loa3d[pindex].getZ());
                    loaPlane3d[1].set(loa3d[pindex].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[pindex].getY()), loa3d[pindex].getZ());
                    loaPlane3d[2].set(loa3d[i2].getX(), this.shear(plotBaseLocation, plotHeight, loa3d[i2].getY()), loa3d[i2].getZ());
                    loaPlane3d[3].set(loa3d[i2].getX(), zeroLocation, loa3d[i2].getZ());
                }
                pre3d.setOutline(null);
                pre3d.setPoints3D(loaPlane3d);
                pre3d.setBackground(fillColor);
                pre3d.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[i2]));
                dc.addPlane((PrimitiveRenderEvent)pre3d, 2);
                if (!lia.isSetVisible() || !lia.isVisible()) continue;
                Location3D lstart = (Location3D)EcoreUtil.copy((EObject)loa3d[pindex]);
                Location3D lend = (Location3D)EcoreUtil.copy((EObject)loa3d[i2]);
                lstart.setY(this.shear(plotBaseLocation, plotHeight, lstart.getY()));
                lend.setY(this.shear(plotBaseLocation, plotHeight, lend.getY()));
                lre3d.setStart3D(lstart);
                lre3d.setEnd3D(lend);
                dc.addLine((LineRenderEvent)lre3d);
            }
        }
        if (lastX != null) {
            if (findex != -1) {
                ArrayList<Location> lst = new ArrayList<Location>();
                for (i = 0; i < fixedPoints.size(); ++i) {
                    double[] pt = (double[])fixedPoints.get(i);
                    lst.add(LocationImpl.create((double)pt[0], (double)pt[1]));
                }
                if (lastFixedY != null) {
                    for (i = lastFixedY.length - 1; i >= 0; --i) {
                        lst.add(LocationImpl.create((double)lastFixedX[i], (double)lastFixedY[i]));
                    }
                } else {
                    for (i = lastY.length - 1; i >= 0; --i) {
                        lst.add(LocationImpl.create((double)lastX[i], (double)lastY[i]));
                    }
                }
                Location[] pa = lst.toArray(new Location[lst.size()]);
                if ((pa = Area.filterNull((Location[])pa)).length > 3) {
                    pre.setOutline(null);
                    pre.setPoints(pa);
                    pre.setBackground(fillColor);
                    pre.setSourceObject((Object)StructureSource.createSeries((Series)as));
                    dc.addPlane((PrimitiveRenderEvent)pre, 2);
                }
                if (lia.isSetVisible() && lia.isVisible()) {
                    ArrayList<double[]> flst = fixedPoints;
                    Location start = LocationImpl.create((double)0.0, (double)0.0);
                    Location end = LocationImpl.create((double)0.0, (double)0.0);
                    for (int i5 = 0; i5 < flst.size() - 1; ++i5) {
                        int rdx = this.getRealIndexFromFixedIndex(fixedPoints, i5, isTransposed);
                        if (rdx < findex - 1 || rdx > lindex || this.isFirstDupIndex(fixedPoints, i5, isTransposed)) continue;
                        double[] pt = (double[])flst.get(i5);
                        start.set(pt[0], pt[1]);
                        pt = (double[])flst.get(i5 + 1);
                        end.set(pt[0], pt[1]);
                        lre.setStart(start);
                        lre.setEnd(end);
                        lre.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[rdx]));
                        dc.addLine(lre);
                    }
                }
            }
        } else if (!bRendering3d) {
            ArrayList<Location> lst = new ArrayList<Location>();
            for (i = 0; i < fixedPoints.size(); ++i) {
                double[] pt = (double[])fixedPoints.get(i);
                lst.add(LocationImpl.create((double)pt[0], (double)pt[1]));
            }
            if (fixedPoints.size() > 0) {
                if (isTransposed) {
                    lst.add(LocationImpl.create((double)zeroLocation, (double)((double[])fixedPoints.get(fixedPoints.size() - 1))[1]));
                    lst.add(LocationImpl.create((double)zeroLocation, (double)((double[])fixedPoints.get(0))[1]));
                } else {
                    lst.add(LocationImpl.create((double)((double[])fixedPoints.get(fixedPoints.size() - 1))[0], (double)zeroLocation));
                    lst.add(LocationImpl.create((double)((double[])fixedPoints.get(0))[0], (double)zeroLocation));
                }
            }
            Location[] pa = lst.toArray(new Location[lst.size()]);
            pre.setOutline(null);
            pre.setPoints(pa);
            pre.setBackground(fillColor);
            pre.setSourceObject((Object)StructureSource.createSeries((Series)as));
            dc.addPlane((PrimitiveRenderEvent)pre, 2);
            if (lia.isSetVisible() && lia.isVisible()) {
                ArrayList<double[]> flst = fixedPoints;
                Location start = LocationImpl.create((double)0.0, (double)0.0);
                Location end = LocationImpl.create((double)0.0, (double)0.0);
                for (int i6 = 0; i6 < flst.size() - 1; ++i6) {
                    int rdx = this.getRealIndexFromFixedIndex(fixedPoints, i6, isTransposed);
                    if (rdx < findex - 1 || rdx > lindex || this.isFirstDupIndex(fixedPoints, i6, isTransposed)) continue;
                    double[] pt = (double[])flst.get(i6);
                    start.set(pt[0], pt[1]);
                    pt = (double[])flst.get(i6 + 1);
                    end.set(pt[0], pt[1]);
                    lre.setStart(start);
                    lre.setEnd(end);
                    lre.setSourceObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)as, (DataPointHints)dpha[rdx]));
                    dc.addLine(lre);
                }
            }
        }
        if (this.isLastRuntimeSeriesInAxis()) {
            this.getRunTimeContext().putState((Object)AreaSeries.class, null);
            this.getRunTimeContext().putState((Object)"fixed_stacked_series_location_key", null);
            this.getRunTimeContext().putState((Object)"fixed_stacked_series_index_key", null);
        } else {
            this.getRunTimeContext().putState((Object)AreaSeries.class, points);
            this.getRunTimeContext().putState((Object)"fixed_stacked_series_location_key", fixedPoints);
            this.getRunTimeContext().putState((Object)"fixed_stacked_series_index_key", (Object)new Integer(this.iSeriesIndex));
        }
        if (!bRendering3d) {
            dc.flushPlaneAndLine();
        }
    }

    private boolean isFirstDupIndex(List fixedPoints, int fixedIndex, boolean checkX) {
        double lastValue = Double.NaN;
        for (int i = 0; i < fixedPoints.size() - 1; ++i) {
            double currentValue;
            double[] pt = (double[])fixedPoints.get(i);
            if (Double.isNaN(lastValue)) {
                lastValue = checkX ? pt[1] : pt[0];
                continue;
            }
            double d = currentValue = checkX ? pt[1] : pt[0];
            if (currentValue == lastValue) {
                return fixedIndex == i - 1;
            }
            lastValue = currentValue;
        }
        return false;
    }

    private double getLastFixedValue(double zeroLocation, double x, double y, double[] lastX, double[] lastY, boolean checkY) {
        if (lastX == null) {
            return zeroLocation;
        }
        if (checkY) {
            for (int i = 0; i < lastX.length; ++i) {
                if (x != lastX[i]) continue;
                return lastY[i];
            }
        } else {
            for (int i = 0; i < lastY.length; ++i) {
                if (y != lastY[i]) continue;
                return lastX[i];
            }
        }
        return zeroLocation;
    }

    private int getRealIndexFromFixedIndex(List fixedPoints, int fixedIndex, boolean checkX) {
        double lastValue = Double.NaN;
        for (int i = fixedIndex; i >= 0; --i) {
            double currentValue;
            double[] pt = (double[])fixedPoints.get(i);
            if (Double.isNaN(lastValue)) {
                lastValue = checkX ? pt[1] : pt[0];
                continue;
            }
            double d = currentValue = checkX ? pt[1] : pt[0];
            if (currentValue == lastValue) {
                --fixedIndex;
            }
            lastValue = currentValue;
        }
        return fixedIndex;
    }

    private double fixNaN(double baseValue, double currentValue, int currentIndex, int firstNonNullIndex, int lastNonNullIndex, Location[] currentXY, double[] lastValues, boolean fixY) {
        if (!Double.isNaN(currentValue)) {
            return currentValue;
        }
        if (lastValues == null) {
            return baseValue;
        }
        if (!Double.isNaN(lastValues[currentIndex])) {
            return lastValues[currentIndex];
        }
        int pindex = -1;
        for (int i = currentIndex - 1; i >= 0; --i) {
            if (Double.isNaN(lastValues[i])) continue;
            pindex = i;
            break;
        }
        if (pindex == -1) {
            return baseValue;
        }
        int nindex = -1;
        for (int i = currentIndex + 1; i < currentXY.length; ++i) {
            if (Double.isNaN(lastValues[i])) continue;
            nindex = i;
            break;
        }
        if (nindex == -1) {
            return baseValue;
        }
        return lastValues[pindex] + (lastValues[nindex] - lastValues[pindex]) * (double)(currentIndex - pindex) / (double)(nindex - pindex);
    }

    private double shear(double plotBase, double plotHeight, double y) {
        if (y < plotBase) {
            y = plotBase;
        }
        if (y > plotBase + plotHeight) {
            y = plotBase + plotHeight;
        }
        return y;
    }

    protected void renderShadow(IPrimitiveRenderer ipr, Plot p, LineAttributes lia, Location[] loa, boolean bShowAsTape) {
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        LineSeries ls = (LineSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), PolygonRenderEvent.class);
        Location[] loa = new Location[]{LocationImpl.create((double)(bo.getLeft() + 1.0 * this.getDeviceScale()), (double)(bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0 * this.getDeviceScale()), (double)(bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() * 5.0 / 6.0), (double)(bo.getTop() + bo.getHeight() / 3.0)), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() * 2.0 / 3.0), (double)(bo.getTop() + bo.getHeight() / 2.0)), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + 1.0 * this.getDeviceScale()))};
        pre.setBackground(fPaletteEntry);
        pre.setPoints(loa);
        ipr.fillPolygon(pre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (!liaMarker.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.marker.linestyle.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (liaMarker.isVisible()) {
            if (fPaletteEntry instanceof ColorDefinition && ls.isSetPaletteLineColor() && ls.isPaletteLineColor()) {
                liaMarker = LineAttributesImpl.copyInstance((LineAttributes)liaMarker);
                liaMarker.setColor(ColorDefinitionImpl.copyInstance((ColorDefinition)((ColorDefinition)fPaletteEntry)));
            }
            pre.setOutline(liaMarker);
            ipr.drawPolygon(pre);
        }
    }
}

