/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ChartType
extends AbstractEnumerator {
    public static final int PIE = 0;
    public static final int BAR = 1;
    public static final int LINE = 2;
    public static final int COMBO = 3;
    public static final int SCATTER = 4;
    public static final int STOCK = 5;
    public static final ChartType PIE_LITERAL = new ChartType(0, "Pie", "Pie");
    public static final ChartType BAR_LITERAL = new ChartType(1, "Bar", "Bar");
    public static final ChartType LINE_LITERAL = new ChartType(2, "Line", "Line");
    public static final ChartType COMBO_LITERAL = new ChartType(3, "Combo", "Combo");
    public static final ChartType SCATTER_LITERAL = new ChartType(4, "Scatter", "Scatter");
    public static final ChartType STOCK_LITERAL = new ChartType(5, "Stock", "Stock");
    private static final ChartType[] VALUES_ARRAY = new ChartType[]{PIE_LITERAL, BAR_LITERAL, LINE_LITERAL, COMBO_LITERAL, SCATTER_LITERAL, STOCK_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ChartType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChartType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ChartType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChartType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ChartType get(int value) {
        switch (value) {
            case 0: {
                return PIE_LITERAL;
            }
            case 1: {
                return BAR_LITERAL;
            }
            case 2: {
                return LINE_LITERAL;
            }
            case 3: {
                return COMBO_LITERAL;
            }
            case 4: {
                return SCATTER_LITERAL;
            }
            case 5: {
                return STOCK_LITERAL;
            }
        }
        return null;
    }

    private ChartType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

