/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.config;

public class SystemConfigVarManager {
    public String getConfigVar(String key) {
        return System.getProperty(key);
    }

    public String getConfigVar(String key, String defaultValue) {
        String ret = null;
        try {
            ret = this.getConfigVar(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public boolean getConfigBoolean(String key) {
        String booleanValue;
        try {
            booleanValue = this.getConfigVar(key);
        }
        catch (Exception e) {
            return false;
        }
        return booleanValue != null && booleanValue.compareToIgnoreCase("true") == 0;
    }

    public Integer getConfigInteger(String key) {
        try {
            String intString = this.getConfigVar(key);
            if (intString != null) {
                return Integer.valueOf(intString);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getConfigInteger(String key, int defaultValue) {
        try {
            String intString = this.getConfigVar(key);
            if (intString == null) {
                return defaultValue;
            }
            return Integer.valueOf(intString);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

