/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.chart.examples.api.data.autobinding;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;

public class DataRowExpressionEvaluator extends
		DataRowExpressionEvaluatorAdapter
{

	private int k = 0;
	private Object[] column;
	private Map map;

	public DataRowExpressionEvaluator( String[] set, Object[][] data )
	{
		if ( set == null )
		{
			throw new IllegalArgumentException( );
		}

		map = new HashMap( );
		for ( int i = 0; i < set.length; i++ )
		{
			map.put( set[i], data[i] );
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator#evaluate(java.lang.String)
	 */
	public Object evaluate( String expression )
	{
		column = (Object[]) map.get( expression );
		return column[k];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator#first()
	 */
	public boolean first( )
	{
		k = 0;

		if ( map.size( ) > 0 )
		{
			column = (Object[]) map.values( ).iterator( ).next( );

			if ( column != null && k < column.length )
			{
				return true;
			}
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator#next()
	 */
	public boolean next( )
	{
		if ( column != null && k < ( column.length - 1 ) )
		{
			k++;
			return true;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator#close()
	 */
	public void close( )
	{
		// Doing nothing.
	}

}