/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class ArchiveUtil {
    public static String UNIX_SEPERATOR;
    static final String READER_COUNT_FILE_NAME = "/.reader.count";
    static final String[] SKIP_FILES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String generateFullPath(String rootPath, String relativePath) {
        relativePath = ArchiveUtil.convertToSystemString(relativePath);
        if (rootPath != null) {
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
            return rootPath + relativePath;
        }
        return relativePath;
    }

    public static String generateRelativePath(String rootPath, String fullPath) {
        String relativePath = null;
        relativePath = rootPath != null && fullPath.startsWith(rootPath) ? fullPath.substring(rootPath.length()) : fullPath;
        if (!(relativePath = ArchiveUtil.convertToUnixString(relativePath)).startsWith(UNIX_SEPERATOR)) {
            relativePath = UNIX_SEPERATOR + relativePath;
        }
        return relativePath;
    }

    private static String convertToUnixString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator.charAt(0), UNIX_SEPERATOR.charAt(0));
    }

    private static String convertToSystemString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(UNIX_SEPERATOR.charAt(0), File.separator.charAt(0));
    }

    public static synchronized String generateUniqueFileFolderName(String originalName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        String folderName = originalName + "_" + dateTimeString;
        Random generator = new Random();
        File folder = new File(folderName);
        while (folder.exists()) {
            folderName = folderName + generator.nextInt();
            folder = new File(folderName);
        }
        return folderName;
    }

    public static void createParentFolder(File fd) {
        if (fd != null && fd.getParentFile() != null && !fd.getParentFile().exists()) {
            fd.getParentFile().mkdirs();
        }
    }

    public static void DeleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            dirOrFile.delete();
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    ArchiveUtil.DeleteAllFiles(fileList[i]);
                }
            }
            dirOrFile.delete();
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ArchiveUtil.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                File[] dirFiles = file.listFiles();
                ArchiveUtil.zipFiles(zipOut, dirFiles, tempFolderPath);
                continue;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                String relativePath = ArchiveUtil.generateRelativePath(tempFolderPath, file.getPath());
                ZipEntry entry = new ZipEntry(relativePath);
                try {
                    int len;
                    entry.setTime(file.lastModified());
                    zipOut.putNextEntry(entry);
                    byte[] buf = new byte[5120];
                    while ((len = in.read(buf)) > 0) {
                        zipOut.write(buf, 0, len);
                    }
                    continue;
                }
                finally {
                    zipOut.closeEntry();
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipArchive(File zipArchive, String tempFolderPath) {
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = ArchiveUtil.generateFullPath(tempFolderPath, entry.getName());
                    File dir = new File(dirName);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = null;
                try {
                    in = zipFile.getInputStream(entry);
                    File file = new File(ArchiveUtil.generateFullPath(tempFolderPath, entry.getName()));
                    File dir = new File(file.getParent());
                    if (dir.exists()) {
                        if (!$assertionsDisabled && !dir.isDirectory()) {
                            throw new AssertionError();
                        }
                    } else {
                        dir.mkdirs();
                    }
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buf = new byte[5120];
                    try {
                        int len;
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            zipFile.close();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(IDocArchiveReader reader, IDocArchiveWriter writer) throws IOException {
        List streamList = reader.listAllStreams();
        for (int i = 0; i < streamList.size(); ++i) {
            String streamPath = (String)streamList.get(i);
            RAInputStream in = reader.getStream(streamPath);
            try {
                RAOutputStream out = writer.createRandomAccessStream(streamPath);
                try {
                    ArchiveUtil.copyStream(in, out);
                    continue;
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    private static void copyStream(RAInputStream in, RAOutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int readSize = in.read(buf);
        while (readSize != -1) {
            out.write(buf, 0, readSize);
            readSize = in.read(buf);
        }
    }

    public static void archive(String folder, String file) throws IOException {
        ArchiveUtil.archive(folder, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archive(String folderName, IStreamSorter sorter, String fileName) throws IOException {
        folderName = new File(folderName).getCanonicalPath();
        FolderArchiveReader reader = new FolderArchiveReader(folderName);
        try {
            reader.open();
            ArchiveUtil.DeleteAllFiles(new File(fileName));
            FileArchiveWriter writer = new FileArchiveWriter(fileName);
            try {
                writer.initialize();
                ArchiveUtil.copy(reader, writer);
            }
            finally {
                writer.finish();
            }
        }
        finally {
            reader.close();
        }
    }

    static boolean needSkip(String file) {
        for (int i = 0; i < SKIP_FILES.length; ++i) {
            if (!SKIP_FILES[i].equals(file)) continue;
            return true;
        }
        return false;
    }

    public static void listAllFiles(File dir, ArrayList fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ArchiveUtil.listAllFiles(file, fileList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expand(String file, String folder) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(file);
        try {
            reader.open();
            reader.expandFileArchive(folder);
        }
        finally {
            reader.close();
        }
    }

    public static final int bytesToInteger(byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final int bytesToInteger(byte[] b, int off) {
        if (!$assertionsDisabled && b.length - off < 4) {
            throw new AssertionError();
        }
        return ((b[off++] & 0xFF) << 24) + ((b[off++] & 0xFF) << 16) + ((b[off++] & 0xFF) << 8) + ((b[off] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final long bytesToLong(byte[] b, int off) {
        if (!$assertionsDisabled && b.length - off < 8) {
            throw new AssertionError();
        }
        return (((long)b[off++] & 0xFFL) << 56) + (((long)b[off++] & 0xFFL) << 48) + (((long)b[off++] & 0xFFL) << 40) + (((long)b[off++] & 0xFFL) << 32) + (((long)b[off++] & 0xFFL) << 24) + (((long)b[off++] & 0xFFL) << 16) + (((long)b[off++] & 0xFFL) << 8) + (((long)b[off] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void integerToBytes(int v, byte[] b, int off) {
        if (!$assertionsDisabled && b.length - off < 4) {
            throw new AssertionError();
        }
        b[off++] = (byte)(v >>> 24 & 0xFF);
        b[off++] = (byte)(v >>> 16 & 0xFF);
        b[off++] = (byte)(v >>> 8 & 0xFF);
        b[off] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final void longToBytes(long v, byte[] b, int off) {
        if (!$assertionsDisabled && b.length - off < 8) {
            throw new AssertionError();
        }
        b[off++] = (byte)(v >>> 56 & 0xFFL);
        b[off++] = (byte)(v >>> 48 & 0xFFL);
        b[off++] = (byte)(v >>> 40 & 0xFFL);
        b[off++] = (byte)(v >>> 32 & 0xFFL);
        b[off++] = (byte)(v >>> 24 & 0xFFL);
        b[off++] = (byte)(v >>> 16 & 0xFFL);
        b[off++] = (byte)(v >>> 8 & 0xFFL);
        b[off] = (byte)(v >>> 0 & 0xFFL);
    }

    static {
        $assertionsDisabled = !ArchiveUtil.class.desiredAssertionStatus();
        UNIX_SEPERATOR = "/";
        SKIP_FILES = new String[]{READER_COUNT_FILE_NAME};
    }
}

