/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    ArchiveFile archive;
    HashSet streams;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
        this.streams = new HashSet();
    }

    public ArchiveWriter(ArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
        this.streams = new HashSet();
    }

    public ArchiveFile getArchive() {
        return this.archive;
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.createEntry(relativePath);
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(relativePath);
        if (entry == null) {
            entry = this.archive.createEntry(relativePath);
        }
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public boolean dropStream(String relativePath) {
        try {
            return this.archive.removeEntry(relativePath);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean exists(String relativePath) {
        return this.archive.exists(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            ArrayList unclosedStreams = new ArrayList();
            unclosedStreams.addAll(this.streams);
            Iterator iter = unclosedStreams.iterator();
            while (iter.hasNext()) {
                RAOutputStream stream = (RAOutputStream)iter.next();
                stream.close();
            }
            this.archive.flush();
        }
        finally {
            if (!this.shareArchive) {
                this.archive.close();
            }
        }
    }

    public void flush() throws IOException {
        ArrayList unclosedStreams = new ArrayList();
        unclosedStreams.addAll(this.streams);
        Iterator iter = unclosedStreams.iterator();
        while (iter.hasNext()) {
            RAOutputStream stream = (RAOutputStream)iter.next();
            stream.flush();
        }
        this.archive.flush();
    }

    public String getName() {
        return this.archive.getName();
    }

    public void initialize() throws IOException {
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    public Object lock(String stream) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(stream);
        if (entry == null) {
            entry = this.archive.createEntry(stream);
        }
        if (entry != null) {
            return this.archive.lockEntry(entry);
        }
        throw new IOException("can't find the entry " + stream);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void registerStream(ArchiveEntryOutputStream stream) {
        this.streams.add(stream);
    }

    void unregisterStream(ArchiveEntryOutputStream stream) {
        this.streams.remove(stream);
    }
}

