/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import com.ibm.icu.util.Calendar;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.bre.Function_temp;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class BirtDateTime
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat abbrMonthFormat = null;
    private static SimpleDateFormat monthFormat = null;
    private static SimpleDateFormat abbrWeekFormat = null;
    private static SimpleDateFormat weekFormat = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getAbbrMonthFormat() {
        if (abbrMonthFormat != null) {
            return abbrMonthFormat;
        }
        try {
            Locale defaultLocale = Context.enter().getLocale();
            SimpleDateFormat simpleDateFormat = abbrMonthFormat = new SimpleDateFormat("MMM", defaultLocale);
            return simpleDateFormat;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getMonthFormat() {
        if (monthFormat != null) {
            return monthFormat;
        }
        try {
            Locale defaultLocale = Context.enter().getLocale();
            SimpleDateFormat simpleDateFormat = monthFormat = new SimpleDateFormat("MMMM", defaultLocale);
            return simpleDateFormat;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getAbbrWeekFormat() {
        if (abbrWeekFormat != null) {
            return abbrWeekFormat;
        }
        try {
            Locale defaultLocale = Context.enter().getLocale();
            SimpleDateFormat simpleDateFormat = abbrWeekFormat = new SimpleDateFormat("EEE", defaultLocale);
            return simpleDateFormat;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getWeekFormat() {
        if (weekFormat != null) {
            return weekFormat;
        }
        try {
            Locale defaultLocale = Context.enter().getLocale();
            SimpleDateFormat simpleDateFormat = weekFormat = new SimpleDateFormat("EEEE", defaultLocale);
            return simpleDateFormat;
        }
        finally {
            Context.exit();
        }
    }

    public BirtDateTime() {
        this.defineProperty("year", (Object)new Function_Year(), 0);
        this.defineProperty("quarter", (Object)new Function_Quarter(), 0);
        this.defineProperty("month", (Object)new Function_Month(), 0);
        this.defineProperty("week", (Object)new Function_Week(), 0);
        this.defineProperty("day", (Object)new Function_Day(), 0);
        this.defineProperty("weekDay", (Object)new Function_WeekDay(), 0);
        this.defineProperty("today", (Object)new Function_Today(), 0);
        this.defineProperty("now", (Object)new Function_Now(), 0);
        this.defineProperty("diffYear", (Object)new Function_DiffYear(), 0);
        this.defineProperty("diffMonth", (Object)new Function_DiffMonth(), 0);
        this.defineProperty("diffQuarter", (Object)new Function_DiffQuarter(), 0);
        this.defineProperty("diffWeek", (Object)new Function_DiffWeek(), 0);
        this.defineProperty("diffDay", (Object)new Function_DiffDay(), 0);
        this.defineProperty("diffHour", (Object)new Function_DiffHour(), 0);
        this.defineProperty("diffMinute", (Object)new Function_DiffMinute(), 0);
        this.defineProperty("diffSecond", (Object)new Function_DiffSecond(), 0);
        this.defineProperty("addYear", (Object)new Function_AddYear(), 0);
        this.defineProperty("addMonth", (Object)new Function_AddMonth(), 0);
        this.defineProperty("addQuarter", (Object)new Function_AddQuarter(), 0);
        this.defineProperty("addWeek", (Object)new Function_AddWeek(), 0);
        this.defineProperty("addDay", (Object)new Function_AddDay(), 0);
        this.defineProperty("addHour", (Object)new Function_AddHour(), 0);
        this.defineProperty("addMinute", (Object)new Function_AddMinute(), 0);
        this.defineProperty("addSecond", (Object)new Function_AddSecond(), 0);
    }

    private static int year(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(1);
    }

    private static int quarter(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int month = BirtDateTime.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static int month(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(2) + 1;
    }

    private static String month(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = BirtDateTime.getCalendar(d);
        int month = c.get(2);
        if (option == 1) {
            return String.valueOf(month + 1);
        }
        if (option == 2) {
            return BirtDateTime.getMonthFormat().format(d);
        }
        if (option == 3) {
            return BirtDateTime.getAbbrMonthFormat().format(d);
        }
        return null;
    }

    private static int week(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(3);
    }

    private static int day(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(5);
    }

    private static String weekDay(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return String.valueOf(BirtDateTime.getCalendar(d).get(7));
    }

    private static String weekDay(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        switch (option) {
            case 1: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 1));
            }
            case 2: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2));
            }
            case 3: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2) - 1);
            }
            case 4: {
                return BirtDateTime.getWeekFormat().format(d);
            }
            case 5: {
                return BirtDateTime.getAbbrWeekFormat().format(d);
            }
        }
        return null;
    }

    private static Timestamp today() {
        Calendar c = Calendar.getInstance();
        return new Timestamp(c.getTimeInMillis());
    }

    private static Timestamp now() {
        Date now = new Date();
        return new Timestamp(now.getTime());
    }

    private static int diffYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startYear = BirtDateTime.year(d1);
        int endYear = BirtDateTime.year(d2);
        return endYear - startYear;
    }

    private static int diffMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startMonth = BirtDateTime.year(d1) * 12 + BirtDateTime.month(d1);
        int endMonth = BirtDateTime.year(d2) * 12 + BirtDateTime.month(d2);
        return endMonth - startMonth;
    }

    private static int diffQuarter(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startQuter = BirtDateTime.year(d1) * 4 + BirtDateTime.quarter(d1);
        int endQuter = BirtDateTime.year(d2) * 4 + BirtDateTime.quarter(d2);
        return endQuter - startQuter;
    }

    private static long diffWeek(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 7);
        Date baseDay = new Date(c.getTimeInMillis());
        int diffDay = 1 - Integer.valueOf(BirtDateTime.weekDay(baseDay));
        baseDay = BirtDateTime.addDay(baseDay, diffDay);
        return (BirtDateTime.diffSecond(baseDay, d2) + 1814400000L) / 604800L - (BirtDateTime.diffSecond(baseDay, d1) + 1814400000L) / 604800L;
    }

    private static long diffDay(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 1);
        return (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 86400L - (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 86400L;
    }

    private static long diffHour(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 1);
        return (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 3600L - (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 3600L;
    }

    private static long diffMinute(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 1);
        return (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 60L - (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 60L;
    }

    private static Calendar getClearedCalendarInstance(int year, int month, int date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month, date);
        return c;
    }

    private static long diffSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        long diff = d2.getTime() - d1.getTime();
        return new Long(diff / 1000L);
    }

    private static Date addYear(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(1, num);
        return startCal.getTime();
    }

    private static Date addMonth(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(2, num);
        return startCal.getTime();
    }

    private static Date addQuarter(Date date, int num) {
        return BirtDateTime.addMonth(date, num * 3);
    }

    private static Date addWeek(Date date, int num) {
        return BirtDateTime.addDay(date, num * 7);
    }

    private static Date addDay(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    private static Date addHour(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(11, num);
        return startCal.getTime();
    }

    private static Date addMinute(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(12, num);
        return startCal.getTime();
    }

    private static Date addSecond(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(13, num);
        return startCal.getTime();
    }

    private static int getWeekDay(Date d, int startDay) {
        int dayOfWeek = BirtDateTime.getCalendar(d).get(7);
        if (dayOfWeek >= startDay) {
            return dayOfWeek - startDay + 1;
        }
        return (dayOfWeek - startDay + 1 + 7) % 8;
    }

    private static Calendar getCalendar(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public String getClassName() {
        return "BirtDateTime";
    }

    private class Function_AddSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddSecond() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addSecond(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMinute() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addMinute(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddHour() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addHour(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddDay() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addDay(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddWeek() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addWeek(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddQuarter() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addQuarter(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMonth() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addMonth(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddYear() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.addYear(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_DiffSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffSecond() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Long(BirtDateTime.diffSecond(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMinute() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Long(BirtDateTime.diffMinute(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffHour() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Long(BirtDateTime.diffHour(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffDay() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Long(BirtDateTime.diffDay(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffWeek() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Long(BirtDateTime.diffWeek(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffQuarter() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.diffQuarter(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMonth() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.diffMonth(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_DiffYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffYear() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.diffYear(DataTypeUtil.toDate(args[0]), DataTypeUtil.toDate(args[1])));
        }
    }

    private class Function_Now
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Now() {
            this.length = 0;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.now();
        }
    }

    private class Function_Today
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Today() {
            this.length = 0;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.today();
        }
    }

    private class Function_WeekDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekDay() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return BirtDateTime.weekDay(DataTypeUtil.toDate(args[0]));
            }
            return BirtDateTime.weekDay(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_Day
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Day() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.day(DataTypeUtil.toDate(args[0])));
        }
    }

    private class Function_Week
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Week() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.week(DataTypeUtil.toDate(args[0])));
        }
    }

    private class Function_Month
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Month() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Integer(BirtDateTime.month(DataTypeUtil.toDate(args[0])));
            }
            return BirtDateTime.month(DataTypeUtil.toDate(args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_Quarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Quarter() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.quarter(DataTypeUtil.toDate(args[0])));
        }
    }

    private class Function_Year
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Year() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Integer(BirtDateTime.year(DataTypeUtil.toDate(args[0])));
        }
    }
}

