/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import java.util.regex.Pattern;
import org.eclipse.birt.core.script.bre.BreUtility;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BirtStr
extends ScriptableObject {
    private static final long serialVersionUID = 1L;

    public BirtStr() {
        this.defineProperty("left", (Object)new Function_Left(), 0);
        this.defineProperty("right", (Object)new Function_Right(), 0);
        this.defineProperty("concat", (Object)new Function_Concat(), 0);
        this.defineProperty("toUpper", (Object)new Function_ToUpper(), 0);
        this.defineProperty("toLower", (Object)new Function_ToLower(), 0);
        this.defineProperty("trim", (Object)new Function_Trim(), 0);
        this.defineProperty("trimLeft", (Object)new Function_TrimLeft(), 0);
        this.defineProperty("trimRight", (Object)new Function_TrimRight(), 0);
        this.defineProperty("indexOf", (Object)new Function_IndexOf(), 0);
        this.defineProperty("search", (Object)new Function_Search(), 0);
        this.defineProperty("charLength", (Object)new Function_CharLength(), 0);
    }

    public String getClassName() {
        return "BirtStr";
    }

    private class Function_CharLength
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_CharLength() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return new Integer(this.charLength((args = BreUtility.convertToJavaObjects(args))[0] == null ? null : (String)args[0]));
        }

        private int charLength(String str) {
            if (str == null) {
                return 0;
            }
            return str.length();
        }
    }

    private class Function_Search
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_Search() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if ((args = BreUtility.convertToJavaObjects(args)).length == 3) {
                return new Integer(this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return new Integer(this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]));
        }

        private int search(String pattern, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException();
            }
            if (pattern == null || str == null) {
                return -1;
            }
            String subStr = str.substring(start);
            String newStr = pattern.replaceAll("\\Q?\\E", ".");
            String finalStr = newStr.replaceAll("\\Q*\\E", ".*");
            Pattern p = Pattern.compile(finalStr);
            String[] split = p.split(subStr);
            if (split[0].length() != subStr.length()) {
                return split[0].length() + start;
            }
            return -1;
        }

        private int search(String pattern, String str) {
            return this.search(pattern, str, 0);
        }
    }

    private class Function_IndexOf
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_IndexOf() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if ((args = BreUtility.convertToJavaObjects(args)).length == 3) {
                return new Integer(this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return new Integer(this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]));
        }

        private int indexOf(String find_text, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException();
            }
            if (find_text == null || str == null || str.indexOf(find_text) < 0) {
                return -1;
            }
            return str.indexOf(find_text, start);
        }

        private int indexOf(String find_text, String str) {
            return this.indexOf(find_text, str, 0);
        }
    }

    private class Function_TrimRight
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_TrimRight() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trimRight((args = BreUtility.convertToJavaObjects(args))[0] == null ? null : (String)args[0]);
        }

        private String trimRight(String str) {
            int end;
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            for (end = str.length(); end < str.length() && value[str.length() - 1] <= 32; --end) {
            }
            return end < str.length() ? str.substring(0, end) : str;
        }
    }

    private class Function_TrimLeft
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_TrimLeft() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trimLeft((args = BreUtility.convertToJavaObjects(args))[0] == null ? null : (String)args[0]);
        }

        private String trimLeft(String str) {
            int st;
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            for (st = 0; st < str.length() && value[st] <= 32; ++st) {
            }
            return st > 0 ? str.substring(st, str.length()) : str;
        }
    }

    private class Function_Trim
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_Trim() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return this.trim((args = BreUtility.convertToJavaObjects(args))[0] == null ? null : (String)args[0]);
        }

        private String trim(String str) {
            if (str == null) {
                return null;
            }
            String trimStr = str.trim();
            return trimStr.replaceAll("\\s+", " ");
        }
    }

    private class Function_ToLower
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_ToLower() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return (args = BreUtility.convertToJavaObjects(args))[0] == null ? null : ((String)args[0]).toLowerCase();
        }
    }

    private class Function_ToUpper
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_ToUpper() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 1) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            return (args = BreUtility.convertToJavaObjects(args))[0] == null ? null : ((String)args[0]).toUpperCase();
        }
    }

    private class Function_Concat
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_Concat() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            args = BreUtility.convertToJavaObjects(args);
            String result = "";
            for (int i = 0; i < args.length; ++i) {
                result = result + args[i];
            }
            return result;
        }
    }

    private class Function_Right
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_Right() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length > 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if ((args = BreUtility.convertToJavaObjects(args)).length == 1) {
                return this.right(args[0] == null ? null : (String)args[0]);
            }
            return this.right(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }

        public String right(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(str.length() - n, str.length());
        }

        public String right(String str) {
            return this.right(str, 1);
        }
    }

    private class Function_Left
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_Left() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length > 2) {
                throw new IllegalArgumentException("The number of arguement is incorrect.");
            }
            if ((args = BreUtility.convertToJavaObjects(args)).length == 1) {
                return this.left(args[0] == null ? null : (String)args[0]);
            }
            return this.left(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }

        private String left(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(0, n);
        }

        private String left(String str) {
            return this.left(str, 1);
        }
    }
}

