/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.ui.wizards;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.xml.impl.Driver;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class DataSetDesignPopulator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateResultSet(DataSetDesign dataSetDesign) {
        IConnection conn = null;
        try {
            Driver jdbcDriver = new Driver();
            conn = jdbcDriver.getConnection(null);
            Properties properties = new Properties();
            String xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE");
            if (xmlFile == null || xmlFile.trim().length() == 0) {
                xmlFile = XMLInformationHolder.getPropertyValue("FILELIST");
            }
            properties.setProperty("FILELIST", xmlFile == null ? "" : xmlFile);
            conn.open(properties);
            IQuery query = conn.newQuery(null);
            query.setMaxRows(1);
            query.prepare(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            IResultSetMetaData metadata = query.getMetaData();
            DataSetDesignPopulator.setResultSetMetaData(dataSetDesign, metadata);
        }
        catch (OdaException e) {
            try {
                dataSetDesign.setResultSets(null);
            }
            catch (Throwable throwable) {
                DataSetDesignPopulator.closeConnection(conn);
                throw throwable;
            }
            DataSetDesignPopulator.closeConnection(conn);
        }
        DataSetDesignPopulator.closeConnection(conn);
    }

    private static void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private static void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }
}

