/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.DiskDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.MemoryDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.odi.IResultClass;

class CacheMapManager {
    private FolderUtil folderUtil = new FolderUtil();
    private String tempDir;
    private static Integer cacheCounter1 = new Integer(0);
    private static Integer cacheCounter2 = new Integer(0);
    private static Map cacheMap = new HashMap();

    CacheMapManager(String tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesSaveToCache(DataSourceAndDataSet dsAndDs, int mode) {
        String cacheObject = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheObject = (String)cacheMap.get(dsAndDs);
        }
        if (cacheObject != null) {
            return this.needSaveToCache(cacheObject);
        }
        map = cacheMap;
        synchronized (map) {
            cacheObject = (String)cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                return this.needSaveToCache(cacheObject);
            }
            cacheMap.put(dsAndDs, mode == 1 ? new MemoryDataSetCacheObject() : new DiskDataSetCacheObject(this.folderUtil.createSessionTempDir()));
            return true;
        }
    }

    private boolean needSaveToCache(Object cacheObject) {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            DiskDataSetCacheObject diskCacheObject = (DiskDataSetCacheObject)cacheObject;
            return !diskCacheObject.getDataFile().exists() || !diskCacheObject.getMetaFile().exists();
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return ((MemoryDataSetCacheObject)cacheObject).needPopulateResult();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesLoadFromCache(DataSourceAndDataSet dsAndDs) {
        Object cacheDirStr = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheDirStr = cacheMap.get(dsAndDs);
        }
        if (cacheDirStr != null) {
            return !this.needSaveToCache(cacheDirStr);
        }
        return false;
    }

    IDataSetCacheObject getCacheObject(DataSourceAndDataSet dsAndDs) {
        return (IDataSetCacheObject)cacheMap.get(dsAndDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(DataSourceAndDataSet dsAndDs) {
        ArrayList cacheDir = new ArrayList();
        Map map = cacheMap;
        synchronized (map) {
            while (this.getKey(dsAndDs) != null) {
                cacheDir.add(cacheMap.remove(this.getKey(dsAndDs)));
            }
        }
        for (int i = 0; i < cacheDir.size(); ++i) {
            if (!(cacheDir.get(i) instanceof DiskDataSetCacheObject)) continue;
            this.folderUtil.deleteDir(((DiskDataSetCacheObject)cacheDir.get(i)).getTempDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        CacheMapManager cacheMapManager = this;
        synchronized (cacheMapManager) {
            cacheMap = new HashMap();
            this.folderUtil = new FolderUtil();
        }
    }

    IResultClass getCachedResultClass(DataSourceAndDataSet dsAndDs) throws DataException {
        Object cacheObject = null;
        Object key = this.getKey(dsAndDs);
        if (key != null) {
            cacheObject = cacheMap.get(key);
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return ((MemoryDataSetCacheObject)cacheObject).getResultClass();
        }
        if (cacheObject instanceof DiskDataSetCacheObject) {
            FileInputStream fis1 = null;
            BufferedInputStream bis1 = null;
            try {
                fis1 = new FileInputStream(((DiskDataSetCacheObject)cacheObject).getMetaFile());
                bis1 = new BufferedInputStream(fis1);
                IOUtil.readInt((InputStream)bis1);
                ResultClass rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                return rsClass;
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }
        return null;
    }

    private Object getKey(DataSourceAndDataSet dsAndDs) {
        Iterator it = cacheMap.keySet().iterator();
        while (it.hasNext()) {
            DataSourceAndDataSet temp = (DataSourceAndDataSet)it.next();
            if (!temp.isDataSourceDataSetEqual(dsAndDs, false)) continue;
            return temp;
        }
        return null;
    }

    private class FolderUtil {
        private String tempRootDirStr = null;

        private FolderUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTempRootDir() {
            if (this.tempRootDirStr != null && new File(this.tempRootDirStr).exists()) {
                return;
            }
            File tempDtEDir = null;
            Integer n = cacheCounter1;
            synchronized (n) {
                tempDtEDir = new File(CacheMapManager.this.tempDir, "BirtDataCache" + System.currentTimeMillis() + cacheCounter1);
                cacheCounter1 = new Integer(cacheCounter1 + 1);
                int x = 0;
                while (tempDtEDir.exists()) {
                    tempDtEDir = new File(CacheMapManager.this.tempDir, "BirtDataCache" + System.currentTimeMillis() + cacheCounter1 + "_" + ++x);
                }
                tempDtEDir.mkdir();
                tempDtEDir.deleteOnExit();
            }
            try {
                this.tempRootDirStr = tempDtEDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createSessionTempDir() {
            this.createTempRootDir();
            String prefix = "session_";
            Integer n = cacheCounter2;
            synchronized (n) {
                String sessionTempDir = this.tempRootDirStr + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2;
                cacheCounter2 = new Integer(cacheCounter2 + 1);
                File sessionDirFile = new File(sessionTempDir);
                int x = 0;
                while (sessionDirFile.exists()) {
                    sessionTempDir = this.tempRootDirStr + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2 + "_" + ++x;
                    sessionDirFile = new File(sessionTempDir);
                }
                sessionDirFile.mkdir();
                sessionDirFile.deleteOnExit();
                return sessionTempDir;
            }
        }

        private void deleteDir(String dirStr) {
            File sessionsFolder = new File(dirStr);
            if (!sessionsFolder.exists()) {
                return;
            }
            File[] sessionFiles = sessionsFolder.listFiles();
            for (int i = 0; i < sessionFiles.length; ++i) {
                sessionFiles[i].delete();
            }
            sessionsFolder.delete();
        }
    }
}

