/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.ExpandableRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskCache;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class SmartCacheHelper {
    private ResultSetCache resultSetCache;
    private IEventHandler eventHandler;
    private static Logger logger;
    private DataEngineSession session;
    static final /* synthetic */ boolean $assertionsDisabled;

    SmartCacheHelper(DataEngineSession session) {
        this.session = session;
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        if (!$assertionsDisabled && cacheRequest == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && odaResultSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        if (cacheRequest.getDistinctValueFlag()) {
            SmartCacheHelper smartCacheHelper = new SmartCacheHelper(this.session);
            ResultSetCache smartCache = smartCacheHelper.getDistinctResultSetCache(cacheRequest, odaResultSet, rsMeta);
            cacheRequest.setDistinctValueFlag(false);
            this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        } else {
            this.initOdaResult(cacheRequest, odaResultSet, rsMeta);
        }
        return this.resultSetCache;
    }

    private ResultSetCache getDistinctResultSetCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(this.session);
        ResultSetCache smartCache = smartCacheHelper.getSortedResultSetCache(new CacheRequest(0, null, CacheUtil.getSortSpec(rsMeta), cacheRequest.getEventHandler(), true), odaResultSet, rsMeta);
        this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        return this.resultSetCache;
    }

    private ResultSetCache getSortedResultSetCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        this.initOdaResult(cacheRequest, odaResultSet, rsMeta);
        return this.resultSetCache;
    }

    private void initOdaResult(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        OdiAdapter odiAdpater = new OdiAdapter(odaResultSet);
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, ResultSetCache resultCache, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        if (!$assertionsDisabled && cacheRequest == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resultCache == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        OdiAdapter odiAdpater = new OdiAdapter(resultCache);
        this.initSubResult(cacheRequest, resultCache, odiAdpater, startIndex, endIndex, rsMeta);
        return this.resultSetCache;
    }

    private void initSubResult(CacheRequest cacheRequest, ResultSetCache resultCache, OdiAdapter odiAdpater, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        int length = endIndex - startIndex;
        if (cacheRequest.getMaxRow() <= 0 || length <= cacheRequest.getMaxRow()) {
            cacheRequest.setMaxRow(length);
        }
        int oldIndex = resultCache.getCurrentIndex();
        resultCache.moveTo(startIndex - 1);
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
        resultCache.moveTo(oldIndex);
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta) throws DataException {
        this.initInstance(cacheRequest, odiAdapter, rsMeta);
        return this.resultSetCache;
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, IRowResultSet rowResultSet, IResultClass rsMeta) throws DataException {
        this.eventHandler = cacheRequest.getEventHandler();
        this.populateData(rowResultSet, rsMeta, cacheRequest.getSortSpec());
        return this.resultSetCache;
    }

    private void initInstance(CacheRequest cacheRequest, OdiAdapter odiAdpater, IResultClass rsMeta) throws DataException {
        this.eventHandler = cacheRequest.getEventHandler();
        ExpandableRowResultSet rowResultSet = new ExpandableRowResultSet(new SmartCacheRequest(cacheRequest.getMaxRow(), cacheRequest.getFetchEvents(), odiAdpater, rsMeta, cacheRequest.getDistinctValueFlag()));
        this.populateData(rowResultSet, rsMeta, cacheRequest.getSortSpec());
    }

    private void populateData(IRowResultSet rowResultSet, IResultClass rsMeta, SortSpec sortSpec) throws DataException {
        IResultObject[] resultObjects;
        IResultObject odaObject;
        long startTime = System.currentTimeMillis();
        int memBufferMaxSize = CacheUtil.computeMemoryBufferSize(this.eventHandler.getAppContext());
        SizeOfUtil sou = new SizeOfUtil(rsMeta);
        logger.fine("memoryBufferSize is " + memBufferMaxSize);
        ArrayList<IResultObject> resultObjectsList = new ArrayList<IResultObject>();
        int dataCount = 0;
        int inMemBufferSize = 0;
        while ((odaObject = rowResultSet.next()) != null) {
            if (inMemBufferSize <= memBufferMaxSize) {
                int metaFieldCount;
                ++dataCount;
                int odaObjectFieldCount = odaObject.getResultClass().getFieldCount();
                if (odaObjectFieldCount < (metaFieldCount = rsMeta.getFieldCount())) {
                    Object[] obs = new Object[metaFieldCount];
                    for (int i = 1; i <= odaObjectFieldCount; ++i) {
                        obs[i - 1] = odaObject.getFieldValue(i);
                    }
                    ResultObject ro = new ResultObject(rsMeta, obs);
                    resultObjectsList.add(ro);
                    inMemBufferSize += sou.sizeOf(ro);
                    continue;
                }
                inMemBufferSize += sou.sizeOf(odaObject);
                resultObjectsList.add(odaObject);
                continue;
            }
            logger.info("DisckCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new DiskCache(resultObjects, odaObject, rowResultSet, rsMeta, CacheUtil.getComparator(sortSpec, this.eventHandler), dataCount, this.session);
            break;
        }
        if (this.resultSetCache == null) {
            logger.info("MemoryCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new MemoryCache(resultObjects, rsMeta, CacheUtil.getComparator(sortSpec, this.eventHandler));
        }
        odaObject = null;
        resultObjects = null;
        resultObjectsList = null;
        rowResultSet = null;
        long consumedTime = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info("Time consumed by cache is: " + consumedTime + " second");
    }

    static {
        $assertionsDisabled = !SmartCacheHelper.class.desiredAssertionStatus();
        logger = Logger.getLogger(SmartCache.class.getName());
    }
}

