/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.RowProcessUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.odi.IResultClass;

class ResultSetProcessUtil
extends RowProcessUtil {
    private List cachedSort;

    private ResultSetProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) {
        super(populator, iccState, computedColumnHelper, filterByRow, psController, session);
    }

    public static void doPopulate(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, List sortList, DataEngineSession session) throws DataException {
        ResultSetProcessUtil instance = new ResultSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController, session);
        instance.cachedSort = sortList;
        instance.populateResultSet();
    }

    private void populateResultSet() throws DataException {
        List aggCCList = this.prepareComputedColumns(1);
        this.doRowFiltering();
        this.populateTempComputedColumns(aggCCList);
        this.doGroupFiltering();
        this.doRowSorting();
        this.doGroupSorting();
        this.clearTemporaryComputedColumns(this.iccState);
    }

    private void populateTempComputedColumns(List aggCCList) throws DataException {
        if (this.psController.needDoOperation(4)) {
            if (!this.psController.needDoOperation(3)) {
                PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true, this.session);
            }
            if (aggCCList.size() != 0) {
                this.computedColumnHelper.getComputedColumnList().clear();
                this.computedColumnHelper.getComputedColumnList().addAll(aggCCList);
                this.computedColumnHelper.setRePrepare(true);
                IExpressionProcessor ep = this.populator.getExpressionProcessor();
                ep.setResultIterator(this.populator.getResultIterator());
                while (!this.isICCStateFinish()) {
                    ep.evaluateMultiPassExprOnCmp(this.iccState, false);
                }
            }
            this.doGroupRowFilter();
        }
    }

    private void doGroupSorting() throws DataException {
        if (this.populator.getQuery().getGrouping() != null && this.populator.getQuery().getGrouping().length > 0) {
            this.populator.getGroupProcessorManager().doGroupSorting(this.populator.getCache(), this.populator.getExpressionProcessor());
        }
    }

    private void doRowSorting() throws DataException {
        this.populator.getQuery().setOrdering(this.cachedSort);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true, this.session);
    }

    private void doGroupFiltering() throws DataException {
        if (this.populator.getQuery().getGrouping() != null && this.populator.getQuery().getGrouping().length > 0) {
            this.populator.getGroupProcessorManager().doGroupFiltering(this.populator.getCache(), this.populator.getExpressionProcessor());
        }
    }

    private void doRowFiltering() throws DataException {
        if (!this.psController.needDoOperation(3)) {
            return;
        }
        boolean changeMaxRows = this.filterByRow.getFilterList(5).size() > 0;
        this.applyFilters(2, changeMaxRows);
        this.filterByRow.setWorkingFilterSet(4);
    }

    private boolean isICCStateFinish() {
        for (int i = 0; i < this.iccState.getCount(); ++i) {
            if (this.iccState.isValueAvailable(i)) continue;
            return false;
        }
        return true;
    }

    private void doGroupRowFilter() throws DataException {
        if (!this.psController.needDoOperation(5)) {
            return;
        }
        this.filterByRow.setWorkingFilterSet(5);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true, this.session);
        this.filterByRow.setWorkingFilterSet(4);
    }

    private void clearTemporaryComputedColumns(ComputedColumnsState iccState) throws DataException {
        if (!this.psController.needDoOperation(4)) {
            return;
        }
        iccState.setModel(2);
        this.populator.getExpressionProcessor().clear();
        this.computedColumnHelper.setModel(4);
        this.cleanTempColumns();
    }

    private void cleanTempColumns() throws DataException {
        this.populator.setResultSetMetadata(ResultSetProcessUtil.rebuildResultClass(this.populator.getResultSetMetadata()));
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, this.session);
        this.populator.getCache().reset();
        this.populator.getCache().next();
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setLeaveGroupIndex(0);
    }

    private static IResultClass rebuildResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        for (int i = 1; i <= meta.getFieldCount(); ++i) {
            if (PassUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))) continue;
            ResultFieldMetadata field = new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), meta.isCustomField(i));
            field.setAlias(meta.getFieldAlias(i));
            projectedColumns.add(field);
        }
        ResultClass result = new ResultClass(projectedColumns);
        return result;
    }
}

