/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.expression.ExpressionProcessor;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVSubQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDManager;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.SubQueryIndexUtil;
import org.eclipse.birt.data.engine.impl.document.viewing.CachedExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.JSIVRowObject;
import org.eclipse.birt.data.engine.impl.document.viewing.NewInstanceHelper;
import org.eclipse.birt.data.engine.impl.document.viewing.ViewingUtil;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class PreparedIVQuery
extends PreparedDataSourceQuery {
    private String rootQueryResultID;
    private String parentQueryResultID;
    private String selfQueryResultID;
    private DataEngineContext dataEngineContext;
    private DataEngineSession session;
    private SubQueryIndexUtil subQueryUtil;

    PreparedIVQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        super(dataEngine, queryDefn, null, null);
        this.dataEngineContext = dataEngine.getContext();
        this.session = dataEngine.getSession();
        String basedQueryResultID = queryDefn.getQueryResultsID();
        this.rootQueryResultID = QueryResultIDUtil.get1PartID(basedQueryResultID);
        if (this.rootQueryResultID == null) {
            this.rootQueryResultID = basedQueryResultID;
        } else {
            this.parentQueryResultID = QueryResultIDUtil.get2PartID(basedQueryResultID);
        }
        this.selfQueryResultID = QueryResultIDManager.getNextID(this.dataEngineContext, this.rootQueryResultID);
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable scope) throws DataException {
        QueryResults queryResults = (QueryResults)super.execute(outerResults, scope);
        queryResults.setID(this.rootQueryResultID, this.selfQueryResultID);
        return queryResults;
    }

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        this.prepareSubQueryUtil(iterator, subQueryName);
        PreparedIVSubQuery preparedSubIVQuery = new PreparedIVSubQuery(this.dataEngine, subScope, this.queryDefn, this.rootQueryResultID, this.preparedQuery.getSubQueryDefn(subQueryName), this.preparedQuery.getSubQueryLevel(subQueryName), iterator.getCurrentResultIndex(), this.subQueryUtil);
        return preparedSubIVQuery.execute(this.session.getSharedScope());
    }

    private void prepareSubQueryUtil(IResultIterator iterator, String subQueryName) throws DataException {
        if (this.subQueryUtil != null) {
            return;
        }
        int groupLevel = this.preparedQuery.getSubQueryLevel(subQueryName);
        int[] groupStartAndEndIndex = iterator.getGroupStartAndEndIndex(groupLevel);
        int[] validRowIndex = this.populateValidRowID(iterator);
        RDLoad rdLoad = RDUtil.newLoad(this.dataEngineContext, new QueryResultInfo(null, null, this.rootQueryResultID, null, -1));
        this.subQueryUtil = new SubQueryIndexUtil(rdLoad.loadRootGroupUtil().getGroupStartAndEndIndex(groupLevel), groupStartAndEndIndex, validRowIndex);
    }

    private int[] populateValidRowID(IResultIterator odiResult) throws DataException {
        int[] validRowIndex = new int[odiResult.getRowCount()];
        ResultSetCache rsCache = odiResult.getResultSetCache();
        int currIndex = rsCache.getCurrentIndex();
        rsCache.reset();
        for (int i = 0; i < validRowIndex.length; ++i) {
            rsCache.next();
            validRowIndex[i] = (Integer)rsCache.getCurrentResult().getFieldValue("_$$_dte_inner_row_id_$$_");
        }
        rsCache.moveTo(currIndex);
        return validRowIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryExecutor newExecutor() {
        Scriptable queryScope;
        Context cx = Context.enter();
        try {
            queryScope = cx.newObject(this.session.getSharedScope());
            queryScope.setParentScope(this.session.getSharedScope());
            queryScope.setPrototype(this.session.getSharedScope());
        }
        finally {
            Context.exit();
        }
        return new IVExecutor(queryScope);
    }

    private static class ResultObjectEvent
    implements IResultObjectEvent {
        private JSIVRowObject rowObject;

        private ResultObjectEvent(JSIVRowObject rowObject) {
            this.rowObject = rowObject;
        }

        public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
            this.rowObject.setResultObject(resultObject);
            return true;
        }
    }

    private class IVExecutor
    extends QueryExecutor {
        private Scriptable queryScope;
        private JSIVRowObject ivRowObject;

        public IVExecutor(Scriptable queryScope) {
            super(queryScope, PreparedIVQuery.this.queryDefn, new AggregateTable(), PreparedIVQuery.this.session);
            this.queryScope = queryScope;
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return NewInstanceHelper.newDataSource();
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            return NewInstanceHelper.newDataSourceRuntime(this.queryScope);
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            return new DataSetRuntime(this, NewInstanceHelper.newDataSetDesign(), this){
                private final /* synthetic */ IVExecutor this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1);
                }

                public Scriptable getScriptScope() {
                    return IVExecutor.access$100(this.this$1);
                }
            };
        }

        protected IQuery createOdiQuery() throws DataException {
            return NewInstanceHelper.newOdiQuery();
        }

        protected void populateOdiQuery() {
        }

        public Scriptable getQueryScope() {
            return this.queryScope;
        }

        public IResultMetaData getResultMetaData() throws DataException {
            RDLoad rdLoad = RDUtil.newLoad(PreparedIVQuery.this.dataEngineContext, new QueryResultInfo(PreparedIVQuery.this.rootQueryResultID, PreparedIVQuery.this.parentQueryResultID, PreparedIVQuery.this.selfQueryResultID, null, -1));
            return rdLoad.loadResultMetaData();
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            RDLoad rdLoad = null;
            List realList = null;
            if (PreparedIVQuery.this.parentQueryResultID != null && this.basedOnParentRS()) {
                rdLoad = RDUtil.newLoad(PreparedIVQuery.this.dataEngineContext, new QueryResultInfo(PreparedIVQuery.this.rootQueryResultID, PreparedIVQuery.this.parentQueryResultID, PreparedIVQuery.this.selfQueryResultID, null, -1));
                List parentList = rdLoad.loadFilterDefn(0, 1);
                realList = FilterDefnUtil.getRealFilterList(parentList, PreparedIVQuery.this.queryDefn.getFilters());
            }
            if (rdLoad == null) {
                PreparedIVQuery.this.parentQueryResultID = null;
                rdLoad = RDUtil.newLoad(PreparedIVQuery.this.dataEngineContext, new QueryResultInfo(PreparedIVQuery.this.rootQueryResultID, null, PreparedIVQuery.this.selfQueryResultID, null, -1));
                List rootList = rdLoad.loadFilterDefn(0, 0);
                realList = FilterDefnUtil.getRealFilterList(rootList, PreparedIVQuery.this.queryDefn.getFilters());
            }
            this.ivRowObject = new JSIVRowObject();
            this.queryScope.put("row", this.queryScope, (Object)this.ivRowObject);
            CachedExprResultSet resultIterator = new CachedExprResultSet(this.getBaseQuery(realList), rdLoad.loadExprDataResultSet(), rdLoad.loadRootGroupUtil(), PreparedIVQuery.this.session);
            resultIterator.setJSRowObject((Scriptable)this.ivRowObject);
            this.ivRowObject.setResultSetIterator(resultIterator);
            return resultIterator;
        }

        private boolean basedOnParentRS() throws DataException {
            List selfList;
            RDLoad rdLoad = RDUtil.newLoad(PreparedIVQuery.this.dataEngineContext, new QueryResultInfo(PreparedIVQuery.this.rootQueryResultID, PreparedIVQuery.this.parentQueryResultID, PreparedIVQuery.this.selfQueryResultID, null, -1));
            List parentList = rdLoad.loadFilterDefn(0, 1);
            return !FilterDefnUtil.isConflictFilter(parentList, selfList = PreparedIVQuery.this.queryDefn.getFilters());
        }

        private BaseQuery getBaseQuery(List filterList) throws DataException {
            BaseQuery baseQuery = new BaseQuery(this){
                private final /* synthetic */ IVExecutor this$1;
                {
                    this.this$1 = this$1;
                }

                public void close() {
                }
            };
            baseQuery.addOnFetchEvent(new ResultObjectEvent(this.ivRowObject));
            IQueryDefinition queryDefn = PreparedIVQuery.this.queryDefn;
            baseQuery.setOrdering(ViewingUtil.getSortList(queryDefn.getSorts()));
            if (filterList.size() > 0) {
                FilterByRow objectEvent = new FilterByRow(new ArrayList(), filterList, new ArrayList(), this.dataSet);
                baseQuery.addOnFetchEvent(objectEvent);
            }
            baseQuery.setExprProcessor(new ExpressionProcessor(this.dataSet));
            return baseQuery;
        }

        static /* synthetic */ Scriptable access$100(IVExecutor x0) {
            return x0.queryScope;
        }
    }
}

