/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.SubqueryDataSetRuntime;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

class PreparedSubquery
implements IPreparedQueryService {
    private int groupLevel;
    private PreparedQuery preparedQuery;
    private IPreparedQueryService queryService;
    private DataEngineSession session;
    private boolean subQueryOnGroup;
    private static Logger logger = Logger.getLogger(DataEngineImpl.class.getName());

    PreparedSubquery(DataEngineSession session, DataEngineContext context, ISubqueryDefinition subquery, IPreparedQueryService queryService, int groupLevel) throws DataException {
        this.groupLevel = groupLevel;
        this.queryService = queryService;
        this.subQueryOnGroup = subquery.applyOnGroup();
        logger.logp(Level.FINER, PreparedSubquery.class.getName(), "PreparedSubquery", "PreparedSubquery starts up.");
        this.session = session;
        this.preparedQuery = new PreparedQuery(session, context, subquery, this, null);
    }

    public PreparedDataSourceQuery getDataSourceQuery() {
        return this.queryService.getDataSourceQuery();
    }

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        return this.preparedQuery.execSubquery(iterator, subQueryName, subScope);
    }

    int getGroupLevel() {
        return this.groupLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryResults execute(IResultIterator parentIterator, Scriptable scope) throws DataException {
        QueryResults queryResults;
        logger.logp(Level.FINER, PreparedSubquery.class.getName(), "execute", "start to execute a PreparedSubquery.");
        try {
            queryResults = this.preparedQuery.doPrepare(null, scope, new SubQueryExecutor(parentIterator), this.getDataSourceQuery());
            Object var5_4 = null;
            logger.logp(Level.FINER, PreparedSubquery.class.getName(), "execute", "finish executing a PreparedSubquery.");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            logger.logp(Level.FINER, PreparedSubquery.class.getName(), "execute", "finish executing a PreparedSubquery.");
            throw throwable;
        }
        return queryResults;
    }

    private final class CustomDataSet
    implements ICustomDataSet {
        private IResultIterator resultIterator;
        private IResultClass resultClass;
        private boolean finished;

        CustomDataSet(IResultIterator resultIterator, IResultClass resultClass) {
            this.resultIterator = resultIterator;
            this.resultClass = resultClass;
        }

        public IResultClass getResultClass() {
            return this.resultClass;
        }

        public void open() throws DataException {
        }

        public IResultObject fetch() throws DataException {
            if (this.finished) {
                return null;
            }
            this.finished = true;
            return this.resultIterator.getCurrentResult();
        }

        public void close() throws DataException {
        }
    }

    private class SubQueryExecutor
    extends QueryExecutor {
        private IResultIterator parentIterator;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SubQueryExecutor(IResultIterator parentIterator) {
            super(PreparedSubquery.this.preparedQuery.getSharedScope(), PreparedSubquery.this.preparedQuery.getBaseQueryDefn(), PreparedSubquery.this.preparedQuery.getAggrTable(), PreparedSubquery.this.session);
            this.parentIterator = parentIterator;
            this.setParentExecutorHelper(parentIterator.getExecutorHelper());
        }

        protected IDataSource createOdiDataSource() {
            return null;
        }

        protected DataSourceRuntime findDataSource() {
            return null;
        }

        protected DataSetRuntime newDataSetRuntime() {
            return new SubqueryDataSetRuntime(this);
        }

        protected IQuery createOdiQuery() throws DataException {
            return DataSourceFactory.getFactory().getEmptyDataSource(PreparedSubquery.this.session).newCandidateQuery();
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            if (!$assertionsDisabled && this.parentIterator == null) {
                throw new AssertionError();
            }
            IResultIterator ret = null;
            ICandidateQuery cdQuery = (ICandidateQuery)this.odiQuery;
            if (PreparedSubquery.this.subQueryOnGroup) {
                cdQuery.setCandidates(this.parentIterator, PreparedSubquery.this.groupLevel);
            } else {
                cdQuery.setCandidates(new CustomDataSet(this.parentIterator, this.getMergedResultClass()));
            }
            ret = cdQuery.execute(eventHandler);
            this.parentIterator = null;
            return ret;
        }

        private IResultClass getMergedResultClass() throws DataException {
            IResultClass parentResultClass = this.parentIterator.getResultClass();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            if (!$assertionsDisabled && candidateQuery == null) {
                throw new AssertionError();
            }
            List computedColumns = this.dataSet.getComputedColumns();
            ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
            for (int i = 0; i < parentResultClass.getFieldCount(); ++i) {
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(i + 1, parentResultClass.getFieldName(i + 1), parentResultClass.getFieldName(i + 1), parentResultClass.getFieldValueClass(i + 1), parentResultClass.getFieldNativeTypeName(i + 1), parentResultClass.isCustomField(i + 1));
                columnsList.add(columnMetaData);
                columnMetaData.setAlias(parentResultClass.getFieldAlias(i + 1));
            }
            int count = columnsList.size();
            Iterator it = computedColumns.iterator();
            int j = columnsList.size();
            while (it.hasNext()) {
                IComputedColumn compColumn = (IComputedColumn)it.next();
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(++count, compColumn.getName(), compColumn.getName(), DataType.getClass((int)compColumn.getDataType()), null, true);
                columnsList.add(columnMetaData);
                ++j;
            }
            return new ResultClass(columnsList);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$PreparedSubquery == null ? (class$org$eclipse$birt$data$engine$impl$PreparedSubquery = PreparedSubquery.class$("org.eclipse.birt.data.engine.impl.PreparedSubquery")) : class$org$eclipse$birt$data$engine$impl$PreparedSubquery).desiredAssertionStatus();
        }
    }
}

