/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public final class AggregateTable {
    private List aggrExprInfoList = new ArrayList();
    private List groupDefns;
    private Scriptable scope;
    private BaseQuery baseQuery;
    private AggregateCalculator currentCalculator;

    public AggregateTable() {
    }

    public AggregateTable(Scriptable scope, List groupDefns) {
        this();
        this.groupDefns = groupDefns;
        this.scope = scope;
    }

    public AggregateTable(BaseQuery query) {
        this();
        this.baseQuery = query;
    }

    public AggregateRegistry getAggrRegistry(int groupLevel, int calculationLevel, boolean isDetailedRow, Context cx) throws DataException {
        AggrRegistry aggrRegistry = new AggrRegistry(groupLevel, calculationLevel, isDetailedRow, cx);
        aggrRegistry.prepare(this.groupDefns, this.scope, this.baseQuery, this.aggrExprInfoList);
        return aggrRegistry;
    }

    public void calculate(IResultIterator odiResult, Scriptable scope) throws DataException {
        this.currentCalculator = new AggregateCalculator(this.aggrExprInfoList, odiResult);
        this.currentCalculator.calculate(scope);
    }

    public void calculate(IResultIterator odiResult, Scriptable scope, JSAggrValueObject aggrValue) throws DataException {
        this.currentCalculator = new AggregateCalculator(this.aggrExprInfoList, odiResult);
        this.currentCalculator.calculate(scope);
    }

    public Scriptable getJSAggrValueObject() {
        if (this.currentCalculator == null) {
            return null;
        }
        return this.currentCalculator.getJSAggrValueObject();
    }
}

