/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;

public final class RDGroupUtil {
    private List[] groups;
    private int leafGroupIdx = 0;
    private CacheProvider cacheProvider;

    RDGroupUtil(InputStream inputStream, CacheProvider cacheProvider) throws DataException {
        try {
            int size = IOUtil.readInt((InputStream)inputStream);
            this.groups = new List[size];
            for (int i = 0; i < size; ++i) {
                CachedList list = new CachedList(GroupInfo.getCreator());
                int asize = IOUtil.readInt((InputStream)inputStream);
                for (int j = 0; j < asize; ++j) {
                    GroupInfo groupInfo = new GroupInfo();
                    groupInfo.parent = IOUtil.readInt((InputStream)inputStream);
                    groupInfo.firstChild = IOUtil.readInt((InputStream)inputStream);
                    list.add(groupInfo);
                }
                this.groups[i] = list;
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Group Info");
        }
        this.cacheProvider = cacheProvider;
    }

    public void saveGroupsToStream(OutputStream outputStream) throws IOException {
        int size = this.groups.length;
        IOUtil.writeInt((OutputStream)outputStream, (int)size);
        for (int i = 0; i < size; ++i) {
            List list = this.groups[i];
            int asize = list.size();
            IOUtil.writeInt((OutputStream)outputStream, (int)asize);
            for (int j = 0; j < asize; ++j) {
                GroupInfo groupInfo = (GroupInfo)list.get(j);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.parent);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.firstChild);
            }
        }
    }

    public RDGroupUtil(InputStream inputStream) throws DataException {
        this(inputStream, null);
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public List[] getGroups() {
        return this.groups;
    }

    public void setGroups(List[] groups) {
        this.groups = groups;
    }

    private GroupInfo findGroup(int groupLevel, int groupIndex) {
        if (groupIndex >= this.groups[groupLevel].size()) {
            return null;
        }
        return (GroupInfo)this.groups[groupLevel].get(groupIndex);
    }

    private void checkStarted() throws DataException {
        if (this.cacheProvider == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    private void checkHasCurrentRow() throws DataException {
        this.checkStarted();
        if (this.cacheProvider.getCurrentIndex() >= this.cacheProvider.getCount()) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    public int getEndingGroupLevel() throws DataException {
        GroupInfo nextGroup;
        int level;
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == this.cacheProvider.getCount() - 1) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        for (level = this.groups.length - 1; level >= 0 && (nextGroup = this.findGroup(level, currentGroupIdx + 1)) != null && childGroupIdx == nextGroup.firstChild - 1; --level) {
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = this.findGroup((int)level, (int)currentGroupIdx).parent;
        }
        return level + 2;
    }

    public int getStartingGroupLevel() throws DataException {
        int level;
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == 0) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        for (level = this.groups.length - 1; level >= 0; --level) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            if (childGroupIdx != currentGroup.firstChild) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = currentGroup.parent;
        }
        return level + 2;
    }

    private int findCurrentGroup(int groupLevel) {
        int currentGroupIdx = this.leafGroupIdx;
        for (int i = this.groups.length - 1; i > groupLevel; --i) {
            currentGroupIdx = this.findGroup((int)i, (int)currentGroupIdx).parent;
        }
        return currentGroupIdx;
    }

    public void last(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = -1;
        if (--groupLevel >= 0) {
            currentGroupIdx = this.findCurrentGroup(groupLevel);
        }
        if (groupLevel < 0 || currentGroupIdx >= this.groups[groupLevel].size() - 1) {
            int currentRowID = this.cacheProvider.getCount() - 1;
            this.cacheProvider.moveTo(currentRowID);
            if (this.groups.length > 0) {
                this.leafGroupIdx = this.groups[this.groups.length - 1].size() - 1;
            }
            return;
        }
        ++currentGroupIdx;
        for (int i = groupLevel + 1; i < this.groups.length; ++i) {
            currentGroupIdx = this.findGroup((int)(i - 1), (int)currentGroupIdx).firstChild;
        }
        int currentRowID = this.findGroup((int)(this.groups.length - 1), (int)currentGroupIdx).firstChild - 1;
        this.cacheProvider.moveTo(currentRowID);
        this.leafGroupIdx = currentGroupIdx - 1;
    }

    public void next(boolean hasNext) throws DataException {
        GroupInfo nextLeafGroup;
        if (hasNext && this.groups.length > 0 && (nextLeafGroup = this.findGroup(this.groups.length - 1, this.leafGroupIdx + 1)) != null && this.cacheProvider.getCurrentIndex() >= nextLeafGroup.firstChild) {
            ++this.leafGroupIdx;
        }
    }

    public int getGroupLevel() {
        return this.groups.length;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        this.checkHasCurrentRow();
        if (groupLevel == 0) {
            return 0;
        }
        if (groupLevel < 0 || groupLevel > this.groups.length) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = this.leafGroupIdx;
        for (int level = this.groups.length - 1; level > groupLevel - 1; --level) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            currentGroupIdx = currentGroup.parent;
        }
        return currentGroupIdx;
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) {
        int max = -1;
        if (this.cacheProvider != null) {
            max = this.cacheProvider.getCount();
        }
        if (groupLevel == 0) {
            return new int[]{0, max};
        }
        int unitCountInOneGroup = this.groups[groupLevel - 1].size();
        if (unitCountInOneGroup == 1) {
            return new int[]{0, max};
        }
        int[] unitInfo = new int[unitCountInOneGroup * 2];
        for (int i = 0; i < unitCountInOneGroup; ++i) {
            int startIndex = i;
            int endIndex = startIndex + 1;
            startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, max);
            endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, max);
            unitInfo[i * 2] = startIndex;
            unitInfo[i * 2 + 1] = endIndex;
        }
        return unitInfo;
    }
}

