/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamID;

public class DummyOutputStream
extends OutputStream {
    private static final int BUFF_SIZE = 4000;
    private List cachedByteArray = new ArrayList();
    private int currentListIndex;
    private int nextArrayIndex;
    private byte[] currentArray = new byte[4000];
    private DataEngineContext context;
    private StreamID id;
    private int type;
    private boolean isClosed;

    DummyOutputStream(DataEngineContext context, StreamID id, int type) {
        this.cachedByteArray.add(this.currentArray);
        this.nextArrayIndex = 0;
        this.currentListIndex = 0;
        this.context = context;
        this.id = id;
        this.type = type;
        this.isClosed = false;
    }

    public void write(int b) throws IOException {
        if (this.nextArrayIndex < 4000) {
            this.currentArray[this.nextArrayIndex] = (byte)b;
            ++this.nextArrayIndex;
        } else {
            this.currentArray = new byte[4000];
            this.cachedByteArray.add(this.currentArray);
            ++this.currentListIndex;
            this.nextArrayIndex = 0;
            this.write(b);
        }
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.currentListIndex * 4000 + this.nextArrayIndex];
        for (int i = 0; i < this.cachedByteArray.size(); ++i) {
            byte[] temp = (byte[])this.cachedByteArray.get(i);
            int count = 4000;
            if (i == this.cachedByteArray.size() - 1) {
                count = this.nextArrayIndex;
            }
            for (int j = 0; j < count; ++j) {
                result[i * 4000 + j] = temp[j];
            }
        }
        return result;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.type == 21 || this.type == 22) {
                this.saveToData();
            } else {
                this.saveToMeta();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private void saveToData() throws DataException, IOException {
        RAOutputStream data = this.context.getOutputStream(this.id.getStartStream(), this.id.getSubQueryStream(), 21);
        data.seek(data.length());
        DataOutputStream dos = new DataOutputStream((OutputStream)data);
        byte[] temp = this.toByteArray();
        dos.writeInt(this.type);
        dos.writeInt(temp.length);
        dos.write(temp);
        dos.close();
        data.close();
    }

    private void saveToMeta() throws DataException, IOException {
        RAOutputStream raMetaOs = this.context.getOutputStream(this.id.getStartStream(), this.id.getSubQueryStream(), 99);
        DataOutputStream metaOs = new DataOutputStream((OutputStream)raMetaOs);
        if (this.context.hasOutStream(this.id.getStartStream(), this.id.getSubQueryStream(), 99)) {
            raMetaOs.seek(raMetaOs.length());
        }
        RAOutputStream raMetaIndexOs = this.context.getOutputStream(this.id.getStartStream(), this.id.getSubQueryStream(), 100);
        DataOutputStream metaIndexOs = new DataOutputStream((OutputStream)raMetaIndexOs);
        if (this.context.hasOutStream(this.id.getStartStream(), this.id.getSubQueryStream(), 100)) {
            raMetaIndexOs.seek(raMetaIndexOs.length());
        }
        long offset = raMetaOs.length();
        Integer streamType = new Integer(this.type);
        byte[] temp = this.toByteArray();
        int size = temp.length;
        IOUtil.writeInt((OutputStream)metaIndexOs, (int)streamType);
        IOUtil.writeLong((DataOutputStream)metaIndexOs, (long)offset);
        IOUtil.writeInt((OutputStream)metaIndexOs, (int)size);
        offset += (long)size;
        metaOs.write(temp);
        metaOs.close();
        metaIndexOs.close();
    }
}

