/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;

class ExprDataReader1
implements IExprDataReader {
    private int currReadIndex;
    private int currRowIndex;
    private int INT_LENGTH = 4;
    private DataInputStream rowExprsDis;
    private RAInputStream rowExprsRAIs;
    private RAInputStream rowLenRAIs;
    private int rowCount;
    private int version;
    private Map exprValueMap;
    private List exprKeys;
    private int metaOffset;

    ExprDataReader1(RAInputStream rowExprsRAIs, RAInputStream rowLenRAIs, int version) throws DataException {
        try {
            this.rowCount = IOUtil.readInt((InputStream)rowExprsRAIs);
            int exprCount = IOUtil.readInt((InputStream)rowExprsRAIs);
            this.exprKeys = new ArrayList();
            this.rowExprsDis = new DataInputStream((InputStream)rowExprsRAIs);
            for (int i = 0; i < exprCount; ++i) {
                this.exprKeys.add(IOUtil.readString((DataInputStream)this.rowExprsDis));
            }
            this.metaOffset = this.INT_LENGTH + IOUtil.readInt((InputStream)this.rowExprsDis) + this.INT_LENGTH;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        this.rowExprsRAIs = rowExprsRAIs;
        this.rowLenRAIs = rowLenRAIs;
        this.version = version;
        this.currReadIndex = 0;
        this.currRowIndex = -1;
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getRowId() {
        return this.getRowIndex();
    }

    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    public boolean next() throws DataException {
        if (this.currRowIndex < this.rowCount - 1) {
            ++this.currRowIndex;
            return true;
        }
        return false;
    }

    public Map getRowValue() throws DataException {
        try {
            if (this.rowCount == 0) {
                if (this.exprValueMap == null) {
                    this.exprValueMap = this.getValueMap();
                }
            } else if (this.currReadIndex < this.currRowIndex + 1) {
                this.skipTo(this.currRowIndex);
                this.exprValueMap = this.getValueMap();
            }
            this.currReadIndex = this.currRowIndex + 1;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteRowIndex) throws IOException, DataException {
        if (this.currReadIndex == absoluteRowIndex) {
            return;
        }
        if (this.version == 0) {
            int gapRows = absoluteRowIndex - this.currReadIndex;
            for (int j = 0; j < gapRows; ++j) {
                int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
                for (int i = 0; i < exprCount; ++i) {
                    IOUtil.readObject((DataInputStream)this.rowExprsDis);
                }
            }
        } else {
            this.rowLenRAIs.seek((long)(absoluteRowIndex * this.INT_LENGTH));
            int rowOffsetAbsolute = IOUtil.readInt((InputStream)this.rowLenRAIs);
            this.rowExprsRAIs.seek((long)(rowOffsetAbsolute + this.metaOffset));
            this.rowExprsDis = new DataInputStream((InputStream)this.rowExprsRAIs);
        }
    }

    private Map getValueMap() throws IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
        for (int i = 0; i < exprCount; ++i) {
            String exprID = this.exprKeys.get(i).toString();
            Object exprValue = IOUtil.readObject((DataInputStream)this.rowExprsDis);
            if (RowSaveUtil.EXCEPTION_INDICATOR.equals(exprValue)) continue;
            valueMap.put(exprID, exprValue);
        }
        return valueMap;
    }

    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowExprsDis = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

