/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.DriverManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ConnectionManager {
    private static ConnectionManager sm_instance = null;
    private static final String sm_className = ConnectionManager.class.getName();
    static final String sm_packageName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = null;

    protected ConnectionManager() {
    }

    public static ConnectionManager getInstance() {
        String methodName = "getInstance";
        ConnectionManager.getLogger().entering(sm_className, "getInstance");
        if (sm_instance == null) {
            sm_instance = new ConnectionManager();
        }
        ConnectionManager.getLogger().exiting(sm_className, "getInstance", sm_instance);
        return sm_instance;
    }

    public static void releaseInstance() {
        DriverManager.releaseInstance();
        sm_instance = null;
        sm_logger = null;
    }

    private static LogHelper getLogger() {
        if (sm_logger == null) {
            sm_logger = LogHelper.getInstance(sm_packageName);
        }
        return sm_logger;
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties) throws DataException {
        return this.openConnection(dataSourceElementId, connectionProperties, null);
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties, Map appContext) throws DataException {
        String methodName = "openConnection";
        if (ConnectionManager.getLogger().isLoggingEnterExitLevel()) {
            ConnectionManager.getLogger().entering(sm_className, "openConnection", new Object[]{dataSourceElementId, connectionProperties});
        }
        try {
            DriverManager driverMgr = DriverManager.getInstance();
            driverMgr.setDriverLogConfiguration(dataSourceElementId);
            IDriver driverHelper = driverMgr.getDriverHelper(dataSourceElementId);
            String dataSourceId = driverMgr.getExtensionDataSourceId(dataSourceElementId);
            driverHelper.setAppContext((Object)appContext);
            IConnection connection = driverHelper.getConnection(dataSourceId);
            connection.open(connectionProperties);
            Connection ret = new Connection(connection, dataSourceElementId);
            ConnectionManager.getLogger().exiting(sm_className, "openConnection", ret);
            return ret;
        }
        catch (OdaException ex) {
            ConnectionManager.getLogger().logp(Level.SEVERE, sm_className, "openConnection", "Cannot open connection.", ex);
            throw new DataException("odaconsumer.CannotOpenConnection", (Throwable)ex, new Object[]{dataSourceElementId});
        }
        catch (UnsupportedOperationException ex) {
            ConnectionManager.getLogger().logp(Level.SEVERE, sm_className, "openConnection", "Cannot open connection.", ex);
            throw new DataException("odaconsumer.CannotOpenConnection", (Throwable)ex, new Object[]{dataSourceElementId});
        }
    }

    public int getMaxConnections(String driverName) throws DataException {
        String methodName = "getMaxConnections";
        ConnectionManager.getLogger().entering(sm_className, "getMaxConnections", driverName);
        int maxConnections = 0;
        try {
            IDriver driverHelper = DriverManager.getInstance().getDriverHelper(driverName);
            if (driverHelper != null) {
                maxConnections = driverHelper.getMaxConnections();
            }
        }
        catch (OdaException ex) {
            ConnectionManager.getLogger().logp(Level.WARNING, sm_className, "getMaxConnections", "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        catch (UnsupportedOperationException ex) {
            ConnectionManager.getLogger().logp(Level.INFO, sm_className, "getMaxConnections", "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        ConnectionManager.getLogger().exiting(sm_className, "getMaxConnections", maxConnections);
        return maxConnections;
    }
}

