/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;

class Driver {
    private String m_dataSourceDriverId;
    private ExtensionManifest m_driverConfig;
    private ExtensionManifest m_adapterConfig;
    private IDriver m_driverHelper;
    private static final String BIRT_DATASOURCE_EXTENSION_POINT = "org.eclipse.birt.data.oda.dataSource";
    private static final String ODA_ADAPTER_PLUGIN_ID = "org.eclipse.birt.data.oda.adapter.dtp";
    private static final String sm_className;
    private static final String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    Driver(String dataSourceElementId) {
        String methodName = "Driver";
        sm_logger.entering(sm_className, "Driver", dataSourceElementId);
        this.m_dataSourceDriverId = dataSourceElementId;
        sm_logger.exiting(sm_className, "Driver", this);
    }

    ExtensionManifest getExtensionConfig() throws DataException {
        if (this.m_adapterConfig != null) {
            return this.m_adapterConfig;
        }
        ExtensionManifest driverManifest = this.getDriverExtensionConfig();
        if (!$assertionsDisabled && driverManifest == null) {
            throw new AssertionError();
        }
        if (this.m_adapterConfig != null) {
            return this.m_adapterConfig;
        }
        return driverManifest;
    }

    ExtensionManifest getDriverExtensionConfig() throws DataException {
        if (this.m_driverConfig != null) {
            return this.m_driverConfig;
        }
        this.findDataSourceExtensionConfig();
        if (!$assertionsDisabled && this.m_driverConfig == null) {
            throw new AssertionError();
        }
        return this.m_driverConfig;
    }

    IDriver getDriverHelper() throws DataException {
        String methodName = "getDriverHelper";
        if (this.m_driverHelper != null) {
            return this.m_driverHelper;
        }
        try {
            this.m_driverHelper = new OdaDriver(this.getExtensionConfig());
            return this.m_driverHelper;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDriverHelper", "Cannot get ODA data source driver helper.", ex);
            throw new DataException("odaconsumer.OdaInitEntryNotFound", (Throwable)ex, new Object[]{this.m_dataSourceDriverId});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDriverHelper", "Cannot get ODA data source driver factory.", ex);
            throw new DataException("odaconsumer.OdaInitEntryNotFound", (Throwable)ex, new Object[]{this.m_dataSourceDriverId});
        }
    }

    void setLogConfiguration() {
        IDriver driverHelper;
        String methodName = "setLogConfiguration";
        LogConfiguration logConfigSpec = this.newLogSettings();
        if (logConfigSpec == null) {
            sm_logger.logp(Level.INFO, sm_className, "setLogConfiguration", "ODA driver does not have valid trace logging defined in the plug-in .options or plugin.xml file.");
            return;
        }
        try {
            driverHelper = this.getDriverHelper();
        }
        catch (DataException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "setLogConfiguration", "Cannot get ODA consumer manager's driver helper to set up logging.", (Throwable)((Object)ex));
            return;
        }
        try {
            driverHelper.setLogConfiguration(logConfigSpec);
        }
        catch (OdaException e1) {
            sm_logger.logp(Level.WARNING, sm_className, "setLogConfiguration", "Cannot set ODA data source log configuration.", e1);
        }
    }

    private void findDataSourceExtensionConfig() throws DataException {
        String methodName = "findDataSourceExtensionConfig";
        this.m_driverConfig = null;
        this.m_adapterConfig = null;
        this.m_driverConfig = this.doGetDriverManifest(this.m_dataSourceDriverId, true, false);
        if (this.m_driverConfig != null) {
            return;
        }
        this.m_driverConfig = this.doGetDriverManifest(this.m_dataSourceDriverId, false, true);
        if (!$assertionsDisabled && this.m_driverConfig == null) {
            throw new AssertionError();
        }
        try {
            this.m_adapterConfig = this.doGetDriverManifest(ODA_ADAPTER_PLUGIN_ID, true, true);
        }
        catch (Exception adapterEx) {
            this.m_driverConfig = null;
            this.throwAdapterException("findDataSourceExtensionConfig", adapterEx);
        }
    }

    private ExtensionManifest doGetDriverManifest(String dataSourceDriverId, boolean useDtpExtPoint, boolean throwsIfNotFound) throws DataException {
        String methodName = "doGetDriverManifest";
        ManifestExplorer explorer = ManifestExplorer.getInstance();
        try {
            if (useDtpExtPoint) {
                return explorer.getExtensionManifest(dataSourceDriverId);
            }
            ExtensionManifest birtManifest = explorer.getExtensionManifest(dataSourceDriverId, BIRT_DATASOURCE_EXTENSION_POINT);
            if (birtManifest == null && throwsIfNotFound) {
                throw new IllegalArgumentException(dataSourceDriverId);
            }
            return birtManifest;
        }
        catch (Exception ex) {
            if (useDtpExtPoint && ex instanceof IllegalArgumentException && !throwsIfNotFound) {
                return null;
            }
            return this.throwConfigException("doGetDriverManifest", dataSourceDriverId, ex);
        }
    }

    private void throwAdapterException(String methodName, Throwable cause) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot load DTP-to-BIRT ODA adapter.");
        throw new DataException("odaconsumer.CannotLoadOdaAdapter", cause, new Object[]{this.m_dataSourceDriverId, ODA_ADAPTER_PLUGIN_ID});
    }

    private ExtensionManifest throwConfigException(String methodName, String dataSourceDriverId, Throwable cause) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot process data source extension configuration.", cause);
        throw new DataException("odaconsumer.CannotProcessDriverConfig", cause, new Object[]{dataSourceDriverId});
    }

    private TraceLogging getLoggingElement() {
        ExtensionManifest config;
        String methodName = "getLoggingElement";
        try {
            config = this.getDriverExtensionConfig();
        }
        catch (DataException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "getLoggingElement", "Cannot get ODA driver plug-in manifest.", (Throwable)((Object)ex));
            return null;
        }
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        return config.getTraceLogging();
    }

    private LogConfiguration newLogSettings() {
        LogConfiguration logOptions = this.newTraceOptions();
        if (logOptions != null) {
            return logOptions;
        }
        TraceLogging logManifest = this.getLoggingElement();
        if (logManifest == null) {
            return null;
        }
        return this.newLogSettings(logManifest);
    }

    private LogConfiguration newTraceOptions() {
        String pluginId;
        try {
            pluginId = this.getDriverExtensionConfig().getNamespace();
        }
        catch (DataException e) {
            pluginId = this.m_dataSourceDriverId;
        }
        String debugOption = pluginId + "/debug";
        String debugOptionValue = Platform.getDebugOption((String)debugOption);
        Boolean isDebug = Boolean.valueOf(debugOptionValue);
        if (isDebug == Boolean.FALSE) {
            return null;
        }
        String logLevelOption = pluginId + "/traceLogging/logLevel";
        int logLevel = TraceLogging.toLogLevelNumber((String)Platform.getDebugOption((String)logLevelOption));
        String logFormatterOption = pluginId + "/traceLogging/logFormatterClass";
        String logFilePrefixOption = pluginId + "/traceLogging/logFileNamePrefix";
        String logDirOption = pluginId + "/traceLogging/logDirectory";
        String logFilenamePrefix = Platform.getDebugOption((String)logFilePrefixOption);
        String logDest = Platform.getDebugOption((String)logDirOption);
        if (this.isNotEmpty(logFilenamePrefix) || this.isNotEmpty(logDest)) {
            logFilenamePrefix = this.getDefaultLogFilenamePrefix(logFilenamePrefix);
            logDest = this.getDefaultLogDirectory(logDest);
        }
        return new LogConfiguration(this.m_dataSourceDriverId, logLevel, logDest, logFilenamePrefix, Platform.getDebugOption((String)logFormatterOption));
    }

    private LogConfiguration newLogSettings(TraceLogging logManifest) {
        if (!$assertionsDisabled && logManifest == null) {
            throw new AssertionError();
        }
        String logFilenamePrefix = logManifest.getLogFileNamePrefix();
        String logDest = logManifest.getLogDirectory();
        if (this.isNotEmpty(logFilenamePrefix) || this.isNotEmpty(logDest)) {
            logFilenamePrefix = this.getDefaultLogFilenamePrefix(logFilenamePrefix);
            logDest = this.getDefaultLogDirectory(logDest);
        }
        return new LogConfiguration(this.m_dataSourceDriverId, logManifest.getLogLevel(), logDest, logFilenamePrefix, logManifest.getLogFormatterClass());
    }

    private String getDefaultLogFilenamePrefix(String prefix) {
        if (this.isNotEmpty(prefix)) {
            return prefix;
        }
        return this.m_dataSourceDriverId;
    }

    private String getDefaultLogDirectory(String logDir) {
        if (this.isNotEmpty(logDir)) {
            return logDir;
        }
        return this.m_dataSourceDriverId;
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private boolean isNotEmpty(String value) {
        return !this.isNullOrEmpty(value);
    }

    static {
        $assertionsDisabled = !Driver.class.desiredAssertionStatus();
        sm_className = Driver.class.getName();
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

