/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JSMethodRunner {
    private Scriptable scope;
    private String scopeName;
    private static final String METHOD_NAME_PREFIX = "__bm_";

    public JSMethodRunner(Scriptable scope, String scopeName) {
        this.scope = scope;
        this.scopeName = scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runScript(String methodName, String script) throws BirtException {
        methodName = METHOD_NAME_PREFIX + methodName;
        String methodDesc = this.scopeName + "." + methodName;
        Context cx = Context.enter();
        try {
            Object result;
            if (!this.scope.has(methodName, this.scope)) {
                String scriptText = "function " + methodName + "() {\n" + script + "\n} ";
                ScriptEvalUtil.evaluateJSAsExpr(cx, this.scope, scriptText, methodDesc, 1);
            }
            String callScriptText = methodName + "()";
            Object object = result = ScriptEvalUtil.evaluateJSAsExpr(cx, this.scope, callScriptText, methodDesc, 1);
            return object;
        }
        finally {
            Context.exit();
        }
    }
}

