/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.dse.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.ConnectAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.DeleteAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.DisconnectAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.DuplicateProfileAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.PingAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.RefreshAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.RenameAction;
import org.eclipse.datatools.connectivity.ui.dse.actions.ViewPropertyAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class ConnectActionProvider
extends CommonActionProvider {
    private static final String NEW_SEPARATOR_NAME = "SEPARATOR.NEW";
    private static final String REFRESH_SEPARATOR_NAME = "SEPARATOR.REFRESH";
    private static final String CONNECT_SEPARATOR_NAME = "SEPARATOR.CONNECT";
    private static final String REFACTOR_SEPARATOR_NAME = "SEPARATOR.REFACTOR";
    private static final String PROPERTIES_SEPARATOR_NAME = "SEPARATOR.PROPERTIES";
    private static final String NEW_GROUP_NAME = "GROUP.NEW";
    private static final String REFRESH_GROUP_NAME = "GROUP.REFRESH";
    private static final String CONNECT_GROUP_NAME = "GROUP.CONNECT";
    private static final String REFACTOR_GROUP_NAME = "GROUP.REFACTOR";
    private static final String PROPERTIES_GROUP_NAME = "GROUP.PROPERTIES";
    private static final IContributionItem NEW_GROUP = new Separator("GROUP.NEW");
    private static final IContributionItem NEW_SEPARATOR = new Separator("SEPARATOR.NEW");
    private static final IContributionItem REFRESH_GROUP = new Separator("GROUP.REFRESH");
    private static final IContributionItem REFRESH_SEPARATOR = new Separator("SEPARATOR.REFRESH");
    private static final IContributionItem CONNECT_GROUP = new GroupMarker("GROUP.CONNECT");
    private static final IContributionItem CONNECT_SEPARATOR = new Separator("SEPARATOR.CONNECT");
    private static final IContributionItem REFACTOR_GROUP = new Separator("GROUP.REFACTOR");
    private static final IContributionItem REFACTOR_SEPARATOR = new Separator("SEPARATOR.REFACTOR");
    private static final IContributionItem PROPERTIES_GROUP = new GroupMarker("GROUP.PROPERTIES");
    private static final IContributionItem PROPERTIES_SEPARATOR = new Separator("SEPARATOR.PROPERTIES");
    private IViewPart aViewPart;
    private StructuredViewer aViewer;
    private IStructuredSelection selection;
    private ConnectAction connectAction = null;
    private DisconnectAction disconnectAction = null;
    private PingAction pingAction = null;
    private ViewPropertyAction propertyAction = null;
    private DeleteAction deleteAction = null;
    private DuplicateProfileAction duplicateAction = null;
    private RenameAction renameAction = null;
    private RefreshAction refreshAction = null;
    private AddProfileViewAction newProfileAction = null;

    public void dispose() {
        this.aViewPart.getViewSite().getActionBars().setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), null);
    }

    private void setSelection(IStructuredSelection selection) {
        this.selection = selection;
        this.connectAction.selectionChanged(null, (ISelection)this.selection);
        this.disconnectAction.selectionChanged(null, (ISelection)this.selection);
        this.pingAction.selectionChanged(null, (ISelection)this.selection);
        this.deleteAction.selectionChanged(null, (ISelection)this.selection);
        this.duplicateAction.selectionChanged(null, (ISelection)this.selection);
        this.renameAction.selectionChanged(null, (ISelection)this.selection);
    }

    public void setContext(ActionContext context) {
        if (context.getSelection() instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)context.getSelection());
        }
    }

    private ICategory getSelectedCategory() {
        Object obj;
        if (this.isSelectionValid(this.selection) && (obj = this.selection.getFirstElement()) instanceof ICategory) {
            return (ICategory)obj;
        }
        return null;
    }

    private IConnectionProfile getSelectedProfile() {
        Object obj;
        if (this.isSelectionValid(this.selection) && (obj = this.selection.getFirstElement()) instanceof IConnectionProfile) {
            return (IConnectionProfile)obj;
        }
        return null;
    }

    private void makeActions() {
        if (this.connectAction == null) {
            this.connectAction = new ConnectAction(this.aViewer.getControl().getShell());
        }
        if (this.disconnectAction == null) {
            this.disconnectAction = new DisconnectAction();
        }
        if (this.pingAction == null) {
            this.pingAction = new PingAction();
        }
        if (this.propertyAction == null) {
            this.propertyAction = new ViewPropertyAction((Viewer)this.aViewer);
        }
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        if (this.duplicateAction == null) {
            this.duplicateAction = new DuplicateProfileAction();
        }
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
        }
        if (this.refreshAction == null) {
            this.refreshAction = new RefreshAction((Viewer)this.aViewer);
        }
        if (this.newProfileAction == null) {
            this.newProfileAction = new AddProfileViewAction();
        }
    }

    public void fillContextMenu(IMenuManager arg0) {
    }

    public void fillActionBars(IActionBars bars) {
        if (this.isSelectionValid(this.selection)) {
            bars.updateActionBars();
            bars.getMenuManager().update();
            return;
        }
    }

    private boolean isSelectionValid(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object selected = iterator.next();
            if (!(selected instanceof IConnectionProfile) && !(selected instanceof ICategory)) continue;
            return true;
        }
        return false;
    }

    public void init(ICommonActionExtensionSite aConfig) {
        this.aViewer = aConfig.getStructuredViewer();
        this.makeActions();
    }
}

