/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class RefreshViewAction
extends Action
implements IObjectActionDelegate {
    protected Object m_selobj = null;
    protected IViewPart view = null;
    private StructuredViewer aViewer;

    public RefreshViewAction(StructuredViewer viewer) {
        this.setText(DSEPlugin.getDefault().getResourceString("DSE.Refresh.label"));
        this.setToolTipText(this.getText());
        this.aViewer = viewer;
    }

    public void run() {
        if (this.aViewer != null) {
            this.selectionChanged((IAction)this, this.aViewer.getSelection());
        }
        if (this.m_selobj != null) {
            if (this.view != null && this.view instanceof CommonNavigator) {
                CommonNavigator nav = (CommonNavigator)this.view;
                nav.getCommonViewer().refresh(this.m_selobj);
            } else if (this.aViewer != null) {
                this.aViewer.refresh(this.m_selobj);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.m_selobj = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            this.m_selobj = structuredSelection.getFirstElement();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof CommonNavigator) {
            this.view = (IViewPart)targetPart;
        }
    }

    public void run(IAction action) {
        this.run();
    }
}

