/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class RenameAction
implements IActionDelegate {
    private Shell mParentShell;
    private IConnectionProfile mProfile;

    public RenameAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run(IAction action) {
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return DSEPlugin.getDefault().getResourceString("rename.dialog.errmsg.invalid");
                }
                if (RenameAction.this.nameExisting(newText)) {
                    return DSEPlugin.getDefault().getResourceString("rename.dialog.errmsg.existing");
                }
                return null;
            }
        };
        InputDialog d = new InputDialog(this.mParentShell, DSEPlugin.getDefault().getResourceString("rename.dialog.title"), DSEPlugin.getDefault().getResourceString("rename.dialog.message"), this.mProfile.getName(), inputValidator);
        if (d.open() != 0) {
            return;
        }
        try {
            ProfileManager.getInstance().modifyProfile(this.mProfile, d.getValue(), null);
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException((Shell)this.mParentShell, (String)DSEPlugin.getDefault().getResourceString("dialog.title.error"), (String)e.getMessage(), (Throwable)e);
        }
    }

    private boolean nameExisting(String newName) {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            if (!profiles[i].getName().equals(newName)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mProfile = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(false);
            if (structuredSelection.size() == 1) {
                Object selectedResource = structuredSelection.getFirstElement();
                action.setEnabled(selectedResource instanceof IConnectionProfile);
                if (selectedResource instanceof IConnectionProfile) {
                    this.mProfile = (IConnectionProfile)selectedResource;
                }
            }
        }
    }
}

