/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer;

import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ViewerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.viewer";
    public static final int DEFAULT_MAX_ROWS = 500;
    private static ViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private BundleContext bundleContext;

    public ViewerPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(ViewerPlugin.class.getName());
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.bundleContext = bundleContext;
        plugin.getPluginPreferences().setDefault("master_page_content", true);
        plugin.getPluginPreferences().setDefault("preview_maxrow", 500);
        plugin.getPluginPreferences().setDefault("user_locale", ULocale.getDefault().getDisplayName());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        WebappAccessor.stop("viewer");
        super.stop(bundleContext);
    }

    public static ViewerPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = ViewerPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getFormattedResourceString(String string, Object[] objectArray) {
        return MessageFormat.format(ViewerPlugin.getResourceString(string), objectArray);
    }

    public static synchronized void logError(String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        Status status = new Status(4, PLUGIN_ID, 0, string, throwable);
        ViewerPlugin.getDefault().getLog().log((IStatus)status);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }
}

