/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers.custom;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.birt.report.viewer.ViewerPlugin;

public class BrowserLog {
    private static BrowserLog instance;
    private String logFileName;
    private boolean newSession;
    DateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
    String LN = System.getProperty("line.separator");

    private BrowserLog() {
        try {
            this.newSession = true;
            this.logFileName = ViewerPlugin.getDefault().getStateLocation().append("browser.log").toOSString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BrowserLog getInstance() {
        if (instance == null) {
            instance = new BrowserLog();
        }
        return instance;
    }

    public static synchronized void log(String string) {
        BrowserLog.getInstance().append(string);
    }

    private void append(String string) {
        block6: {
            if (this.logFileName == null) {
                return;
            }
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, true), "UTF-8"));
                if (this.newSession) {
                    this.newSession = false;
                    writer.write(this.LN + this.formatter.format(new Date()) + " NEW SESSION" + this.LN);
                }
                writer.write(this.formatter.format(new Date()) + " " + string + this.LN);
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                if (writer == null) break block6;
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

