/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers.embedded;

import org.eclipse.birt.report.viewer.browsers.embedded.EmbeddedBrowser;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.swt.widgets.Display;

public class EmbeddedBrowserAdapter
implements IBrowser {
    private EmbeddedBrowser browser;

    public synchronized void displayURL(final String string) {
        Display display = Display.getDefault();
        if (display == Display.getCurrent()) {
            this.uiDisplayURL(string);
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiDisplayURL(string);
                }
            });
        }
    }

    private void uiDisplayURL(String string) {
        this.uiClose();
        this.getBrowser().displayUrl(string);
    }

    public void close() {
        Display display = Display.getDefault();
        if (display == Display.getCurrent()) {
            this.uiClose();
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiClose();
                }
            });
        }
    }

    private void uiClose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.close();
        }
    }

    private EmbeddedBrowser getBrowser() {
        if (this.browser == null || this.browser.isDisposed()) {
            this.browser = new EmbeddedBrowser();
        }
        return this.browser;
    }

    public boolean isCloseSupported() {
        return true;
    }

    public boolean isSetLocationSupported() {
        return true;
    }

    public boolean isSetSizeSupported() {
        return true;
    }

    public void setLocation(final int n, final int n2) {
        Display display = Display.getDefault();
        if (display == Display.getCurrent()) {
            this.uiSetLocation(n, n2);
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetLocation(n, n2);
                }
            });
        }
    }

    private void uiSetLocation(int n, int n2) {
        this.getBrowser().setLocation(n, n2);
    }

    public void setSize(final int n, final int n2) {
        Display display = Display.getDefault();
        if (display == Display.getCurrent()) {
            this.uiSetSize(n, n2);
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetSize(n, n2);
                }
            });
        }
    }

    private void uiSetSize(int n, int n2) {
        this.getBrowser().setSize(n, n2);
    }
}

