/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.IWebappServer;

public class AppServerWrapper {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    private static final String APP_SERVER_EXTENSION_ID = "org.eclipse.help.appserver.server";
    private static final String APP_SERVER_CLASS_ATTRIBUTE = "class";
    private static final String APP_SERVER_DEFAULT_ATTRIBUTE = "default";
    private static AppServerWrapper wrapper = null;
    private IWebappServer appServer;
    private String hostAddress;
    private int port;

    public static synchronized AppServerWrapper getInstance() {
        if (wrapper == null) {
            wrapper = new AppServerWrapper();
        }
        return wrapper;
    }

    public synchronized IWebappServer getAppServer() throws CoreException {
        if (this.appServer == null) {
            this.createWebappServer();
            this.startWebappServer();
        }
        return this.appServer;
    }

    private void createWebappServer() throws CoreException {
        IExtension[] iExtensionArray;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(APP_SERVER_EXTENSION_ID);
        if (iExtensionPoint != null && (iExtensionArray = iExtensionPoint.getExtensions()).length != 0) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[0].getConfigurationElements();
            if (iConfigurationElementArray.length == 0) {
                return;
            }
            IConfigurationElement iConfigurationElement = null;
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                String string = iConfigurationElementArray[i].getAttribute(APP_SERVER_DEFAULT_ATTRIBUTE);
                if (string != null && !string.equals("false")) continue;
                iConfigurationElement = iConfigurationElementArray[i];
                break;
            }
            if (iConfigurationElement == null) {
                iConfigurationElement = iConfigurationElementArray[0];
            }
            try {
                this.appServer = (IWebappServer)iConfigurationElement.createExecutableExtension(APP_SERVER_CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                ViewerPlugin.getDefault().getLog().log(coreException.getStatus());
                throw coreException;
            }
        }
    }

    private void startWebappServer() throws CoreException {
        String string;
        this.hostAddress = ViewerPlugin.getDefault().getPluginPreferences().getString(HOST_KEY);
        if ("".equals(this.hostAddress)) {
            this.hostAddress = null;
        }
        this.port = ViewerPlugin.getDefault().getPluginPreferences().getInt(PORT_KEY);
        try {
            string = System.getProperty("server_host");
            if (string != null && string.trim().length() > 0) {
                this.hostAddress = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = System.getProperty("server_port");
            if (string != null && string.trim().length() > 0) {
                this.port = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.appServer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.appserver", 0, ViewerPlugin.getResourceString("viewer.appserver.errorstart"), null));
        }
        this.appServer.start(this.port, this.hostAddress);
    }
}

