/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserAccessor;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.browser.Browser;

public class WebViewer {
    public static final String HTML = "html";
    public static final String PDF = "pdf";
    public static final String WebAppPlugin = "org.eclipse.birt.report.viewer";
    public static final String USER_LOCALE = "user_locale";
    public static final String SVG_FLAG = "svg_flag";
    public static final String MASTER_PAGE_CONTENT = "master_page_content";
    public static final String PREVIEW_MAXROW = "preview_maxrow";
    public static final String FORMAT_KEY = "FORMAT_KEY";
    public static final String ALLOW_PAGE_KEY = "ALLOW_PAGE_KEY";
    public static final String SERVLET_NAME_KEY = "SERVLET_NAME_KEY";
    public static final String RESOURCE_FOLDER_KEY = "RESOURCE_FOLDER_KEY";
    public static TreeMap LocaleTable = null;

    private static String getBaseURL() {
        return "http://" + WebappAccessor.getHost() + ":" + WebappAccessor.getPort() + "/viewer/";
    }

    private static String createURL(String string, Map map) {
        if (map == null || map.isEmpty()) {
            return WebViewer.createURL(null, string, null, true, null);
        }
        String string2 = (String)map.get(SERVLET_NAME_KEY);
        String string3 = (String)map.get(FORMAT_KEY);
        String string4 = (String)map.get(RESOURCE_FOLDER_KEY);
        Boolean bl = (Boolean)map.get(ALLOW_PAGE_KEY);
        if (PDF.equalsIgnoreCase(string3)) {
            return WebViewer.createURL("run", string, string3, true, string4);
        }
        if (string2 == null || string2.trim().length() <= 0) {
            string2 = bl == null ? "frameset" : (bl != false ? "frameset" : "run");
        }
        return WebViewer.createURL(string2, string, string3, true, string4);
    }

    private static String createURL(String string, String string2, String string3, boolean bl, String string4) {
        Object object;
        Object object2;
        String string5 = null;
        try {
            string5 = URLEncoder.encode(string2, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string6 = ViewerPlugin.getDefault().getPluginPreferences().getString(USER_LOCALE);
        String string7 = ViewerPlugin.getDefault().getPluginPreferences().getString(SVG_FLAG);
        boolean bl2 = false;
        String string8 = ViewerPlugin.getDefault().getPluginPreferences().getString(PREVIEW_MAXROW);
        if (string8 == null) {
            string8 = "";
        }
        boolean bl3 = false;
        String string9 = System.getProperty("eclipse.commands");
        if (string9 != null) {
            object2 = string9.split("-");
            String string10 = "[\\s]*[dD][iI][rR][\\s]*[rR][tT][lL][\\s]*";
            object = Pattern.compile(string10);
            for (int i = 0; i < ((String[])object2).length; ++i) {
                String string11 = object2[i];
                if (!((Pattern)object).matcher(string11).matches()) continue;
                bl3 = true;
                break;
            }
        }
        if ("true".equalsIgnoreCase(string7)) {
            bl2 = true;
        }
        object2 = ViewerPlugin.getDefault().getPluginPreferences().getString(MASTER_PAGE_CONTENT);
        boolean bl4 = true;
        if ("false".equalsIgnoreCase((String)object2)) {
            bl4 = false;
        }
        object = null;
        try {
            if (string4 != null) {
                object = URLEncoder.encode(string4, "utf-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (object == null) {
            object = "";
        }
        return WebViewer.getBaseURL() + string + "?" + "__report=" + string5 + "&__format=" + string3 + "&__svg=" + String.valueOf(bl2) + (LocaleTable.containsKey(string6) ? "&__locale=" + LocaleTable.get(string6) : "") + "&__designer=" + String.valueOf(bl) + "&__masterpage=" + String.valueOf(bl4) + "&__rtl=" + String.valueOf(bl3) + "&__maxrows=" + string8 + "&__resourceFolder=" + (String)object;
    }

    private static void startWebApp() {
        try {
            WebappAccessor.start("viewer", WebAppPlugin, (IPath)Path.EMPTY);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void startup(Browser browser) {
        WebViewer.startWebApp();
    }

    public static void display(String string, String string2) {
        WebViewer.display(string, string2, true);
    }

    public static void display(String string, String string2, boolean bl) {
        String string3 = null;
        string3 = PDF.equalsIgnoreCase(string2) ? WebViewer.createURL("run", string, string2, true, null) : WebViewer.createURL(bl ? "frameset" : "run", string, string2, true, null) + "&" + new Random().nextInt();
        try {
            BrowserAccessor.getPreviewBrowser(false).displayURL(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void display(String string, String string2, Browser browser) {
        browser.setUrl(WebViewer.createURL("run", string, string2, true, null) + "&" + new Random().nextInt());
    }

    public static void display(String string, String string2, Browser browser, String string3) {
        browser.setUrl(WebViewer.createURL(string3, string, string2, true, null) + "&" + new Random().nextInt());
    }

    public static void display(String string, Browser browser, Map map) {
        browser.setUrl(WebViewer.createURL(string, map) + "&" + new Random().nextInt());
    }

    public static void display(String string, Map map) {
        try {
            BrowserAccessor.getPreviewBrowser(false).displayURL(WebViewer.createURL(string, map) + "&" + new Random().nextInt());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        LocaleTable = new TreeMap();
        Locale[] localeArray = Locale.getAvailableLocales();
        if (localeArray != null) {
            for (int i = 0; i < localeArray.length; ++i) {
                Locale locale = localeArray[i];
                if (locale == null) continue;
                LocaleTable.put(locale.getDisplayName(), locale.getLanguage() + "_" + locale.getCountry());
            }
        }
    }
}

