/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.layout.LabelBlock;

public class TextRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 1683131722588162319L;
    public static final int UNDEFINED = 0;
    public static final int RENDER_SHADOW_AT_LOCATION = 1;
    public static final int RENDER_TEXT_AT_LOCATION = 2;
    public static final int RENDER_TEXT_IN_BLOCK = 3;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int ABOVE = 3;
    public static final int BELOW = 4;
    protected Bounds _boBlock;
    protected Label _la;
    protected TextAlignment _taBlock;
    protected int _iAction = 0;
    protected Location _lo;
    protected int _iTextPosition;

    public TextRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void setBlockBounds(Bounds boBlock) {
        this._boBlock = boBlock;
    }

    public final Bounds getBlockBounds() {
        return this._boBlock;
    }

    public final void setLabel(Label la) {
        this._la = la;
    }

    public final Label getLabel() {
        return this._la;
    }

    public final void setBlockAlignment(TextAlignment taBlock) {
        this._taBlock = taBlock;
    }

    public final TextAlignment getBlockAlignment() {
        return this._taBlock;
    }

    public final void setAction(int iAction) {
        this._iAction = iAction;
    }

    public final int getAction() {
        return this._iAction;
    }

    public final void setLocation(Location lo) {
        this._lo = lo;
    }

    public final Location getLocation() {
        return this._lo;
    }

    public final void setTextPosition(int iTextPosition) {
        this._iTextPosition = iTextPosition;
    }

    public final int getTextPosition() {
        return this._iTextPosition;
    }

    public final String updateFrom(LabelBlock lb, double dScale, RunTimeContext rtc) {
        String sPreviousValue = lb.getLabel().getCaption().getValue();
        lb.getLabel().getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        this.setLabel(lb.getLabel());
        Bounds bo = lb.getBounds().scaledInstance(dScale);
        bo = bo.adjustedInstance(lb.getInsets().scaledInstance(dScale));
        this.setBlockBounds(bo);
        this.setBlockAlignment(lb.getLabel().getCaption().getFont().getAlignment());
        this.setAction(3);
        return sPreviousValue;
    }

    public PrimitiveRenderEvent copy() {
        TextRenderEvent tre = new TextRenderEvent(this.source);
        if (this._boBlock != null) {
            tre.setBlockBounds(BoundsImpl.copyInstance(this._boBlock));
        }
        tre.setAction(this._iAction);
        tre.setTextPosition(this._iTextPosition);
        if (this._la != null) {
            tre.setLabel(LabelImpl.copyCompactInstance(this._la));
        }
        if (this._lo != null) {
            tre.setLocation(LocationImpl.copyInstance(this._lo));
        }
        if (this._taBlock != null) {
            tre.setBlockAlignment(TextAlignmentImpl.copyInstance(this._taBlock));
        }
        return tre;
    }

    public void fill(IDeviceRenderer idr) throws ChartException {
        this.draw(idr);
    }

    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawText(this);
    }

    public void reset() {
        this._boBlock = null;
        this._la = null;
        this._lo = null;
        this._taBlock = null;
    }
}

