/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import org.eclipse.birt.chart.internal.computations.MatrixDecomposition;

public class Matrix
implements Cloneable {
    private double[][] data;
    private int m;
    private int n;

    public Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.data = new double[m][n];
    }

    public Matrix(double[][] data, int m, int n) {
        this.data = data;
        this.m = m;
        this.n = n;
    }

    public Matrix(double[] A, int m) {
        this.m = m;
        int n = this.n = m != 0 ? A.length / m : 0;
        if (m * this.n != A.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.data = new double[m][this.n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.data[i][j] = A[i + j * m];
            }
        }
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] A = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                A[i][j] = this.data[i][j];
            }
        }
        return matrix;
    }

    public double[][] getArray() {
        return this.data;
    }

    public double[][] getArrayCopy() {
        double[][] A = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                A[i][j] = this.data[i][j];
            }
        }
        return A;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.data[i][j];
    }

    public void set(int i, int j, double s) {
        this.data[i][j] = s;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] C = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[j][i] = this.data[i][j];
            }
        }
        return matrix;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix mResult = new Matrix(this.m, matrix.n);
        double[][] A = mResult.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < matrix.n; ++j) {
                double s = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    s += this.data[i][k] * matrix.data[k][j];
                }
                A[i][j] = s;
            }
        }
        return mResult;
    }

    public static Matrix identity(int m, int n) {
        Matrix matrix = new Matrix(m, n);
        double[][] A = matrix.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public Matrix inverse() {
        return new MatrixDecomposition(this).decomposition();
    }
}

