/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.ui.swt.composites.ICustomChoice;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class CustomChooserComposite
extends Composite {
    private transient Composite cmpDropDown = null;
    private transient ICustomChoice cnvSelection = null;
    private transient Button btnDown = null;
    private transient Object iCurrentValue = null;
    private transient Vector vListeners = new Vector();
    public static final int STYLE_CHANGED_EVENT = 1;
    private transient boolean bEnabled = true;
    private boolean bJustFocusLost = false;
    private transient ICustomChoice popupSelection;
    private transient ICustomChoice[] popupCanvases;
    private Object[] items;
    Listener canvasListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == CustomChooserComposite.this.cnvSelection) {
                CustomChooserComposite.this.handleEventCanvasSelection(event);
            } else {
                CustomChooserComposite.this.handleEventCanvasPopup(event);
            }
        }
    };

    public CustomChooserComposite(Composite parent, int style, Object choiceValue) {
        super(parent, style);
        this.iCurrentValue = choiceValue;
    }

    public CustomChooserComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setItems(Object[] items) {
        this.items = items;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    public Object[] getItems() {
        return this.items;
    }

    public void select(int index) {
        this.setChoiceValue(this.items[index]);
    }

    protected abstract ICustomChoice createChoice(Composite var1, Object var2);

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.popupCanvases = new ICustomChoice[this.items.length];
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        this.setLayout((Layout)flMain);
        Composite cmpContent = new Composite((Composite)this, 2048);
        GridLayout glContentInner = new GridLayout();
        glContentInner.verticalSpacing = 0;
        glContentInner.horizontalSpacing = 0;
        glContentInner.marginHeight = 0;
        glContentInner.marginWidth = 0;
        glContentInner.numColumns = 2;
        cmpContent.setLayout((Layout)glContentInner);
        int iSize = 18;
        this.cnvSelection = this.createChoice(cmpContent, null);
        GridData gdCNVSelection = new GridData(1808);
        gdCNVSelection.heightHint = 18;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.cnvSelection.setValue(this.iCurrentValue);
        this.cnvSelection.addListener(1, this.canvasListener);
        this.cnvSelection.addListener(31, this.canvasListener);
        this.cnvSelection.addListener(15, this.canvasListener);
        this.cnvSelection.addListener(16, this.canvasListener);
        this.cnvSelection.addListener(3, this.canvasListener);
        this.btnDown = new Button(cmpContent, 1028);
        GridData gdBDown = new GridData(4);
        gdBDown.verticalAlignment = 1;
        gdBDown.widthHint = 16;
        gdBDown.heightHint = 18;
        this.btnDown.setLayoutData((Object)gdBDown);
        this.btnDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CustomChooserComposite.this.toggleDropDown();
            }
        });
    }

    public void setEnabled(boolean bState) {
        this.btnDown.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void createDropDownComponent(int iXLoc, int iYLoc) {
        if (!this.bEnabled) {
            return;
        }
        int shellWidth = this.getSize().x;
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= shellWidth;
        }
        shell.setLocation(iXLoc, iYLoc);
        this.cmpDropDown = new Composite((Composite)shell, 0);
        FillLayout fillDropDown = new FillLayout();
        fillDropDown.type = 512;
        this.cmpDropDown.setLayout((Layout)fillDropDown);
        Listener listenerCmpDropDown = new Listener(){

            public void handleEvent(Event event) {
                CustomChooserComposite.this.handleEventCmpDropDown(event);
            }
        };
        this.cmpDropDown.addListener(1, listenerCmpDropDown);
        this.cmpDropDown.addListener(16, listenerCmpDropDown);
        int choiceHigh = 18;
        for (int iC = 0; iC < this.items.length; ++iC) {
            ICustomChoice cnv = this.createChoice(this.cmpDropDown, this.items[iC]);
            GridData gd = new GridData();
            gd.heightHint = 18;
            cnv.setLayoutData(gd);
            cnv.addListener(3, this.canvasListener);
            cnv.addListener(6, this.canvasListener);
            cnv.addListener(1, this.canvasListener);
            this.popupCanvases[iC] = cnv;
            if (!this.cnvSelection.getValue().equals(cnv.getValue())) continue;
            cnv.notifyListeners(15, new Event());
            this.popupSelection = cnv;
        }
        shell.setSize(shellWidth, 18 * this.items.length);
        shell.layout();
        shell.open();
    }

    void handleEventCmpDropDown(Event event) {
        switch (event.type) {
            case 1: {
                this.keyPressed(new KeyEvent(event));
                break;
            }
            case 16: {
                Control cTmp = Display.getCurrent().getCursorControl();
                if (cTmp != null && (cTmp.equals(this.cnvSelection) || cTmp.equals(this.btnDown))) {
                    this.bJustFocusLost = true;
                }
                if (this.isPopupControl(cTmp)) break;
                this.cmpDropDown.getShell().close();
                break;
            }
        }
    }

    public Object getChoiceValue() {
        return this.iCurrentValue;
    }

    public void setChoiceValue(Object iValue) {
        this.iCurrentValue = iValue;
        this.cnvSelection.setValue(this.iCurrentValue);
        this.cnvSelection.redraw();
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void toggleDropDown() {
        if (this.bJustFocusLost) {
            this.bJustFocusLost = false;
            return;
        }
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed() || !this.cmpDropDown.isVisible()) {
            Point pLoc = UIHelper.getScreenLocation((Composite)this);
            this.createDropDownComponent(pLoc.x, pLoc.y + this.getSize().y);
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    private void fireEvent() {
        Event e = new Event();
        e.widget = this;
        e.data = this.iCurrentValue;
        e.type = 1;
        for (int i = 0; i < this.vListeners.size(); ++i) {
            ((Listener)this.vListeners.get(i)).handleEvent(e);
        }
    }

    void keyPressed(KeyEvent event) {
        if (this.cmpDropDown != null && !this.cmpDropDown.getShell().isDisposed()) {
            ICustomChoice currentControl;
            int styleIndex;
            if (event.keyCode == 27) {
                this.cmpDropDown.getShell().close();
            } else if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                ICustomChoice currentControl2 = this.popupSelection == null ? this.popupCanvases[this.findChoiceIndex(this.cnvSelection.getValue())] : this.popupSelection;
                this.setChoiceValue(currentControl2.getValue());
                this.fireEvent();
                this.cmpDropDown.getShell().close();
            } else if ((event.keyCode == 0x1000001 || event.keyCode == 0x1000002) && (styleIndex = this.findChoiceIndex((currentControl = this.popupSelection == null ? this.popupCanvases[this.findChoiceIndex(this.cnvSelection.getValue())] : this.popupSelection).getValue())) >= 0) {
                currentControl.notifyListeners(16, new Event());
                currentControl.redraw();
                if (event.keyCode == 0x1000001) {
                    if (styleIndex > 0) {
                        this.setChoiceValue(this.items[--styleIndex]);
                        this.fireEvent();
                    }
                } else if (event.keyCode == 0x1000002 && styleIndex < this.items.length - 1) {
                    this.setChoiceValue(this.items[++styleIndex]);
                    this.fireEvent();
                }
                this.popupSelection = this.popupCanvases[styleIndex];
                this.popupSelection.notifyListeners(15, new Event());
                this.popupSelection.redraw();
            }
        }
    }

    private boolean isPopupControl(Object control) {
        return control != null && control instanceof Control && ((Control)control).getShell() == this.cmpDropDown.getShell();
    }

    void handleEventCanvasSelection(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvSelection.redraw();
                break;
            }
            case 16: {
                this.cnvSelection.redraw();
                break;
            }
            case 1: {
                int styleIndex;
                if (this.isDisposed() || event.keyCode != 0x1000001 && event.keyCode != 0x1000002 || (styleIndex = this.findChoiceIndex(this.cnvSelection.getValue())) < 0) break;
                if (event.keyCode == 0x1000001) {
                    if (styleIndex <= 0) break;
                    this.setChoiceValue(this.items[--styleIndex]);
                    this.fireEvent();
                    break;
                }
                if (event.keyCode != 0x1000002 || styleIndex >= this.items.length - 1) break;
                this.setChoiceValue(this.items[++styleIndex]);
                this.fireEvent();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: {
                        this.getShell().close();
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvSelection.redraw();
                    }
                }
                break;
            }
            case 3: {
                this.toggleDropDown();
            }
        }
    }

    void handleEventCanvasPopup(Event event) {
        switch (event.type) {
            case 3: {
                this.setChoiceValue(((ICustomChoice)event.widget).getValue());
                this.cmpDropDown.getShell().close();
                this.fireEvent();
                break;
            }
            case 6: {
                if (this.popupSelection != null) {
                    this.popupSelection.notifyListeners(16, new Event());
                    this.popupSelection.redraw();
                }
                this.popupSelection = (ICustomChoice)event.widget;
                this.popupSelection.notifyListeners(15, event);
                this.popupSelection.redraw();
            }
        }
    }

    private int findChoiceIndex(Object value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = CustomChooserComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CustomChooserComposite.this.toControl(new Point(e.x, e.y));
                if (CustomChooserComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = CustomChooserComposite.this.getBounds();
                Point pt = CustomChooserComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

