/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorDialog;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ExternalizedTextEditorComposite
extends Canvas
implements SelectionListener,
Listener {
    private transient TextEditorComposite txtSelection = null;
    private transient Button btnDown = null;
    private transient int iSize = 20;
    private transient int iStyle = 4;
    private transient int iHeightHint = -1;
    private transient int iWidthHint = -1;
    private transient Vector vListeners = null;
    public static final int TEXT_CHANGED_EVENT = 1;
    public static final String SEPARATOR = "=";
    private transient String sKey = null;
    private transient String sCurrent = "";
    private transient List keys = null;
    private transient IUIServiceProvider serviceprovider = null;
    private transient boolean bEnabled = true;

    public ExternalizedTextEditorComposite(Composite parent, int style, int iHeightHint, int iWidthHint, List keys, IUIServiceProvider serviceprovider, String sText) {
        super(parent, 0);
        this.iStyle = style;
        this.iHeightHint = iHeightHint;
        this.iWidthHint = iWidthHint;
        this.keys = keys;
        this.serviceprovider = serviceprovider;
        this.init();
        this.placeComponents();
        this.setText(sText);
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 1;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        this.setLayout((Layout)glContent);
        this.txtSelection = new TextEditorComposite((Composite)this, this.iStyle);
        GridData gdTXTSelection = new GridData(768);
        if (this.iHeightHint > 0) {
            gdTXTSelection.heightHint = this.iHeightHint - 10;
        }
        if (this.iWidthHint > 0) {
            gdTXTSelection.widthHint = this.iWidthHint;
        }
        this.txtSelection.setLayoutData(gdTXTSelection);
        this.txtSelection.addListener(this);
        this.btnDown = new Button((Composite)this, 8);
        GridData gdBTNDown = new GridData(8);
        gdBTNDown.heightHint = this.iSize;
        gdBTNDown.widthHint = this.iSize;
        this.btnDown.setText(" ... ");
        this.btnDown.setToolTipText(Messages.getString("ExternalizedTextEditorComposite.Lbl.EditText"));
        this.btnDown.setLayoutData((Object)gdBTNDown);
        this.btnDown.addSelectionListener((SelectionListener)this);
    }

    public void setEnabled(boolean bState) {
        if (bState) {
            if (this.sKey == null || this.sKey.length() == 0) {
                this.txtSelection.setEnabled(true);
            }
        } else {
            this.txtSelection.setEnabled(bState);
        }
        this.btnDown.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void setText(String str) {
        this.sKey = this.getKey(str);
        this.sCurrent = this.getValue(str);
        this.txtSelection.setText(this.getLocalizedValue(str));
    }

    public String getText() {
        return this.buildString();
    }

    private String buildString() {
        if (this.sKey != null && this.sKey.length() > 0) {
            return this.sKey + SEPARATOR + this.sCurrent;
        }
        return this.sCurrent;
    }

    public String getKey(String str) {
        int iSeparator = str.indexOf(SEPARATOR);
        if (iSeparator == -1) {
            iSeparator = 0;
        }
        return str.substring(0, iSeparator);
    }

    public String getValue(String str) {
        int iSeparator = str.indexOf(SEPARATOR) + SEPARATOR.length();
        if (iSeparator == -1 + SEPARATOR.length()) {
            iSeparator = 0;
        }
        return str.substring(iSeparator);
    }

    public String getLocalizedValue(String str) {
        String sTmp = "";
        sTmp = this.getKey(str);
        if ("".equals(sTmp)) {
            return this.getValue(str);
        }
        if ((sTmp = this.serviceprovider.getValue(sTmp)) == null || "".equals(sTmp)) {
            sTmp = Messages.getString("ExternalizedTextEditorComposite.Warn.KeyNotFound");
        }
        return sTmp;
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void fireEvent() {
        Event event = new Event();
        event.widget = this;
        event.type = 1;
        event.data = this.buildString();
        for (int iL = 0; iL < this.vListeners.size(); ++iL) {
            ((Listener)this.vListeners.elementAt(iL)).handleEvent(event);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        String sTxt;
        ExternalizedTextEditorDialog editor = new ExternalizedTextEditorDialog(this.getShell(), this.buildString(), this.keys, this.serviceprovider, this.sCurrent);
        if (editor.open() == 0 && (sTxt = editor.getResult()) != null) {
            this.setText(sTxt);
            this.fireEvent();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        this.sCurrent = this.txtSelection.getText();
        this.fireEvent();
    }
}

