/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FontCanvas;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class FontDefinitionComposite
extends Composite
implements SelectionListener {
    private transient Composite cmpContent = null;
    private transient FontCanvas cnvSelection = null;
    private transient Button btnEllipsis = null;
    private transient FontDefinition fdCurrent = null;
    private transient ColorDefinition cdCurrent = null;
    private transient Vector vListeners = null;
    public static final int FONT_CHANTED_EVENT = 1;
    public static final int FONT_DATA = 0;
    public static final int COLOR_DATA = 1;
    private transient int iSize = 18;
    private transient boolean bEnabled = true;
    private transient boolean isAlignmentEnabled = true;
    private transient ChartWizardContext wizardContext;

    public FontDefinitionComposite(Composite parent, int style, ChartWizardContext wizardContext, FontDefinition fdSelected, ColorDefinition cdSelected, boolean isAlignmentEnabled) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.fdCurrent = fdSelected;
        this.cdCurrent = cdSelected;
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 0;
        glContent.horizontalSpacing = 2;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.numColumns = 2;
        this.setLayout((Layout)flMain);
        this.cmpContent = new Composite((Composite)this, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.cnvSelection = new FontCanvas(this.cmpContent, 2048, this.fdCurrent, this.cdCurrent, false, true, false);
        GridData gdCNVSelection = new GridData(768);
        gdCNVSelection.heightHint = this.iSize;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.btnEllipsis = new Button(this.cmpContent, 0);
        GridData gdBEllipsis = new GridData();
        gdBEllipsis.widthHint = this.iSize - 2;
        gdBEllipsis.heightHint = this.iSize + 4;
        this.btnEllipsis.setLayoutData((Object)gdBEllipsis);
        this.btnEllipsis.setText("...");
        this.btnEllipsis.setToolTipText(Messages.getString("FontDefinitionComposite.Tooltip.FontDialog"));
        this.btnEllipsis.addSelectionListener((SelectionListener)this);
    }

    public void setEnabled(boolean bState) {
        this.btnEllipsis.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.cnvSelection.redraw();
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public FontDefinition getFontDefinition() {
        return this.fdCurrent;
    }

    public ColorDefinition getFontColor() {
        return this.cdCurrent;
    }

    public void setFontDefinition(FontDefinition fd) {
        this.fdCurrent = fd;
        this.cnvSelection.setFontDefinition(this.fdCurrent);
        this.cnvSelection.redraw();
    }

    public void setFontColor(ColorDefinition cd) {
        this.cdCurrent = cd;
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        FontDefinitionDialog fontDlg;
        Object oSource = e.getSource();
        if (oSource.equals(this.btnEllipsis) && (fontDlg = new FontDefinitionDialog(this.getShell(), this.wizardContext, this.fdCurrent, this.cdCurrent, this.isAlignmentEnabled)).open() == 0) {
            this.fdCurrent = fontDlg.getFontDefinition();
            this.cdCurrent = fontDlg.getFontColor();
            this.cnvSelection.setFontDefinition(this.fdCurrent);
            this.cnvSelection.setColor(this.cdCurrent);
            this.cnvSelection.redraw();
            this.fireEvent();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void fireEvent() {
        for (int iL = 0; iL < this.vListeners.size(); ++iL) {
            Object[] data;
            Event se = new Event();
            se.widget = this;
            se.data = data = new Object[]{this.fdCurrent, this.cdCurrent};
            se.type = 1;
            ((Listener)this.vListeners.get(iL)).handleEvent(se);
        }
    }

    public Point getPreferredSize() {
        return new Point(120, 24);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = FontDefinitionComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = FontDefinitionComposite.this.toControl(new Point(e.x, e.y));
                if (FontDefinitionComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FontDefinitionComposite.this.getBounds();
                Point pt = FontDefinitionComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

