/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class HeadStyleCanvas
extends Canvas
implements PaintListener,
FocusListener {
    int iLineDecorator = 0;
    boolean isFocusIn = false;

    public HeadStyleCanvas(Composite parent, int iStyle, int iLineDecorator) {
        super(parent, iStyle);
        this.iLineDecorator = iLineDecorator;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public int getHeadStyle() {
        return this.iLineDecorator;
    }

    public void setHeadStyle(int iLineDecorator) {
        this.iLineDecorator = iLineDecorator;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        cForeground = Display.getCurrent().getSystemColor(2);
        cBackground = Display.getCurrent().getSystemColor(25);
        GC gc = pe.gc;
        gc.setBackground(cBackground);
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.isFocusIn) {
            gc.setBackground(Display.getCurrent().getSystemColor(26));
            gc.fillRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
        }
        gc.setForeground(cForeground);
        gc.setLineWidth(1);
        gc.drawLine(10, this.getSize().y / 2, this.getSize().x - 10, this.getSize().y / 2);
        if (this.iLineDecorator == 0) {
            int[] points = new int[]{this.getSize().x - 15, this.getSize().y / 2 - 3, this.getSize().x - 15, this.getSize().y / 2 + 3, this.getSize().x - 10, this.getSize().y / 2};
            gc.setLineWidth(3);
            gc.drawPolygon(points);
        } else if (this.iLineDecorator == 1) {
            gc.setLineWidth(4);
            gc.drawOval(this.getSize().x - 14, this.getSize().y / 2 - 3, 6, 6);
        }
        if (this.isFocusIn) {
            gc.setLineStyle(3);
            gc.setLineWidth(1);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.drawRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
        }
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }
}

