/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.impl.EmbeddedImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IconCanvas;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageDialog
extends TrayDialog {
    private static final int URI_TYPE = 0;
    private static final int EMBEDDED_TYPE = 1;
    private Button embedded;
    private Button uri;
    private Button previewButton;
    private Composite inputArea;
    private IconCanvas previewCanvas;
    private Text uriEditor;
    private int selectedType = -1;
    private Fill fCurrent;
    private String imageData;
    private Label title;

    public ImageDialog(Shell parentShell, Fill fCurrent) {
        super(parentShell);
        this.fCurrent = fCurrent;
    }

    protected Control createContents(Composite parent) {
        Control ct = super.createContents(parent);
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.SelectImage_ID");
        this.initDialog();
        return ct;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(topCompostie);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        return topCompostie;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ImageDialog.label.SelectImageType"));
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.uri = new Button(selectionArea, 16);
        this.uri.setText(Messages.getString("ImageDialog.label.URLImage"));
        this.uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.selectedType = 0;
                ImageDialog.this.title.setText(Messages.getString("ImageDialog.label.EnterURL"));
                ImageDialog.this.updateButtons();
            }
        });
        this.embedded = new Button(selectionArea, 16);
        this.embedded.setText(Messages.getString("ImageDialog.label.EmbeddedImage"));
        this.embedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.selectedType = 1;
                ImageDialog.this.title.setText(Messages.getString("ImageDialog.label.EnterEmbed"));
                ImageDialog.this.updateButtons();
            }
        });
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(1840);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.inputArea.setLayoutData((Object)gd);
        this.inputArea.setLayout((Layout)new GridLayout());
        this.title = new Label(this.inputArea, 0);
        this.title.setLayoutData((Object)new GridData(768));
        this.uriEditor = new Text(this.inputArea, 2052);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageDialog.this.updateButtons();
            }
        });
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        innerComp.setLayout((Layout)new GridLayout(2, false));
        Button inputButton = new Button(innerComp, 8);
        inputButton.setText(Messages.getString("ImageDialog.label.Browse"));
        inputButton.setLayoutData((Object)new GridData(128));
        inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileChooser = new FileDialog(ImageDialog.this.getShell(), 4096);
                fileChooser.setText(Messages.getString("ImageDialog.label.SelectFile"));
                fileChooser.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png"});
                try {
                    String fileName;
                    String fullPath = fileChooser.open();
                    if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                        ImageDialog.this.imageData = null;
                        fullPath = "file:///" + fullPath;
                        ImageDialog.this.preview(fullPath);
                        ImageDialog.this.uriEditor.setText(fullPath);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.previewButton = new Button(innerComp, 8);
        this.previewButton.setText(Messages.getString("ImageDialog.label.Preview"));
        this.previewButton.setLayoutData((Object)new GridData(128));
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.preview(ImageDialog.this.uriEditor.getText());
            }
        });
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 300;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new IconCanvas(previewArea);
    }

    private void preview(String uri) {
        try {
            if (this.imageData != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])this.imageData.getBytes()));
                this.previewCanvas.loadImage(bis);
            } else {
                this.previewCanvas.loadImage(new URL(uri));
            }
        }
        catch (Exception e) {
            WizardBase.displayException((Throwable)e);
        }
    }

    private void clearPreview() {
        this.previewCanvas.clear();
    }

    protected void okPressed() {
        switch (this.selectedType) {
            case 0: {
                this.fCurrent = ImageImpl.create((String)this.uriEditor.getText().trim());
                break;
            }
            case 1: {
                this.fCurrent = EmbeddedImageImpl.create((String)this.uriEditor.getText().trim(), (String)this.imageData);
                try {
                    BufferedInputStream bis = new BufferedInputStream(new URL(this.uriEditor.getText().trim()).openStream());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    int count = bis.read(buf);
                    while (count != -1) {
                        bos.write(buf, 0, count);
                        count = bis.read(buf);
                    }
                    String data = new String(Base64.encodeBase64((byte[])bos.toByteArray()));
                    ((EmbeddedImage)this.fCurrent).setData(data);
                    break;
                }
                catch (Exception e) {
                    WizardBase.displayException((Throwable)e);
                }
            }
        }
        super.okPressed();
    }

    protected boolean initDialog() {
        this.getShell().setText(Messages.getString("ImageDialog.label.SelectImage"));
        this.initURIEditor();
        if (this.fCurrent instanceof EmbeddedImage) {
            this.embedded.setSelection(true);
            this.selectedType = 1;
        } else {
            this.uri.setSelection(true);
            this.selectedType = 0;
        }
        if (this.selectedType == 1) {
            this.title.setText(Messages.getString("ImageDialog.label.EnterEmbed"));
        } else {
            this.title.setText(Messages.getString("ImageDialog.label.EnterURL"));
        }
        this.getButton(0).setEnabled(false);
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if (this.fCurrent instanceof Image) {
            uri = ((Image)this.fCurrent).getURL();
            if (this.fCurrent instanceof EmbeddedImage) {
                this.imageData = ((EmbeddedImage)this.fCurrent).getData();
            }
        }
        this.uriEditor.setText(uri);
        this.uriEditor.setFocus();
        this.clearPreview();
    }

    private void updateButtons() {
        boolean complete = this.uriEditor.getText() != null && this.uriEditor.getText().trim().length() > 0;
        this.previewButton.setEnabled(complete);
        this.getButton(0).setEnabled(complete);
    }

    public Fill getResult() {
        return this.fCurrent;
    }
}

