/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.MarkerIconDialog;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class MarkerEditorComposite
extends Composite
implements MouseListener {
    private static final int MARKER_BLOCK_WIDTH = 20;
    private static final int MARKER_BLOCK_HEIGHT = 20;
    private static final int MARKER_ROW_MAX_NUMBER = 6;
    private transient Marker editingMarker;
    private transient IDeviceRenderer idrSWT = null;
    private transient Canvas cnvMarker;
    private transient Button btnDropDown;
    private transient Composite cmpDropDown;

    public MarkerEditorComposite(Composite parent, Marker marker) {
        super(parent, 2048);
        this.editingMarker = marker;
        this.placeComponents();
        this.initAccessible();
        this.updateMarkerPreview();
    }

    private void placeComponents() {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.cnvMarker = new Canvas((Composite)this, 0);
        GridData gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 20;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        this.cnvMarker.setLayoutData((Object)gd);
        this.cnvMarker.addMouseListener((MouseListener)this);
        this.cnvMarker.setToolTipText(this.getMarker().getType().getName());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MarkerEditorComposite.this.canvasEvent(event);
            }
        };
        int[] textEvents = new int[]{1, 2, 31, 15, 16, 9};
        for (int i = 0; i < textEvents.length; ++i) {
            this.cnvMarker.addListener(textEvents[i], listener);
        }
        this.btnDropDown = new Button((Composite)this, 1028);
        gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 16;
        this.btnDropDown.setLayoutData((Object)gd);
        this.btnDropDown.addMouseListener((MouseListener)this);
        try {
            this.idrSWT = PluginSettings.instance().getDevice("dv.SWT");
            this.idrSWT.getDisplayServer();
        }
        catch (ChartException pex) {
            WizardBase.displayException((Throwable)pex);
        }
    }

    private void canvasEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvMarker.redraw();
                break;
            }
            case 16: {
                this.cnvMarker.redraw();
                break;
            }
            case 1: {
                if (this.isDisposed() || event.keyCode != 0x1000002 && event.keyCode != 13 && event.keyCode != 0x1000050) break;
                event.doit = true;
                this.toggleDropDown();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvMarker.redraw();
                    }
                }
                break;
            }
            case 9: {
                this.paintMarker(event.gc, this.getMarker(), LocationImpl.create((double)10.0, (double)10.0));
            }
        }
    }

    public void setMarker(Marker marker) {
        this.editingMarker = marker;
        this.updateMarkerPreview();
    }

    private void updateMarkerPreview() {
        this.cnvMarker.setToolTipText(this.getMarker().getType().getName());
        this.cnvMarker.redraw();
    }

    public Marker getMarker() {
        return this.editingMarker;
    }

    private void toggleDropDown() {
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed()) {
            this.createDropDownComponent();
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    private void createDropDownComponent() {
        Point pLoc = UIHelper.getScreenLocation((Composite)this.btnDropDown.getParent());
        int iXLoc = pLoc.x;
        int iYLoc = pLoc.y + this.btnDropDown.getParent().getSize().y;
        int iShellWidth = 135;
        int iShellHeight = 150;
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= iShellWidth;
        }
        if (iXLoc + iShellWidth > this.getDisplay().getClientArea().width) {
            iXLoc = this.getDisplay().getClientArea().width - iShellWidth;
        }
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(iShellWidth, iShellHeight);
        shell.setLocation(iXLoc, iYLoc);
        this.cmpDropDown = new MarkerDropDownEditorComposite((Composite)shell, 0);
        shell.layout();
        shell.open();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.toggleDropDown();
    }

    public void mouseUp(MouseEvent e) {
    }

    private void paintMarker(GC gc, Marker currentMarker, Location location) {
        Marker renderMarker = currentMarker;
        if (currentMarker.getType() == MarkerType.ICON_LITERAL) {
            renderMarker = (Marker)EcoreUtil.copy((EObject)currentMarker);
            renderMarker.setFill((Fill)ImageImpl.create((String)UIHelper.getURL((String)"icons/obj16/marker_icon.gif").toString()));
        }
        this.idrSWT.setProperty("device.output.context", (Object)gc);
        MarkerRenderer mr = new MarkerRenderer(this.idrSWT, (Object)StructureSource.createUnknown(null), location, LineAttributesImpl.create((ColorDefinition)(this.getMarker().isVisible() ? ColorDefinitionImpl.BLUE() : ColorDefinitionImpl.GREY()), (LineStyle)LineStyle.SOLID_LITERAL, (int)1), (Fill)(this.getMarker().isVisible() ? ColorDefinitionImpl.create((int)80, (int)168, (int)218) : ColorDefinitionImpl.GREY()), renderMarker, 4, null, false, false);
        try {
            mr.draw((IPrimitiveRenderer)this.idrSWT);
        }
        catch (ChartException ex) {
            WizardBase.displayException((Throwable)ex);
        }
        if (this.cnvMarker.isFocusControl()) {
            gc.setLineStyle(3);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.drawRectangle(0, 0, this.getSize().x - 21, this.getSize().y - 5);
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = MarkerEditorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = MarkerEditorComposite.this.toControl(new Point(e.x, e.y));
                if (MarkerEditorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = MarkerEditorComposite.this.getBounds();
                Point pt = MarkerEditorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    private class MarkerDropDownEditorComposite
    extends Composite
    implements PaintListener,
    Listener {
        private Spinner iscMarkerSize;
        private Button btnMarkerVisible;
        private Composite cmpType;
        private Group grpSize;
        boolean isPressingKey;
        private final String[] typeDisplayNameSet;
        private final String[] typeNameSet;
        private int markerTypeIndex;

        MarkerDropDownEditorComposite(Composite parent, int style) {
            super(parent, style);
            this.isPressingKey = false;
            this.typeDisplayNameSet = LiteralHelper.markerTypeSet.getDisplayNames();
            this.typeNameSet = LiteralHelper.markerTypeSet.getNames();
            this.markerTypeIndex = -1;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glDropDown = new GridLayout();
            this.setLayout((Layout)glDropDown);
            this.btnMarkerVisible = new Button((Composite)this, 32);
            this.btnMarkerVisible.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.IsVisible"));
            this.btnMarkerVisible.setSelection(MarkerEditorComposite.this.getMarker().isVisible());
            this.btnMarkerVisible.addListener(13, (Listener)this);
            this.btnMarkerVisible.addListener(16, (Listener)this);
            this.btnMarkerVisible.addListener(1, (Listener)this);
            this.btnMarkerVisible.addListener(31, (Listener)this);
            this.btnMarkerVisible.setFocus();
            this.cmpType = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 6;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.cmpType.setLayout((Layout)layout);
            this.cmpType.setLayoutData((Object)new GridData(1808));
            this.cmpType.addListener(31, (Listener)this);
            this.cmpType.addListener(1, (Listener)this);
            this.cmpType.addListener(16, (Listener)this);
            int modifiedSize = (this.typeDisplayNameSet.length / 6 + 1) * 6;
            for (int i = 0; i < modifiedSize; ++i) {
                Canvas cnvType = new Canvas(this.cmpType, 0);
                GridData gd = new GridData();
                gd.heightHint = 20;
                gd.widthHint = 20;
                cnvType.setLayoutData((Object)gd);
                cnvType.setData((Object)new Integer(i));
                cnvType.addPaintListener((PaintListener)this);
                if (i >= this.typeDisplayNameSet.length) continue;
                cnvType.setToolTipText(this.typeDisplayNameSet[i]);
                cnvType.addListener(3, (Listener)this);
            }
            this.grpSize = new Group((Composite)this, 0);
            this.grpSize.setLayout((Layout)new GridLayout());
            this.grpSize.setLayoutData((Object)new GridData(768));
            this.grpSize.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.Size"));
            this.iscMarkerSize = new Spinner((Composite)this.grpSize, 2048);
            this.iscMarkerSize.setLayoutData((Object)new GridData(768));
            this.iscMarkerSize.setMinimum(0);
            this.iscMarkerSize.setMaximum(100);
            this.iscMarkerSize.addListener(13, (Listener)this);
            this.iscMarkerSize.addListener(16, (Listener)this);
            this.iscMarkerSize.addListener(31, (Listener)this);
            this.iscMarkerSize.setSelection(MarkerEditorComposite.this.getMarker().getSize());
            this.setEnabledState(this.btnMarkerVisible.getSelection());
        }

        void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnMarkerVisible)) {
                MarkerEditorComposite.this.getMarker().setVisible(this.btnMarkerVisible.getSelection());
                this.setEnabledState(this.btnMarkerVisible.getSelection());
                MarkerEditorComposite.this.cnvMarker.redraw();
            } else if (e.widget.equals(this.iscMarkerSize)) {
                MarkerEditorComposite.this.getMarker().setSize(this.iscMarkerSize.getSelection());
            }
        }

        private void setEnabledState(boolean isEnabled) {
            this.cmpType.setEnabled(isEnabled);
            this.grpSize.setEnabled(isEnabled);
            this.iscMarkerSize.setEnabled(isEnabled);
            Control[] cnvTypes = this.cmpType.getChildren();
            for (int i = 0; i < cnvTypes.length; ++i) {
                cnvTypes[i].setEnabled(isEnabled);
                cnvTypes[i].redraw();
            }
        }

        void focusLost(FocusEvent e) {
            Control currentControl = this.isPressingKey ? Display.getCurrent().getFocusControl() : Display.getCurrent().getCursorControl();
            this.isPressingKey = false;
            if (currentControl != MarkerEditorComposite.this.btnDropDown && currentControl != MarkerEditorComposite.this.cnvMarker && !this.isChildrenOfThis(currentControl)) {
                this.getShell().close();
            }
        }

        private boolean isChildrenOfThis(Control control) {
            while (control != null) {
                if (control == this) {
                    return true;
                }
                control = control.getParent();
            }
            return false;
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            int markerIndex = (Integer)e.widget.getData();
            int markerLength = this.typeNameSet.length;
            String typeName = null;
            if (markerIndex < markerLength) {
                typeName = this.typeNameSet[markerIndex];
                gc.setBackground(Display.getDefault().getSystemColor(29));
                gc.fillRectangle(0, 0, 20, 20);
            }
            int lineWidth = 1;
            if (MarkerEditorComposite.this.getMarker().isVisible()) {
                gc.setForeground(Display.getDefault().getSystemColor(2));
            } else {
                gc.setForeground(Display.getDefault().getSystemColor(15));
            }
            gc.setLineWidth(lineWidth);
            int x = lineWidth - 1;
            int y = lineWidth - 1;
            int width = 21 - 2 * lineWidth;
            int height = 21 - 2 * lineWidth;
            if (markerIndex / 6 < markerLength / 6) {
                ++height;
            }
            if ((markerIndex + 1) % 6 != 0) {
                ++width;
            }
            if (typeName == null) {
                if (markerIndex > markerLength) {
                    x = -1;
                    width += 2;
                }
                ++height;
            }
            gc.drawRectangle(x, y, width, height);
            if (MarkerEditorComposite.this.getMarker().getType().getName().equals(typeName)) {
                this.markerTypeIndex = markerIndex;
                gc.setForeground(Display.getDefault().getSystemColor(3));
                gc.drawRectangle(1, 1, 18, 18);
            }
            if (typeName != null) {
                MarkerEditorComposite.this.paintMarker(gc, MarkerImpl.create((MarkerType)MarkerType.getByName((String)typeName), (int)4), LocationImpl.create((double)10.0, (double)10.0));
            }
        }

        private void switchMarkerType(int newMarkerTypeIndex) {
            MarkerType newType = MarkerType.getByName((String)this.typeNameSet[newMarkerTypeIndex]);
            if (newType == MarkerType.ICON_LITERAL) {
                MarkerIconDialog iconDialog = new MarkerIconDialog(this.getShell(), MarkerEditorComposite.this.getMarker().getFill());
                if (iconDialog.open() == 0) {
                    Fill resultFill = iconDialog.getFill();
                    if (resultFill.eAdapters().isEmpty()) {
                        resultFill.eAdapters().addAll((Collection)MarkerEditorComposite.this.getMarker().eAdapters());
                    }
                    MarkerEditorComposite.this.getMarker().setFill(resultFill);
                } else {
                    return;
                }
            }
            MarkerEditorComposite.this.getMarker().setType(newType);
            Control[] children = this.cmpType.getChildren();
            children[newMarkerTypeIndex].redraw();
            children[this.markerTypeIndex].redraw();
            MarkerEditorComposite.this.updateMarkerPreview();
        }

        void mouseDown(MouseEvent e) {
            if (e.widget instanceof Canvas) {
                int markerIndex = (Integer)e.widget.getData();
                this.switchMarkerType(markerIndex);
                if (!this.getShell().isDisposed()) {
                    this.getShell().close();
                }
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 16: {
                    this.focusLost(new FocusEvent(event));
                    break;
                }
                case 3: {
                    this.mouseDown(new MouseEvent(event));
                    break;
                }
                case 13: {
                    this.widgetSelected(new SelectionEvent(event));
                    break;
                }
                case 1: {
                    if (event.keyCode == 27) {
                        this.getShell().close();
                        break;
                    }
                    if (event.widget != this.cmpType) break;
                    if (event.keyCode == 0x1000003) {
                        if (this.markerTypeIndex - 1 < 0) break;
                        this.switchMarkerType(this.markerTypeIndex - 1);
                        break;
                    }
                    if (event.keyCode == 0x1000004) {
                        if (this.markerTypeIndex + 1 >= this.typeNameSet.length) break;
                        this.switchMarkerType(this.markerTypeIndex + 1);
                        break;
                    }
                    if (event.keyCode == 0x1000001) {
                        if (this.markerTypeIndex - 6 < 0) break;
                        this.switchMarkerType(this.markerTypeIndex - 6);
                        break;
                    }
                    if (event.keyCode != 0x1000002 || this.markerTypeIndex + 6 >= this.typeNameSet.length) break;
                    this.switchMarkerType(this.markerTypeIndex + 6);
                    break;
                }
                case 31: {
                    switch (event.detail) {
                        case 8: 
                        case 16: {
                            event.doit = true;
                            this.isPressingKey = true;
                        }
                    }
                }
            }
        }
    }
}

