/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class SeriesGroupingComposite
extends Composite
implements SelectionListener {
    private transient Group grpContent = null;
    private transient Button btnEnabled = null;
    private transient Label lblType = null;
    private transient Combo cmbType = null;
    private transient Label lblUnit = null;
    private transient Combo cmbUnit = null;
    private transient Label lblInterval = null;
    private transient Spinner iscInterval = null;
    private transient Label lblAggregate = null;
    private transient Combo cmbAggregate = null;
    private transient SeriesDefinition sd = null;
    private transient boolean bTypeEnabled = true;

    public SeriesGroupingComposite(Composite parent, int style, SeriesDefinition sd, boolean bTypeEnabled) {
        super(parent, style);
        this.sd = sd;
        this.bTypeEnabled = bTypeEnabled;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 4;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginWidth = 7;
        glContent.marginHeight = 7;
        this.setLayout((Layout)new FillLayout());
        this.grpContent = new Group((Composite)this, 0);
        this.grpContent.setLayout((Layout)glContent);
        this.grpContent.setText(Messages.getString("SeriesGroupingComposite.Lbl.Grouping"));
        this.btnEnabled = new Button((Composite)this.grpContent, 32);
        GridData gdBTNEnabled = new GridData(32);
        gdBTNEnabled.horizontalSpan = 4;
        this.btnEnabled.setLayoutData((Object)gdBTNEnabled);
        this.btnEnabled.setText(Messages.getString("SeriesGroupingComposite.Lbl.Enabled"));
        this.btnEnabled.addSelectionListener((SelectionListener)this);
        if (this.sd.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Grouping())) {
            this.btnEnabled.setSelection(this.getGrouping().isEnabled());
        } else {
            this.btnEnabled.setSelection(false);
        }
        boolean bEnableUI = this.btnEnabled.getSelection();
        this.lblType = new Label((Composite)this.grpContent, 0);
        GridData gdLBLType = new GridData();
        this.lblType.setLayoutData((Object)gdLBLType);
        this.lblType.setText(Messages.getString("SeriesGroupingComposite.Lbl.Type"));
        this.lblType.setEnabled(bEnableUI & this.bTypeEnabled);
        this.cmbType = new Combo((Composite)this.grpContent, 12);
        GridData gdCMBType = new GridData(768);
        this.cmbType.setLayoutData((Object)gdCMBType);
        this.cmbType.addSelectionListener((SelectionListener)this);
        this.cmbType.setEnabled(bEnableUI & this.bTypeEnabled);
        this.lblUnit = new Label((Composite)this.grpContent, 0);
        GridData gdLBLUnit = new GridData();
        this.lblUnit.setLayoutData((Object)gdLBLUnit);
        this.lblUnit.setText(Messages.getString("SeriesGroupingComposite.Lbl.Unit"));
        this.cmbUnit = new Combo((Composite)this.grpContent, 12);
        GridData gdCMBUnit = new GridData(768);
        this.cmbUnit.setLayoutData((Object)gdCMBUnit);
        this.cmbUnit.addSelectionListener((SelectionListener)this);
        this.lblInterval = new Label((Composite)this.grpContent, 0);
        GridData gdLBLInterval = new GridData();
        this.lblInterval.setLayoutData((Object)gdLBLInterval);
        this.lblInterval.setText(Messages.getString("SeriesGroupingComposite.Lbl.Interval"));
        int iGroupInterval = 2;
        if (this.sd.getGrouping() != null) {
            iGroupInterval = this.sd.getGrouping().getGroupingInterval();
        }
        this.iscInterval = new Spinner((Composite)this.grpContent, 2048);
        GridData gdISCInterval = new GridData(768);
        this.iscInterval.setLayoutData((Object)gdISCInterval);
        this.iscInterval.setMinimum(0);
        this.iscInterval.setToolTipText(Messages.getString("SeriesGroupingComposite.Tooltip.SelectIntervalForGrouping"));
        this.iscInterval.setSelection(iGroupInterval);
        this.iscInterval.addSelectionListener((SelectionListener)this);
        Label lblDummy = new Label((Composite)this.grpContent, 0);
        GridData gdLBLDummy = new GridData(768);
        gdLBLDummy.horizontalSpan = 2;
        lblDummy.setLayoutData((Object)gdLBLDummy);
        GridLayout glAggregate = new GridLayout();
        glAggregate.numColumns = 2;
        glAggregate.marginHeight = 0;
        glAggregate.marginWidth = 0;
        glAggregate.horizontalSpacing = 5;
        glAggregate.verticalSpacing = 5;
        Composite cmpAggregate = new Composite((Composite)this.grpContent, 0);
        GridData gdCMPAggregate = new GridData(768);
        gdCMPAggregate.horizontalSpan = 2;
        cmpAggregate.setLayoutData((Object)gdCMPAggregate);
        cmpAggregate.setLayout((Layout)glAggregate);
        this.lblAggregate = new Label(cmpAggregate, 0);
        GridData gdLBLAggregate = new GridData();
        this.lblAggregate.setLayoutData((Object)gdLBLAggregate);
        this.lblAggregate.setText(Messages.getString("SeriesGroupingComposite.Lbl.AggregateExpression"));
        this.cmbAggregate = new Combo(cmpAggregate, 12);
        this.cmbAggregate.setLayoutData((Object)new GridData(768));
        this.cmbAggregate.addSelectionListener((SelectionListener)this);
        this.populateLists();
    }

    private void populateLists() {
        SeriesGrouping grouping = this.getGrouping();
        boolean bEnableUI = this.btnEnabled.getSelection();
        NameSet ns = LiteralHelper.dataTypeSet;
        this.cmbType.setItems(ns.getDisplayNames());
        if (bEnableUI && grouping.getGroupType() != null) {
            this.cmbType.setText(ns.getDisplayNameByName(this.getGrouping().getGroupType().getName()));
        } else {
            this.cmbType.select(0);
        }
        this.lblType.setEnabled(bEnableUI);
        this.cmbType.setEnabled(bEnableUI);
        this.lblInterval.setEnabled(bEnableUI);
        this.iscInterval.setEnabled(bEnableUI);
        ns = LiteralHelper.groupingUnitTypeSet;
        this.cmbUnit.setItems(ns.getDisplayNames());
        if (bEnableUI && grouping.getGroupType() != null && grouping.getGroupType() == DataType.DATE_TIME_LITERAL && grouping.getGroupingUnit() != null) {
            this.cmbUnit.setText(ns.getDisplayNameByName(grouping.getGroupingUnit().getName()));
        } else {
            this.cmbUnit.select(0);
        }
        this.lblUnit.setEnabled(bEnableUI && DataType.DATE_TIME_LITERAL.getName().equals(LiteralHelper.dataTypeSet.getNameByDisplayName(this.cmbType.getText())));
        this.cmbUnit.setEnabled(this.lblUnit.getEnabled());
        try {
            this.cmbAggregate.setItems(PluginSettings.instance().getRegisteredAggregateFunctionDisplayNames());
            this.cmbAggregate.setData((Object)PluginSettings.instance().getRegisteredAggregateFunctions());
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
        if (bEnableUI && grouping.getAggregateExpression() != null) {
            int idx = this.getAggregateIndexByName(grouping.getAggregateExpression());
            if (this.cmbAggregate.getItemCount() > idx) {
                this.cmbAggregate.select(idx);
            }
        } else if (this.cmbAggregate.getItemCount() > 0) {
            this.cmbAggregate.select(0);
        }
        this.lblAggregate.setEnabled(bEnableUI);
        this.cmbAggregate.setEnabled(bEnableUI);
    }

    private int getAggregateIndexByName(String name) {
        String[] names = (String[])this.cmbAggregate.getData();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        return 0;
    }

    private SeriesGrouping getGrouping() {
        return this.sd.getGrouping();
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbType)) {
            this.getGrouping().setGroupType(DataType.getByName((String)LiteralHelper.dataTypeSet.getNameByDisplayName(this.cmbType.getText())));
            boolean bEnableUI = this.btnEnabled.getSelection();
            boolean bDate = DataType.DATE_TIME_LITERAL.getName().equals(LiteralHelper.dataTypeSet.getNameByDisplayName(this.cmbType.getText()));
            this.lblUnit.setEnabled(bEnableUI & bDate);
            this.cmbUnit.setEnabled(bEnableUI & bDate);
            this.lblInterval.setEnabled(bEnableUI);
            this.iscInterval.setEnabled(bEnableUI);
            this.lblAggregate.setEnabled(bEnableUI);
            this.cmbAggregate.setEnabled(bEnableUI);
        } else if (oSource.equals(this.cmbUnit)) {
            this.getGrouping().setGroupingUnit(GroupingUnitType.getByName((String)LiteralHelper.groupingUnitTypeSet.getNameByDisplayName(this.cmbUnit.getText())));
        } else if (oSource.equals(this.cmbAggregate)) {
            int idx = this.cmbAggregate.getSelectionIndex();
            String aggExpr = null;
            if (idx >= 0) {
                String[] names = (String[])this.cmbAggregate.getData();
                aggExpr = names[idx];
            }
            this.getGrouping().setAggregateExpression(aggExpr);
        } else if (oSource.equals(this.btnEnabled)) {
            SeriesGrouping grp = null;
            if (!this.sd.eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Grouping())) {
                grp = SeriesGroupingImpl.create();
                this.sd.setGrouping(grp);
            } else {
                grp = this.sd.getGrouping();
            }
            grp.setEnabled(this.btnEnabled.getSelection());
            this.populateLists();
        } else if (oSource.equals(this.iscInterval)) {
            this.getGrouping().setGroupingInterval(this.iscInterval.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

