/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.DialScaleDialog;
import org.eclipse.birt.chart.ui.swt.composites.DialTicksDialog;
import org.eclipse.birt.chart.ui.swt.composites.HeadStyleAttributeComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MeterSeriesAttributeComposite
extends Composite
implements Listener,
ModifyListener,
SelectionListener {
    private transient Composite cmpContent = null;
    private transient Composite cmpButton = null;
    private transient LocalizedNumberEditorComposite txtRadius = null;
    private transient IntegerSpinControl iscStartAngle = null;
    private transient IntegerSpinControl iscStopAngle = null;
    private transient DialSeries series = null;
    private transient Button btnTicks = null;
    private transient Button btnScale = null;
    private transient Group grpNeedle = null;
    private transient LineAttributesComposite liacNeedle = null;
    private transient HeadStyleAttributeComposite cmbHeadStyle = null;
    private transient ChartWizardContext wizardContext;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public MeterSeriesAttributeComposite(Composite parent, int style, ChartWizardContext wizardContext, Series series) {
        super(parent, style);
        if (!(series instanceof DialSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "MeterSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (DialSeries)series;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatMeterChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(2, true);
        glContent.verticalSpacing = 0;
        glContent.horizontalSpacing = 10;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.setLayout((Layout)glContent);
        this.cmpContent = new Composite((Composite)this, 0);
        GridData gdCMPContent = new GridData(768);
        this.cmpContent.setLayoutData((Object)gdCMPContent);
        this.cmpContent.setLayout((Layout)new GridLayout(2, false));
        Label lblRadius = new Label(this.cmpContent, 0);
        GridData gdLBLRadius = new GridData(128);
        lblRadius.setLayoutData((Object)gdLBLRadius);
        lblRadius.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.Radius"));
        this.txtRadius = new LocalizedNumberEditorComposite(this.cmpContent, 2052);
        GridData gdTXTRadius = new GridData(768);
        if (this.series.getDial().isSetRadius()) {
            this.txtRadius.setValue(this.series.getDial().getRadius());
        }
        this.txtRadius.setLayoutData(gdTXTRadius);
        this.txtRadius.addModifyListener(this);
        Label lblStartAngle = new Label(this.cmpContent, 0);
        GridData gdLBLStartAngle = new GridData(128);
        lblStartAngle.setLayoutData((Object)gdLBLStartAngle);
        lblStartAngle.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.StartAngle"));
        this.iscStartAngle = new IntegerSpinControl(this.cmpContent, 0, (int)this.series.getDial().getStartAngle());
        GridData gdISCStartAngle = new GridData(768);
        this.iscStartAngle.setLayoutData(gdISCStartAngle);
        this.iscStartAngle.setValue((int)this.series.getDial().getStartAngle());
        this.iscStartAngle.setMinimum(-360);
        this.iscStartAngle.setMaximum(360);
        this.iscStartAngle.addListener(this);
        Label lblStopAngle = new Label(this.cmpContent, 0);
        GridData gdLBLStopAngle = new GridData(128);
        lblStopAngle.setLayoutData((Object)gdLBLStopAngle);
        lblStopAngle.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.StopAngle"));
        this.iscStopAngle = new IntegerSpinControl(this.cmpContent, 0, (int)this.series.getDial().getStopAngle());
        GridData gdISCStopAngle = new GridData(768);
        this.iscStopAngle.setLayoutData(gdISCStopAngle);
        this.iscStopAngle.setValue((int)this.series.getDial().getStopAngle());
        this.iscStopAngle.setMinimum(-360);
        this.iscStopAngle.setMaximum(360);
        this.iscStopAngle.addListener(this);
        this.cmpButton = new Composite(this.cmpContent, 0);
        GridData gdCMPButton = new GridData(768);
        gdCMPButton.horizontalSpan = 2;
        this.cmpButton.setLayoutData((Object)gdCMPButton);
        this.cmpButton.setLayout((Layout)new GridLayout(2, true));
        this.btnTicks = new Button(this.cmpButton, 8);
        GridData gdBTNTicks = new GridData(768);
        this.btnTicks.setLayoutData((Object)gdBTNTicks);
        this.btnTicks.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.DialTicks"));
        this.btnTicks.addSelectionListener((SelectionListener)this);
        this.btnScale = new Button(this.cmpButton, 8);
        GridData gdBTNScale = new GridData(768);
        this.btnScale.setLayoutData((Object)gdBTNScale);
        this.btnScale.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.DialScale"));
        this.btnScale.addSelectionListener((SelectionListener)this);
        GridLayout glNeedle = new GridLayout(1, true);
        glNeedle.verticalSpacing = 0;
        glNeedle.marginWidth = 10;
        glNeedle.marginHeight = 0;
        this.grpNeedle = new Group((Composite)this, 0);
        GridData gdGRPNeedle = new GridData(770);
        gdGRPNeedle.heightHint = 93;
        this.grpNeedle.setLayoutData((Object)gdGRPNeedle);
        this.grpNeedle.setText(Messages.getString("MeterSeriesAttributeSheetImpl.Lbl.Needle"));
        this.grpNeedle.setLayout((Layout)glNeedle);
        this.liacNeedle = new LineAttributesComposite((Composite)this.grpNeedle, 0, this.wizardContext, this.series.getNeedle().getLineAttributes(), true, true, false, false);
        GridData gdLIACNeedle = new GridData(768);
        gdLIACNeedle.horizontalIndent = 24;
        this.liacNeedle.setLayoutData(gdLIACNeedle);
        this.liacNeedle.addListener(this);
        this.cmbHeadStyle = new HeadStyleAttributeComposite((Composite)this.grpNeedle, 0, this.series.getNeedle().getDecorator());
        GridData gdCMBHeadStyle = new GridData(768);
        this.cmbHeadStyle.setLayoutData(gdCMBHeadStyle);
        this.cmbHeadStyle.addListener(this);
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtRadius)) {
            if (this.txtRadius.isSetValue()) {
                this.series.getDial().setRadius(this.txtRadius.getValue());
            } else {
                this.series.getDial().unsetRadius();
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.iscStartAngle)) {
            this.series.getDial().setStartAngle((double)((Integer)event.data).intValue());
        } else if (event.widget.equals((Object)this.iscStopAngle)) {
            this.series.getDial().setStopAngle((double)((Integer)event.data).intValue());
        } else if (event.widget.equals((Object)this.liacNeedle)) {
            if (event.type == 1) {
                this.series.getNeedle().getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                this.series.getNeedle().getLineAttributes().setThickness(((Integer)event.data).intValue());
            }
        } else if (event.widget.equals((Object)this.cmbHeadStyle) && event.type == 1) {
            this.series.getNeedle().setDecorator((LineDecorator)event.data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnTicks)) {
            DialTicksDialog ticksDialog = new DialTicksDialog(this.getShell(), this.wizardContext, this.series);
            this.series.setDial(ticksDialog.getDialForProcessing());
        } else if (e.widget.equals(this.btnScale)) {
            DialScaleDialog scaleDialog = new DialScaleDialog(this.getShell(), this.series);
            this.series.setDial(scaleDialog.getDialForProcessing());
        }
    }
}

