/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IRegisteredSheetEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.IRegisteredSubtaskEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIManager;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.TreeCompoundTask;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TaskFormatChart
extends TreeCompoundTask
implements IUIManager,
ITaskChangeListener {
    private transient ChartPreviewPainter previewPainter = null;
    private transient Canvas previewCanvas;
    private transient Label lblNodeTitle;
    private transient Hashtable htSheetCollections = null;
    private transient LinkedHashMap htVisibleSheets = null;
    private transient int iBaseSeriesCount = 0;
    private transient int iOrthogonalSeriesCount = 0;
    private transient int iBaseAxisCount = 0;
    private transient int iOrthogonalAxisCount = 0;
    private transient int iAncillaryAxisCount = 0;
    private static final String BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES = "BaseSeriesSheetsCWA";
    private static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES = "OrthogonalSeriesSheetsCWA";
    private static final String BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "BaseSeriesSheetsCWOA";
    private static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "OrthogonalSeriesSheetsCWOA";
    private static final String BASE_AXIS_SHEET_COLLECTION = "BaseAxisSheets";
    private static final String ORTHOGONAL_AXIS_SHEET_COLLECTION = "OrthogonalAxisSheets";
    private static final String ANCILLARY_AXIS_SHEET_COLLECTION = "AncillaryAxisSheets";
    private static final String[] BASE_SERIES_SHEETS_FOR_CHARTS_WITH_AXES = new String[]{"Series.X Series"};
    private static final String[] ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITH_AXES = new String[]{"Series.Y Series"};
    private static final String[] BASE_AXIS_SHEETS = new String[]{"Chart.Axis", "Chart.Axis.X Axis"};
    private static final String[] ORTHOGONAL_AXIS_SHEETS = new String[]{"Chart.Axis.Y Axis"};
    private static final String[] ANCILLARY_AXIS_SHEETS = new String[]{"Chart.Axis.Z Axis"};
    private static final String[] BASE_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES = new String[]{"Series.Category Series"};
    private static final String[] ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES = new String[]{"Series.Value Series"};

    public TaskFormatChart() {
        super(Messages.getString("TaskFormatChart.TaskExp"));
        this.setDescription(Messages.getString("TaskFormatChart.Task.Description"));
    }

    protected void populateSubtasks() {
        super.populateSubtasks();
        this.htVisibleSheets = new LinkedHashMap(12);
        this.htSheetCollections = new Hashtable();
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getUISheetExtensions();
        Iterator iterEntries = cRegisteredEntries.iterator();
        Vector vSortedEntries = new Vector();
        while (iterEntries.hasNext()) {
            IRegisteredSubtaskEntry entry = (IRegisteredSubtaskEntry)iterEntries.next();
            if (vSortedEntries.isEmpty()) {
                vSortedEntries.add(entry);
                continue;
            }
            int iNewIndex = entry.getNodeIndex();
            if (((IRegisteredSubtaskEntry)vSortedEntries.get(vSortedEntries.size() - 1)).getNodeIndex() <= iNewIndex) {
                vSortedEntries.add(entry);
                continue;
            }
            if (((IRegisteredSubtaskEntry)vSortedEntries.get(0)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(0, entry);
                continue;
            }
            vSortedEntries = this.addEntrySorted(vSortedEntries, entry, 0, vSortedEntries.size() - 1);
        }
        for (int i = 0; i < vSortedEntries.size(); ++i) {
            IRegisteredSubtaskEntry entry = (IRegisteredSubtaskEntry)vSortedEntries.get(i);
            ISubtaskSheet sheet = entry.getSheet();
            String sNodePath = entry.getNodePath();
            sheet.setParentTask((ITask)this);
            sheet.setNodePath(sNodePath);
            this.htVisibleSheets.put(sNodePath, sheet);
            sheet.setTitle(entry.getDisplayName());
            this.addSubtask(sNodePath, sheet);
        }
        if (this.getCurrentModelState() != null) {
            this.initialize(this.getCurrentModelState(), this);
        }
    }

    protected void updateTreeItem() {
        super.updateTreeItem();
        this.getNavigatorTree().removeAll();
        Iterator itKeys = this.htVisibleSheets.keySet().iterator();
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            Object oVal = this.htVisibleSheets.get(sKey);
            if (oVal instanceof Vector) {
                Vector vector = (Vector)oVal;
                for (int i = 0; i < vector.size(); ++i) {
                    String displayName;
                    String sSuffix = "";
                    if (vector.size() > 1) {
                        sSuffix = " - " + String.valueOf(i + 1);
                    }
                    if ((displayName = ((ISubtaskSheet)vector.get(i)).getTitle()) != null && displayName.trim().length() > 0) {
                        this.getNavigatorTree().addNode(sKey + sSuffix, displayName + sSuffix);
                        continue;
                    }
                    this.getNavigatorTree().addNode(sKey + sSuffix);
                }
                continue;
            }
            this.getNavigatorTree().addNode(sKey, ((ISubtaskSheet)oVal).getTitle());
        }
    }

    private Vector addEntrySorted(Vector vSortedEntries, IRegisteredSubtaskEntry entry, int iStart, int iEnd) {
        int iNewIndex = entry.getNodeIndex();
        if (iStart == iEnd) {
            if (((IRegisteredSheetEntry)vSortedEntries.get(iStart)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(iStart, entry);
            } else {
                vSortedEntries.add(iEnd + 1, entry);
            }
        } else if (iEnd - iStart == 1) {
            vSortedEntries.add(iEnd, entry);
        } else if (((IRegisteredSubtaskEntry)vSortedEntries.get(iStart)).getNodeIndex() == iNewIndex) {
            vSortedEntries.add(iStart + 1, entry);
        } else {
            int iHalfwayPoint = (iEnd - iStart) / 2;
            if (((IRegisteredSubtaskEntry)vSortedEntries.get(iStart + iHalfwayPoint)).getNodeIndex() > iNewIndex) {
                this.addEntrySorted(vSortedEntries, entry, iStart, iStart + iHalfwayPoint);
            } else {
                this.addEntrySorted(vSortedEntries, entry, iStart + iHalfwayPoint, iEnd);
            }
        }
        return vSortedEntries;
    }

    public boolean registerSheetCollection(String sCollection, String[] saNodePaths) {
        try {
            this.htSheetCollections.put(sCollection, saNodePaths);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String[] getRegisteredCollectionValue(String sCollection) {
        Object oArr = this.htSheetCollections.get(sCollection);
        if (oArr == null) {
            return null;
        }
        return (String[])oArr;
    }

    public boolean addCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = (String[])this.htSheetCollections.get(sCollection);
        for (int iN = 0; iN < saNodes.length; ++iN) {
            this.addVisibleSubtask(saNodes[iN]);
        }
        return true;
    }

    private void addVisibleSubtask(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            Object oSheets = this.htVisibleSheets.get(sNodeName);
            if (oSheets instanceof Vector) {
                vSheets = (Vector)oSheets;
            } else if (oSheets instanceof ISubtaskSheet) {
                vSheets.add(oSheets);
            } else {
                return;
            }
            vSheets.add(this.getSubtask(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.containSubtask(sNodeName)) {
            vSheets.add(this.getSubtask(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    private void removeVisibleTask(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            Object oSheets = this.htVisibleSheets.get(sNodeName);
            if (oSheets instanceof Vector) {
                vSheets = (Vector)oSheets;
            } else if (oSheets instanceof ISubtaskSheet) {
                vSheets.add(oSheets);
            } else {
                return;
            }
            int iLast = vSheets.lastIndexOf(this.getSubtask(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.containSubtask(sNodeName)) {
            int iLast = vSheets.lastIndexOf(this.getSubtask(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    public boolean removeCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = (String[])this.htSheetCollections.get(sCollection);
        for (int iN = 0; iN < saNodes.length; ++iN) {
            this.removeVisibleTask(saNodes[iN]);
        }
        return true;
    }

    public Chart getCurrentModelState() {
        if (this.getContext() == null) {
            return null;
        }
        return ((ChartWizardContext)this.getContext()).getModel();
    }

    public void createControl(Composite parent) {
        this.manipulateCompatible();
        super.createControl(parent);
        if (this.previewPainter == null) {
            this.createPreviewPainter();
        }
        this.doLivePreviewWithoutRenderModel();
        this.previewPainter.renderModel(this.getCurrentModelState());
    }

    protected Composite createContainer(Composite parent) {
        Composite cmpTask = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        cmpTask.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        cmpTask.setLayoutData((Object)gridData);
        this.createPreviewArea(cmpTask);
        this.lblNodeTitle = new Label(cmpTask, 0);
        this.lblNodeTitle.setFont(JFaceResources.getBannerFont());
        Label separator = new Label(cmpTask, 258);
        GridData gd = new GridData(768);
        separator.setLayoutData((Object)gd);
        return cmpTask;
    }

    private void createPreviewArea(Composite parent) {
        Composite cmpPreview = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpPreview.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(cmpPreview, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(Messages.getString("TaskFormatChart.Label.Preview"));
        this.previewCanvas = new Canvas(cmpPreview, 2048);
        this.previewCanvas.setLayoutData((Object)new GridData(1808));
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected void createSubtaskArea(Composite parent, ISubtaskSheet subtask) {
        if (this.getNavigatorTree().getSelection().length > 0) {
            this.lblNodeTitle.setText(this.getNavigatorTree().getSelection()[0].getText());
        }
        super.createSubtaskArea(parent, subtask);
    }

    private void createPreviewPainter() {
        this.previewPainter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.previewCanvas.addPaintListener((PaintListener)this.previewPainter);
        this.previewCanvas.addControlListener((ControlListener)this.previewPainter);
        this.previewPainter.setPreview(this.previewCanvas);
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            if (notification.getNotifier() instanceof SeriesGrouping || notification.getNewValue() instanceof SortOption || notification.getOldValue() instanceof SortOption || notification.getNotifier() instanceof SeriesDefinition && notification.getNewValue() instanceof Series) {
                this.doLivePreviewWithoutRenderModel();
            } else if (ChartPreviewPainter.isLivePreviewActive()) {
                ChartAdapter.ignoreNotifications((boolean)true);
                ChartUIUtil.syncRuntimeSeries((Chart)this.getCurrentModelState());
                ChartAdapter.ignoreNotifications((boolean)false);
            }
            this.previewPainter.renderModel(this.getCurrentModelState());
        }
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    private boolean hasDataSet() {
        return this.getDataServiceProvider().getReportDataSet() != null || this.getDataServiceProvider().getBoundDataSet() != null;
    }

    private void doLivePreviewWithoutRenderModel() {
        if (this.getDataServiceProvider().isLivePreviewEnabled() && ChartUIUtil.checkDataBinding((Chart)this.getCurrentModelState()) && this.hasDataSet()) {
            ChartPreviewPainter.activateLivePreview(true);
            ChartAdapter.ignoreNotifications((boolean)true);
            try {
                ChartUIUtil.doLivePreview((Chart)this.getCurrentModelState(), (IDataServiceProvider)this.getDataServiceProvider());
            }
            catch (Exception e) {
                ChartPreviewPainter.activateLivePreview(false);
            }
            ChartAdapter.ignoreNotifications((boolean)false);
        } else {
            ChartPreviewPainter.activateLivePreview(false);
        }
    }

    private void initialize(Chart chartModel, IUIManager uiManager) {
        uiManager.registerSheetCollection(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES, BASE_SERIES_SHEETS_FOR_CHARTS_WITH_AXES);
        uiManager.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES, ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITH_AXES);
        uiManager.registerSheetCollection(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, BASE_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES);
        uiManager.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES);
        uiManager.registerSheetCollection(BASE_AXIS_SHEET_COLLECTION, BASE_AXIS_SHEETS);
        uiManager.registerSheetCollection(ORTHOGONAL_AXIS_SHEET_COLLECTION, ORTHOGONAL_AXIS_SHEETS);
        uiManager.registerSheetCollection(ANCILLARY_AXIS_SHEET_COLLECTION, ANCILLARY_AXIS_SHEETS);
        if (chartModel instanceof ChartWithAxes) {
            int iOA;
            this.iBaseAxisCount = ((ChartWithAxes)chartModel).getAxes().size();
            this.iOrthogonalAxisCount = 0;
            this.iAncillaryAxisCount = 0;
            this.iBaseSeriesCount = 0;
            this.iOrthogonalSeriesCount = 0;
            for (int i = 0; i < this.iBaseAxisCount; ++i) {
                this.iBaseSeriesCount += ((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getSeriesDefinitions().size();
                this.iOrthogonalAxisCount += ((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAssociatedAxes().size();
                if (chartModel.getDimension().getValue() == 2) {
                    this.iAncillaryAxisCount += ((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAncillaryAxes().size();
                }
                for (int iS = 0; iS < this.iOrthogonalAxisCount; ++iS) {
                    this.iOrthogonalSeriesCount += ((Axis)((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAssociatedAxes().get(iS)).getSeriesDefinitions().size();
                }
            }
            for (int iBA = 1; iBA < this.iBaseAxisCount; ++iBA) {
                uiManager.addCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
            }
            for (iOA = 1; iOA < this.iOrthogonalAxisCount; ++iOA) {
                uiManager.addCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
            }
            uiManager.removeCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
            for (iOA = 0; iOA < this.iAncillaryAxisCount; ++iOA) {
                uiManager.addCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
            }
            uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            for (int iBS = 1; iBS < this.iBaseSeriesCount; ++iBS) {
                uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            }
            for (int iOS = 1; iOS < this.iOrthogonalSeriesCount; ++iOS) {
                uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            }
        } else {
            this.iBaseAxisCount = 0;
            this.iOrthogonalAxisCount = 0;
            this.iBaseSeriesCount = ((ChartWithoutAxes)chartModel).getSeriesDefinitions().size();
            this.iOrthogonalSeriesCount = 0;
            for (int iS = 0; iS < this.iBaseSeriesCount; ++iS) {
                this.iOrthogonalSeriesCount += ((SeriesDefinition)((ChartWithoutAxes)chartModel).getSeriesDefinitions().get(iS)).getSeriesDefinitions().size();
            }
            uiManager.removeCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
            uiManager.removeCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
            uiManager.removeCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
            uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            for (int iBS = 1; iBS < this.iBaseSeriesCount; ++iBS) {
                uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            }
            for (int iOS = 1; iOS < this.iOrthogonalSeriesCount; ++iOS) {
                uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            }
        }
    }

    private void manipulateCompatible() {
        if (this.getCurrentModelState().getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)this.getCurrentModelState().eAdapters());
            this.getCurrentModelState().setInteractivity(interactivity);
        }
        if (this.getCurrentModelState().getLegend().getSeparator() == null) {
            LineAttributes separator = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
            separator.setVisible(true);
            separator.eAdapters().addAll((Collection)this.getCurrentModelState().eAdapters());
            this.getCurrentModelState().getLegend().setSeparator(separator);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.htVisibleSheets != null) {
            this.htVisibleSheets.clear();
        }
        if (this.htSheetCollections != null) {
            this.htSheetCollections.clear();
        }
        this.previewCanvas = null;
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
    }
}

