/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.ui.swt.NavTree;
import org.eclipse.birt.core.ui.frameworks.taskwizard.CompoundTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeCompoundTask
extends CompoundTask
implements SelectionListener {
    private transient Composite cmpSubtaskContainer;
    private transient NavTree navTree;
    protected static final String INDEX_SEPARATOR = " - ";
    private transient Map lastSubtaskRegistry = new HashMap();
    private transient Map lastPopupRegistry = new HashMap();

    public TreeCompoundTask(String sLabel) {
        super(sLabel);
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            this.topControl.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.topControl.setLayoutData((Object)gridData);
            this.navTree = new NavTree(this.topControl, 2048);
            GridData gridData2 = new GridData(1296);
            gridData2.widthHint = 127;
            this.navTree.setLayoutData((Object)gridData2);
            this.navTree.addSelectionListener((SelectionListener)this);
            this.cmpSubtaskContainer = this.createContainer(this.topControl);
        }
        this.populateSubtasks();
        this.updateTreeItem();
        this.setDefaultSelection();
    }

    private void setDefaultSelection() {
        TreeItem lastselection = this.navTree.findTreeItem(this.getSubtaskSelection());
        if (this.navTree.getSelection().length == 0) {
            if (lastselection != null) {
                this.switchToTreeItem(lastselection);
            } else if (this.navTree.getItems().length > 0) {
                this.switchToTreeItem(this.navTree.getItems()[0]);
            }
        } else {
            this.switchToTreeItem(this.navTree.getSelection()[0]);
        }
    }

    protected Composite createContainer(Composite parent) {
        return new Composite(parent, 0);
    }

    protected void populateSubtasks() {
    }

    protected void updateTreeItem() {
    }

    protected ISubtaskSheet getSubtask(String sSubtaskPath) {
        int separatorIndex = sSubtaskPath.indexOf(INDEX_SEPARATOR);
        int subtaskIndex = 0;
        if (separatorIndex > -1) {
            subtaskIndex = Integer.parseInt(sSubtaskPath.substring(separatorIndex + INDEX_SEPARATOR.length()).trim()) - 1;
            sSubtaskPath = sSubtaskPath.substring(0, separatorIndex).trim();
        }
        ISubtaskSheet itask = super.getSubtask(sSubtaskPath);
        itask.setIndex(subtaskIndex);
        return itask;
    }

    protected boolean containSubtask(String sSubtaskPath) {
        int separatorIndex = sSubtaskPath.indexOf(INDEX_SEPARATOR);
        if (separatorIndex > -1) {
            sSubtaskPath = sSubtaskPath.substring(0, separatorIndex).trim();
        }
        return super.containSubtask(sSubtaskPath);
    }

    public void switchTo(String sSubtaskPath) {
        super.switchTo(sSubtaskPath);
        this.createSubtaskArea(this.cmpSubtaskContainer, this.getSubtask(sSubtaskPath));
        this.cmpSubtaskContainer.layout();
        this.container.packWizard();
        this.setSubtaskSelection(sSubtaskPath);
        this.container.firePageChanged((IDialogPage)this.getCurrentSubtask());
    }

    public void switchToTreeItem(TreeItem treeItem) {
        this.navTree.setSelection(new TreeItem[]{treeItem});
        this.switchTo(this.navTree.getNodePath(treeItem));
    }

    protected void createSubtaskArea(Composite parent, ISubtaskSheet subtask) {
        if (subtask != null) {
            subtask.createControl(parent);
            subtask.attachPopup(this.getPopupSelection());
        }
    }

    public NavTree getNavigatorTree() {
        return this.navTree;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Tree) {
            this.switchToTreeItem((TreeItem)e.item);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setPopupSelection(String popupName) {
        this.lastPopupRegistry.put(this.getContext().getWizardID(), popupName);
    }

    protected String getPopupSelection() {
        return (String)this.lastPopupRegistry.get(this.getContext().getWizardID());
    }

    protected void setSubtaskSelection(String subtaskPath) {
        this.lastSubtaskRegistry.put(this.getContext().getWizardID(), subtaskPath);
    }

    protected String getSubtaskSelection() {
        return (String)this.lastSubtaskRegistry.get(this.getContext().getWizardID());
    }
}

