/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.Collection;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ColorPalette;
import org.eclipse.birt.chart.ui.swt.wizard.internal.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.wizard.internal.DataTextDropListener;
import org.eclipse.birt.chart.ui.swt.wizard.internal.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BaseDataDefinitionComponent
extends DefaultSelectDataComponent
implements SelectionListener,
ModifyListener,
FocusListener,
KeyListener {
    private transient Composite cmpTop;
    private transient Text txtDefinition = null;
    private transient Button btnBuilder = null;
    private transient Button btnFormatEditor = null;
    private transient Query query = null;
    private transient SeriesDefinition seriesdefinition = null;
    private transient ChartWizardContext context = null;
    private transient String sTitle = null;
    private transient String description = "";
    private transient String tooltipWhenBlank = Messages.getString("BaseDataDefinitionComponent.Tooltip.InputValueExpression");
    private transient boolean isQueryModified;
    private transient boolean isFormatSpecifiedEnabled = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseDataDefinitionComponent(SeriesDefinition seriesdefinition, Query query, ChartWizardContext context, String sTitle) {
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        this.query = query;
        this.seriesdefinition = seriesdefinition;
        this.context = context;
        this.sTitle = sTitle == null || sTitle.length() == 0 ? Messages.getString("BaseDataDefinitionComponent.Text.SpecifyDataDefinition") : sTitle;
    }

    public Composite createArea(Composite parent) {
        int numColumns = 2;
        if (this.description != null && this.description.length() > 0) {
            ++numColumns;
        }
        if (this.isFormatSpecifiedEnabled) {
            ++numColumns;
        }
        this.cmpTop = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = numColumns;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.horizontalSpacing = 2;
        this.cmpTop.setLayout((Layout)glContent);
        GridData gd = new GridData(768);
        this.cmpTop.setLayoutData((Object)gd);
        if (this.description != null && this.description.length() > 0) {
            Label lblDesc = new Label(this.cmpTop, 0);
            lblDesc.setText(this.description);
            lblDesc.setToolTipText(this.tooltipWhenBlank);
        }
        this.txtDefinition = new Text(this.cmpTop, 2052);
        GridData gdTXTDefinition = new GridData(768);
        gdTXTDefinition.widthHint = 50;
        this.txtDefinition.setLayoutData((Object)gdTXTDefinition);
        if (this.query != null && this.query.getDefinition() != null) {
            this.txtDefinition.setText(this.query.getDefinition());
            this.txtDefinition.setToolTipText(this.getTooltipForDataText(this.query.getDefinition()));
        }
        this.txtDefinition.addModifyListener((ModifyListener)this);
        this.txtDefinition.addFocusListener((FocusListener)this);
        this.txtDefinition.addKeyListener((KeyListener)this);
        DropTarget target = new DropTarget((Control)this.txtDefinition, 1);
        Transfer[] types = new Transfer[]{SimpleTextTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DataTextDropListener(this.txtDefinition));
        DataDefinitionTextManager.getInstance().addDataDefinitionText(this.txtDefinition);
        this.btnBuilder = new Button(this.cmpTop, 8);
        GridData gdBTNBuilder = new GridData();
        gdBTNBuilder.heightHint = 20;
        gdBTNBuilder.widthHint = 20;
        this.btnBuilder.setLayoutData((Object)gdBTNBuilder);
        this.btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnBuilder.addSelectionListener((SelectionListener)this);
        this.btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
        this.btnBuilder.getImage().setBackground(this.btnBuilder.getBackground());
        this.btnBuilder.setEnabled(this.context.getUIServiceProvider().isInvokingSupported());
        if (this.isFormatSpecifiedEnabled) {
            this.btnFormatEditor = new Button(this.cmpTop, 8);
            GridData gdBTNFormatEditor = new GridData();
            gdBTNFormatEditor.heightHint = 20;
            gdBTNFormatEditor.widthHint = 20;
            this.btnFormatEditor.setLayoutData((Object)gdBTNFormatEditor);
            this.btnFormatEditor.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
            this.btnFormatEditor.addSelectionListener((SelectionListener)this);
            this.btnFormatEditor.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"));
            this.btnFormatEditor.getImage().setBackground(this.btnFormatEditor.getBackground());
        }
        this.setColor();
        return this.cmpTop;
    }

    public void selectArea(boolean selected, Object data) {
        if (data instanceof Object[]) {
            Object[] array = (Object[])data;
            this.seriesdefinition = (SeriesDefinition)array[0];
            this.query = (Query)array[1];
            this.txtDefinition.setText(this.query.getDefinition());
        }
        this.setColor();
    }

    private void setColor() {
        if (this.query != null) {
            Color cColor = ColorPalette.getInstance().getColor(this.query.getDefinition());
            ChartUIUtil.setBackgroundColor((Control)this.txtDefinition, (boolean)true, (Color)cColor);
        }
    }

    public void dispose() {
        DataDefinitionTextManager.getInstance().removeDataDefinitionText(this.txtDefinition);
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnBuilder)) {
            try {
                String sExpr = this.context.getUIServiceProvider().invoke(1, this.txtDefinition.getText(), this.context.getExtendedItem(), this.sTitle);
                this.txtDefinition.setText(sExpr);
                this.query.setDefinition(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        } else if (e.getSource().equals(this.btnFormatEditor)) {
            FormatSpecifier formatspecifier = this.seriesdefinition.getFormatSpecifier();
            FormatSpecifierDialog editor = new FormatSpecifierDialog(this.cmpTop.getShell(), formatspecifier, this.sTitle);
            if (editor.open() == 0) {
                if (editor.getFormatSpecifier() == null) {
                    this.seriesdefinition.eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_FormatSpecifier());
                } else {
                    this.seriesdefinition.setFormatSpecifier(editor.getFormatSpecifier());
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.txtDefinition)) {
            this.isQueryModified = true;
            this.txtDefinition.setToolTipText(this.getTooltipForDataText(this.txtDefinition.getText()));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e == null || e.widget.equals(this.txtDefinition)) {
            this.saveQuery();
        }
    }

    private void saveQuery() {
        if (this.isQueryModified) {
            Event e = new Event();
            e.text = this.txtDefinition.getText();
            e.data = this.txtDefinition.getText();
            e.widget = this.txtDefinition;
            e.type = 0;
            this.fireEvent(e);
            if (this.query != null) {
                this.query.setDefinition(this.txtDefinition.getText());
            } else {
                this.query = QueryImpl.create((String)this.txtDefinition.getText());
                this.query.eAdapters().addAll((Collection)this.seriesdefinition.eAdapters());
                this.seriesdefinition.setQuery(this.query);
            }
            this.setColor();
            this.txtDefinition.getParent().layout();
            this.isQueryModified = false;
        }
    }

    private String getTooltipForDataText(String queryText) {
        if (queryText.trim().length() == 0) {
            return this.tooltipWhenBlank;
        }
        return queryText;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.saveQuery();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setFormatSpecifierEnabled(boolean isEnabled) {
        this.isFormatSpecifiedEnabled = isEnabled;
    }

    public void setTooltipWhenBlank(String tootipWhenBlank) {
        this.tooltipWhenBlank = tootipWhenBlank;
    }

    static {
        $assertionsDisabled = !BaseDataDefinitionComponent.class.desiredAssertionStatus();
    }
}

