/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FractionNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerLineImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.LabelAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.TriggerEditorDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class AxisMarkersSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private transient Composite cmpContent;
    private transient Composite cmpList = null;
    private transient Button btnAddLine = null;
    private transient Button btnAddRange = null;
    private transient Button btnRemove = null;
    private transient List lstMarkers = null;
    private transient Group grpGeneral = null;
    private transient StackLayout slMarkers = null;
    private transient Composite cmpLine = null;
    private transient Group grpMarkerLine = null;
    private transient Label lblValue = null;
    private transient TextEditorComposite txtValue = null;
    private transient Button btnLineFormatSpecifier = null;
    private transient Label lblAnchor = null;
    private transient Combo cmbLineAnchor = null;
    private transient LineAttributesComposite liacMarkerLine = null;
    private transient Composite cmpRange = null;
    private transient Group grpMarkerRange = null;
    private transient Label lblStartValue = null;
    private transient TextEditorComposite txtStartValue = null;
    private transient Button btnStartFormatSpecifier = null;
    private transient Label lblEndValue = null;
    private transient TextEditorComposite txtEndValue = null;
    private transient Button btnEndFormatSpecifier = null;
    private transient Label lblRangeAnchor = null;
    private transient Combo cmbRangeAnchor = null;
    private transient Label lblRangeFill = null;
    private transient FillChooserComposite fccRange = null;
    private transient LineAttributesComposite liacMarkerRange = null;
    private transient LabelAttributesComposite lacLabel = null;
    private transient Button btnLineTriggers;
    private transient Button btnRangeTriggers;
    private transient int iLineCount = 0;
    private transient int iRangeCount = 0;
    private transient Axis axis;
    private transient String MARKER_LINE_LABEL = Messages.getString("AxisMarkersSheet.MarkerLine.displayName");
    private transient String MARKER_RANGE_LABEL = Messages.getString("AxisMarkersSheet.MarkerRange.displayName");

    public AxisMarkersSheet(String title, ChartWizardContext context, Axis axis) {
        super(title, context, true);
        this.axis = axis;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Markers_ID");
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glList = new GridLayout();
        glList.numColumns = 3;
        glList.horizontalSpacing = 5;
        glList.verticalSpacing = 5;
        glList.marginHeight = 0;
        glList.marginWidth = 0;
        this.cmpList = new Composite(this.cmpContent, 0);
        GridData gdCMPList = new GridData(1808);
        gdCMPList.horizontalSpan = 2;
        this.cmpList.setLayoutData((Object)gdCMPList);
        this.cmpList.setLayout((Layout)glList);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 3;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginHeight = 5;
        glButtons.marginWidth = 0;
        Composite cmpButtons = new Composite(this.cmpList, 0);
        GridData gdCMPButtons = new GridData(768);
        gdCMPButtons.horizontalSpan = 3;
        cmpButtons.setLayoutData((Object)gdCMPButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.btnAddLine = new Button(cmpButtons, 8);
        GridData gdBTNAddLine = new GridData(768);
        this.btnAddLine.setLayoutData((Object)gdBTNAddLine);
        this.btnAddLine.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.AddLine"));
        this.btnAddLine.addSelectionListener((SelectionListener)this);
        this.btnAddRange = new Button(cmpButtons, 8);
        GridData gdBTNAddRange = new GridData(768);
        this.btnAddRange.setLayoutData((Object)gdBTNAddRange);
        this.btnAddRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.AddRange"));
        this.btnAddRange.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpButtons, 8);
        GridData gdBTNRemove = new GridData(768);
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RemoveEntry"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.lstMarkers = new List(this.cmpList, 2564);
        GridData gdLSTMarkers = new GridData(768);
        gdLSTMarkers.horizontalSpan = 3;
        gdLSTMarkers.heightHint = 100;
        this.lstMarkers.setLayoutData((Object)gdLSTMarkers);
        this.lstMarkers.addSelectionListener((SelectionListener)this);
        this.slMarkers = new StackLayout();
        this.slMarkers.marginHeight = 0;
        this.slMarkers.marginWidth = 0;
        this.grpGeneral = new Group(this.cmpContent, 0);
        GridData gdCMPGeneral = new GridData(770);
        this.grpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.grpGeneral.setLayout((Layout)this.slMarkers);
        this.grpGeneral.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerProperties"));
        GridLayout glMarkerLine = new GridLayout();
        glMarkerLine.numColumns = 3;
        glMarkerLine.horizontalSpacing = 5;
        glMarkerLine.verticalSpacing = 5;
        glMarkerLine.marginHeight = 7;
        glMarkerLine.marginWidth = 7;
        this.cmpLine = new Composite((Composite)this.grpGeneral, 0);
        GridData gdGRPLine = new GridData(768);
        this.cmpLine.setLayoutData((Object)gdGRPLine);
        this.cmpLine.setLayout((Layout)glMarkerLine);
        this.lblValue = new Label(this.cmpLine, 0);
        GridData gdLBLValue = new GridData();
        gdLBLValue.horizontalIndent = 5;
        this.lblValue.setLayoutData((Object)gdLBLValue);
        this.lblValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Value"));
        this.txtValue = new TextEditorComposite(this.cmpLine, 2052, false);
        GridData gdTXTValue = new GridData(768);
        this.txtValue.setLayoutData(gdTXTValue);
        this.txtValue.addListener(this);
        this.btnLineFormatSpecifier = new Button(this.cmpLine, 8);
        GridData gdBTNLineFormatSpecifier = new GridData();
        gdBTNLineFormatSpecifier.heightHint = 18;
        gdBTNLineFormatSpecifier.widthHint = 18;
        this.btnLineFormatSpecifier.setLayoutData((Object)gdBTNLineFormatSpecifier);
        this.btnLineFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnLineFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnLineFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnLineFormatSpecifier.getImage().setBackground(this.btnLineFormatSpecifier.getBackground());
        this.lblAnchor = new Label(this.cmpLine, 0);
        GridData gdLBLAnchor = new GridData();
        gdLBLAnchor.horizontalIndent = 5;
        this.lblAnchor.setLayoutData((Object)gdLBLAnchor);
        this.lblAnchor.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Anchor"));
        this.cmbLineAnchor = new Combo(this.cmpLine, 12);
        GridData gdCMBAnchor = new GridData(768);
        gdCMBAnchor.horizontalSpan = 2;
        this.cmbLineAnchor.setLayoutData((Object)gdCMBAnchor);
        this.cmbLineAnchor.addSelectionListener((SelectionListener)this);
        this.grpMarkerLine = new Group(this.cmpLine, 0);
        GridData gdGRPMarkerLine = new GridData(768);
        gdGRPMarkerLine.horizontalSpan = 3;
        this.grpMarkerLine.setLayoutData((Object)gdGRPMarkerLine);
        this.grpMarkerLine.setLayout((Layout)new FillLayout());
        this.grpMarkerLine.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLineAttributes"));
        this.liacMarkerLine = new LineAttributesComposite((Composite)this.grpMarkerLine, 0, this.getContext(), null, true, true, true);
        this.liacMarkerLine.addListener(this);
        this.btnLineTriggers = new Button(this.cmpLine, 8);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnLineTriggers.setLayoutData((Object)gd);
        this.btnLineTriggers.setText(Messages.getString("SeriesYSheetImpl.Label.Interactivity"));
        this.btnLineTriggers.addSelectionListener((SelectionListener)this);
        this.btnLineTriggers.setEnabled(this.getChart().getInteractivity().isEnable());
        GridLayout glMarkerRange = new GridLayout();
        glMarkerRange.numColumns = 3;
        glMarkerRange.horizontalSpacing = 5;
        glMarkerRange.verticalSpacing = 5;
        glMarkerRange.marginHeight = 7;
        glMarkerRange.marginWidth = 7;
        this.cmpRange = new Composite((Composite)this.grpGeneral, 0);
        GridData gdGRPRange = new GridData(768);
        this.cmpRange.setLayoutData((Object)gdGRPRange);
        this.cmpRange.setLayout((Layout)glMarkerRange);
        this.lblStartValue = new Label(this.cmpRange, 0);
        GridData gdLBLStartValue = new GridData();
        gdLBLStartValue.horizontalIndent = 5;
        this.lblStartValue.setLayoutData((Object)gdLBLStartValue);
        this.lblStartValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.StartValue"));
        this.txtStartValue = new TextEditorComposite(this.cmpRange, 2052, false);
        GridData gdTXTStartValue = new GridData(768);
        this.txtStartValue.setLayoutData(gdTXTStartValue);
        this.txtStartValue.addListener(this);
        this.btnStartFormatSpecifier = new Button(this.cmpRange, 8);
        GridData gdBTNStartFormatSpecifier = new GridData();
        gdBTNStartFormatSpecifier.heightHint = 18;
        gdBTNStartFormatSpecifier.widthHint = 18;
        this.btnStartFormatSpecifier.setLayoutData((Object)gdBTNStartFormatSpecifier);
        this.btnStartFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnStartFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnStartFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnStartFormatSpecifier.getImage().setBackground(this.btnStartFormatSpecifier.getBackground());
        this.lblEndValue = new Label(this.cmpRange, 0);
        GridData gdLBLEndValue = new GridData();
        gdLBLEndValue.horizontalIndent = 5;
        this.lblEndValue.setLayoutData((Object)gdLBLEndValue);
        this.lblEndValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.EndValue"));
        this.txtEndValue = new TextEditorComposite(this.cmpRange, 2052, false);
        GridData gdTXTEndValue = new GridData(768);
        this.txtEndValue.setLayoutData(gdTXTEndValue);
        this.txtEndValue.addListener(this);
        this.btnEndFormatSpecifier = new Button(this.cmpRange, 8);
        GridData gdBTNEndFormatSpecifier = new GridData();
        gdBTNEndFormatSpecifier.heightHint = 18;
        gdBTNEndFormatSpecifier.widthHint = 18;
        this.btnEndFormatSpecifier.setLayoutData((Object)gdBTNEndFormatSpecifier);
        this.btnEndFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnEndFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnEndFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnEndFormatSpecifier.getImage().setBackground(this.btnEndFormatSpecifier.getBackground());
        this.lblRangeAnchor = new Label(this.cmpRange, 0);
        GridData gdLBLRangeAnchor = new GridData();
        gdLBLRangeAnchor.horizontalIndent = 5;
        this.lblRangeAnchor.setLayoutData((Object)gdLBLRangeAnchor);
        this.lblRangeAnchor.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Anchor"));
        this.cmbRangeAnchor = new Combo(this.cmpRange, 12);
        GridData gdCMBRangeAnchor = new GridData(768);
        gdCMBRangeAnchor.horizontalSpan = 2;
        this.cmbRangeAnchor.setLayoutData((Object)gdCMBRangeAnchor);
        this.cmbRangeAnchor.addSelectionListener((SelectionListener)this);
        this.lblRangeFill = new Label(this.cmpRange, 0);
        GridData gdLBLRangeFill = new GridData();
        gdLBLRangeFill.horizontalIndent = 5;
        this.lblRangeFill.setLayoutData((Object)gdLBLRangeFill);
        this.lblRangeFill.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Fill"));
        this.fccRange = new FillChooserComposite(this.cmpRange, 0, this.getContext(), null, true, true);
        GridData gdFCCRange = new GridData(768);
        gdFCCRange.horizontalSpan = 2;
        this.fccRange.setLayoutData(gdFCCRange);
        this.fccRange.addListener(this);
        this.grpMarkerRange = new Group(this.cmpRange, 0);
        GridData gdGRPMarkerRange = new GridData(768);
        gdGRPMarkerRange.horizontalSpan = 3;
        this.grpMarkerRange.setLayoutData((Object)gdGRPMarkerRange);
        this.grpMarkerRange.setLayout((Layout)new FillLayout());
        this.grpMarkerRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RangeOutline"));
        this.liacMarkerRange = new LineAttributesComposite((Composite)this.grpMarkerRange, 0, this.getContext(), null, true, true, true);
        this.liacMarkerRange.addListener(this);
        this.btnRangeTriggers = new Button(this.cmpRange, 8);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 2;
        this.btnRangeTriggers.setLayoutData((Object)gd2);
        this.btnRangeTriggers.setText(Messages.getString("SeriesYSheetImpl.Label.Interactivity"));
        this.btnRangeTriggers.addSelectionListener((SelectionListener)this);
        this.btnRangeTriggers.setEnabled(this.getChart().getInteractivity().isEnable());
        LabelAttributesComposite.LabelAttributesContext attributesContext = new LabelAttributesComposite.LabelAttributesContext();
        attributesContext.isPositionEnabled = false;
        attributesContext.isFontAlignmentEnabled = false;
        attributesContext.isLabelEnabled = true;
        this.lacLabel = new LabelAttributesComposite(this.cmpContent, 0, this.getContext(), attributesContext, Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLabelProperties"), Position.ABOVE_LITERAL, LabelImpl.create(), this.getChart().getUnits());
        GridData gdLACLabel = new GridData(770);
        this.lacLabel.setLayoutData(gdLACLabel);
        this.lacLabel.addListener(this);
        this.slMarkers.topControl = this.cmpLine;
        this.populateLists();
        this.refreshButtons();
        this.setAllEnabled(!this.getAxisForProcessing().isCategoryAxis() || this.getAxisForProcessing().getType().equals(AxisType.TEXT_LITERAL));
        return this.cmpContent;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.lacLabel)) {
            if (this.lstMarkers.getSelection().length != 0) {
                switch (event.type) {
                    case 1: {
                        this.getSelectedMarkerLabel().setVisible(((Boolean)event.data).booleanValue());
                        break;
                    }
                    case 3: {
                        this.getSelectedMarkerLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
                        this.getSelectedMarkerLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
                        break;
                    }
                    case 4: {
                        this.getSelectedMarkerLabel().setBackground((Fill)event.data);
                        break;
                    }
                    case 5: {
                        this.getSelectedMarkerLabel().setShadowColor((ColorDefinition)event.data);
                        break;
                    }
                    case 6: {
                        this.getSelectedMarkerLabel().getOutline().setStyle((LineStyle)event.data);
                        break;
                    }
                    case 7: {
                        this.getSelectedMarkerLabel().getOutline().setThickness(((Integer)event.data).intValue());
                        break;
                    }
                    case 8: {
                        this.getSelectedMarkerLabel().getOutline().setColor((ColorDefinition)event.data);
                        break;
                    }
                    case 9: {
                        this.getSelectedMarkerLabel().getOutline().setVisible(((Boolean)event.data).booleanValue());
                        break;
                    }
                    case 10: {
                        this.getSelectedMarkerLabel().setInsets((Insets)event.data);
                        break;
                    }
                    case 11: {
                        this.getSelectedMarkerLabel().getCaption().setValue((String)event.data);
                    }
                }
            }
        } else if (event.widget.equals((Object)this.fccRange)) {
            ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).setFill((Fill)event.data);
        } else if (event.widget.equals((Object)this.txtValue)) {
            MarkerLine line = (MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex());
            if (event.type == 0) {
                line.setValue(this.getTypedDataElement(this.txtValue.getText()));
            }
            if (event.type == 1 && !(line.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                FractionNumberFormatSpecifier ffs = FractionNumberFormatSpecifierImpl.create();
                line.setFormatSpecifier((FormatSpecifier)ffs);
            }
        } else if (event.widget.equals((Object)this.txtStartValue)) {
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            if (event.type == 0) {
                range.setStartValue(this.getTypedDataElement(this.txtStartValue.getText()));
            }
            if (event.type == 1 && !(range.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                FractionNumberFormatSpecifier ffs = FractionNumberFormatSpecifierImpl.create();
                range.setFormatSpecifier((FormatSpecifier)ffs);
            }
        } else if (event.widget.equals((Object)this.txtEndValue)) {
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            if (event.type == 0) {
                range.setEndValue(this.getTypedDataElement(this.txtEndValue.getText()));
            }
            if (event.type == 1 && !(range.getFormatSpecifier() instanceof FractionNumberFormatSpecifier)) {
                FractionNumberFormatSpecifier ffs = FractionNumberFormatSpecifierImpl.create();
                range.setFormatSpecifier((FormatSpecifier)ffs);
            }
        } else if (event.widget.equals((Object)this.liacMarkerLine)) {
            if (event.type == 1) {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes().setColor((ColorDefinition)event.data);
            } else {
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
            }
        } else if (event.widget.equals((Object)this.liacMarkerRange)) {
            if (event.type == 1) {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline().setColor((ColorDefinition)event.data);
            } else {
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getOutline().setVisible(((Boolean)event.data).booleanValue());
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAddLine)) {
            MarkerLine line = MarkerLineImpl.create((Axis)this.getAxisForProcessing(), (DataElement)this.getTypedDataElement(""));
            line.eAdapters().addAll((Collection)this.getAxisForProcessing().eAdapters());
            ++this.iLineCount;
            this.buildList();
            this.lstMarkers.select(this.lstMarkers.getItemCount() - 1);
            this.updateUIForSelection();
            if (this.lstMarkers.getItemCount() == 1) {
                this.setState(true);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.btnAddRange)) {
            MarkerRange range = MarkerRangeImpl.create((Axis)this.getAxisForProcessing(), (DataElement)this.getTypedDataElement(""), (DataElement)this.getTypedDataElement(""), (Fill)ColorDefinitionImpl.TRANSPARENT());
            range.eAdapters().addAll((Collection)this.getAxisForProcessing().eAdapters());
            ++this.iRangeCount;
            this.buildList();
            this.lstMarkers.select(this.lstMarkers.getItemCount() - 1);
            this.updateUIForSelection();
            if (this.lstMarkers.getItemCount() == 1) {
                this.setState(true);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.btnRemove)) {
            if (this.lstMarkers.getSelection().length == 0) {
                return;
            }
            String sSelectedMarker = this.lstMarkers.getSelection()[0];
            boolean bLine = sSelectedMarker.startsWith(this.MARKER_LINE_LABEL);
            int iMarkerIndex = this.getMarkerIndex();
            if (bLine) {
                this.getAxisForProcessing().getMarkerLines().remove(iMarkerIndex);
                --this.iLineCount;
            } else {
                this.getAxisForProcessing().getMarkerRanges().remove(iMarkerIndex);
                --this.iRangeCount;
            }
            this.buildList();
            if (this.lstMarkers.getItemCount() > 0) {
                this.lstMarkers.select(0);
                this.updateUIForSelection();
            } else {
                this.setState(false);
                this.resetUI();
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.lstMarkers)) {
            this.updateUIForSelection();
            this.refreshButtons();
        } else if (e.getSource().equals(this.cmbLineAnchor)) {
            ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).setLabelAnchor(Anchor.getByName((String)LiteralHelper.anchorSet.getNameByDisplayName(this.cmbLineAnchor.getText())));
        } else if (e.getSource().equals(this.cmbRangeAnchor)) {
            ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).setLabelAnchor(Anchor.getByName((String)LiteralHelper.anchorSet.getNameByDisplayName(this.cmbRangeAnchor.getText())));
        } else if (e.getSource().equals(this.btnLineFormatSpecifier)) {
            FormatSpecifierDialog editor;
            String sAxisTitle = "";
            try {
                sAxisTitle = new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.ForAxis")).format(new Object[]{this.getAxisForProcessing().getTitle().getCaption().getValue()});
            }
            catch (NullPointerException e1) {
                // empty catch block
            }
            FormatSpecifier formatspecifier = null;
            if (((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getFormatSpecifier() != null) {
                formatspecifier = ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getFormatSpecifier();
            }
            if ((editor = new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerLine")).format(new Object[]{new Integer(this.getMarkerIndex() + 1), sAxisTitle}))).open() == 0) {
                if (editor.getFormatSpecifier() == null) {
                    ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getMarkerLine_FormatSpecifier());
                    return;
                }
                ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).setFormatSpecifier(editor.getFormatSpecifier());
            }
        } else if (e.getSource().equals(this.btnStartFormatSpecifier) || e.getSource().equals(this.btnEndFormatSpecifier)) {
            FormatSpecifierDialog editor;
            String sAxisTitle = "";
            try {
                String sTitleString = this.getAxisForProcessing().getTitle().getCaption().getValue();
                int iSeparatorIndex = sTitleString.indexOf("=");
                if (iSeparatorIndex > 0) {
                    sTitleString = sTitleString.substring(iSeparatorIndex);
                } else if (iSeparatorIndex == 0) {
                    sTitleString = sTitleString.substring("=".length());
                }
                sAxisTitle = new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.ForAxis")).format(new Object[]{sTitleString});
            }
            catch (NullPointerException e1) {
                // empty catch block
            }
            FormatSpecifier formatspecifier = null;
            if (((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getFormatSpecifier() != null) {
                formatspecifier = ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getFormatSpecifier();
            }
            if ((editor = new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, new MessageFormat(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.MarkerRange")).format(new Object[]{new Integer(this.getMarkerIndex() + 1), sAxisTitle}))).open() == 0) {
                if (editor.getFormatSpecifier() == null) {
                    ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getMarkerRange_FormatSpecifier());
                    return;
                }
                ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).setFormatSpecifier(editor.getFormatSpecifier());
            }
        } else if (e.widget.equals(this.btnLineTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex())).getTriggers(), this.getContext(), Messages.getString("AxisMarkersSheet.Title.MarkerLine"), false, true).open();
        } else if (e.widget.equals(this.btnRangeTriggers)) {
            new TriggerEditorDialog(this.cmpContent.getShell(), ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex())).getTriggers(), this.getContext(), Messages.getString("AxisMarkersSheet.Title.MarkerRange"), false, true).open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }

    private String getValueAsString(DataElement de) {
        String sValue = "";
        if (de instanceof NumberDataElement) {
            sValue = ChartUIUtil.getDefaultNumberFormatInstance().format(((NumberDataElement)de).getValue());
        } else if (de instanceof DateTimeDataElement) {
            Date date = new Date(((DateTimeDataElement)de).getValue());
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            sValue = sdf.format(date);
        }
        return sValue;
    }

    private int getMarkerIndex() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        int iSelectionIndex = this.lstMarkers.getSelectionIndex();
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            return iSelectionIndex;
        }
        return iSelectionIndex - this.getAxisForProcessing().getMarkerLines().size();
    }

    private void buildList() {
        this.lstMarkers.removeAll();
        this.iLineCount = this.getAxisForProcessing().getMarkerLines().size();
        this.iRangeCount = this.getAxisForProcessing().getMarkerRanges().size();
        for (int iLines = 0; iLines < this.iLineCount; ++iLines) {
            this.lstMarkers.add(this.MARKER_LINE_LABEL + " - " + (iLines + 1));
        }
        for (int iRanges = 0; iRanges < this.iRangeCount; ++iRanges) {
            this.lstMarkers.add(this.MARKER_RANGE_LABEL + " - " + (iRanges + 1));
        }
    }

    private void refreshButtons() {
        this.btnRemove.setEnabled(this.lstMarkers.getSelectionIndex() != -1);
    }

    private void updateUIForSelection() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            this.slMarkers.topControl = this.cmpLine;
            this.grpGeneral.layout();
            MarkerLine line = (MarkerLine)this.getAxisForProcessing().getMarkerLines().get(this.getMarkerIndex());
            this.txtValue.setText(this.getValueAsString(line.getValue()));
            this.cmbLineAnchor.setText(LiteralHelper.anchorSet.getDisplayNameByName(line.getLabelAnchor().getName()));
            this.liacMarkerLine.setLineAttributes(line.getLineAttributes());
            this.lacLabel.setLabel(line.getLabel(), this.getChart().getUnits());
        } else {
            this.slMarkers.topControl = this.cmpRange;
            this.grpGeneral.layout();
            MarkerRange range = (MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(this.getMarkerIndex());
            this.txtStartValue.setText(this.getValueAsString(range.getStartValue()));
            this.txtEndValue.setText(this.getValueAsString(range.getEndValue()));
            this.cmbRangeAnchor.setText(LiteralHelper.anchorSet.getDisplayNameByName(range.getLabelAnchor().getName()));
            this.fccRange.setFill(range.getFill());
            this.liacMarkerRange.setLineAttributes(range.getOutline());
            this.lacLabel.setLabel(range.getLabel(), this.getChart().getUnits());
        }
    }

    private void populateLists() {
        this.buildList();
        NameSet ns = LiteralHelper.anchorSet;
        this.cmbLineAnchor.setItems(ns.getDisplayNames());
        this.cmbLineAnchor.select(0);
        this.cmbRangeAnchor.setItems(ns.getDisplayNames());
        this.cmbRangeAnchor.select(0);
        if (this.lstMarkers.getItemCount() > 0) {
            this.lstMarkers.select(0);
            this.updateUIForSelection();
        } else {
            this.setState(false);
        }
    }

    private void setState(boolean bState) {
        this.btnLineFormatSpecifier.setEnabled(bState);
        this.lblAnchor.setEnabled(bState);
        this.cmbLineAnchor.setEnabled(bState);
        this.lblValue.setEnabled(bState);
        this.txtValue.setEnabled(bState);
        this.liacMarkerLine.setAttributesEnabled(bState);
        this.btnLineTriggers.setEnabled(bState && this.getChart().getInteractivity().isEnable());
        this.btnStartFormatSpecifier.setEnabled(bState);
        this.btnEndFormatSpecifier.setEnabled(bState);
        this.lblRangeAnchor.setEnabled(bState);
        this.cmbRangeAnchor.setEnabled(bState);
        this.lblStartValue.setEnabled(bState);
        this.txtStartValue.setEnabled(bState);
        this.lblEndValue.setEnabled(bState);
        this.txtEndValue.setEnabled(bState);
        this.liacMarkerRange.setAttributesEnabled(bState);
        this.lacLabel.setEnabled(bState);
        this.lblRangeFill.setEnabled(bState);
        this.fccRange.setEnabled(bState);
        this.btnRangeTriggers.setEnabled(bState && this.getChart().getInteractivity().isEnable());
        this.grpGeneral.setEnabled(bState);
        this.grpMarkerLine.setEnabled(bState);
        this.grpMarkerRange.setEnabled(bState);
    }

    private void resetUI() {
        this.cmbLineAnchor.select(0);
        this.cmbRangeAnchor.select(0);
        this.slMarkers.topControl = this.cmpLine;
        this.txtValue.setText("");
        this.liacMarkerLine.setLineAttributes(null);
        this.liacMarkerLine.layout();
        this.txtStartValue.setText("");
        this.txtEndValue.setText("");
        this.fccRange.setFill(null);
        this.liacMarkerRange.setLineAttributes(null);
        this.liacMarkerRange.layout();
        this.lacLabel.setLabel(LabelImpl.create(), this.getChart().getUnits());
        this.lacLabel.layout();
    }

    private org.eclipse.birt.chart.model.component.Label getSelectedMarkerLabel() {
        String sSelectedMarker = this.lstMarkers.getSelection()[0];
        int iMarkerIndex = this.getMarkerIndex();
        if (sSelectedMarker.startsWith(this.MARKER_LINE_LABEL)) {
            return ((MarkerLine)this.getAxisForProcessing().getMarkerLines().get(iMarkerIndex)).getLabel();
        }
        return ((MarkerRange)this.getAxisForProcessing().getMarkerRanges().get(iMarkerIndex)).getLabel();
    }

    private DataElement getTypedDataElement(String strDataElement) {
        Axis axis = this.getAxisForProcessing();
        if (strDataElement.trim().length() == 0) {
            if (axis.getType().equals(AxisType.DATE_TIME_LITERAL) && !axis.isCategoryAxis()) {
                Date dateElement = new Date();
                Calendar cal = Calendar.getInstance((TimeZone)TimeZone.getDefault());
                cal.setTime(dateElement);
                return DateTimeDataElementImpl.create((Calendar)cal);
            }
            return NumberDataElementImpl.create((double)0.0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        if (axis.getType().equals(AxisType.DATE_TIME_LITERAL) && !axis.isCategoryAxis()) {
            try {
                Date dateElement = sdf.parse(strDataElement);
                Calendar cal = Calendar.getInstance((TimeZone)TimeZone.getDefault());
                cal.setTime(dateElement);
                return DateTimeDataElementImpl.create((Calendar)cal);
            }
            catch (ParseException e) {
                return DateTimeDataElementImpl.create((long)new Date().getTime());
            }
        }
        try {
            return NumberDataElementImpl.create((double)ChartUIUtil.getDefaultNumberFormatInstance().parse(strDataElement).doubleValue());
        }
        catch (ParseException e1) {
            return NumberDataElementImpl.create((double)0.0);
        }
    }

    private void setEnabled(Control control, boolean isEnabled) {
        control.setEnabled(isEnabled && control.isEnabled());
    }

    private void setAllEnabled(boolean isEnabled) {
        this.setState(isEnabled && this.lstMarkers.getItemCount() > 0);
        this.setEnabled((Control)this.cmpContent, isEnabled);
        this.setEnabled((Control)this.btnAddLine, isEnabled);
        this.setEnabled((Control)this.btnAddRange, isEnabled);
        this.setEnabled((Control)this.btnRemove, isEnabled);
    }
}

