/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import java.util.Collection;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.MarkerEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class LineSeriesMarkerSheet
extends AbstractPopupSheet
implements SelectionListener {
    private transient LineSeries series;
    private transient IDeviceRenderer idrSWT = null;
    private static final int MARKER_BLOCK_WIDTH = 40;
    private static final int MARKER_BLOCK_HEIGHT = 25;
    private static final int MARKER_ROW_MAX_NUMBER = 4;
    private static final int MARKER_COLUMN_MAX_NUMBER = 3;
    private transient Canvas cnvMarkers;
    private transient Button btnAdd;
    private transient Button btnRemove;
    private transient Button btnUp;
    private transient Button btnDown;
    private transient MarkerEditorComposite newMarkerEditor;
    private transient MarkerEditorComposite currentMarkerEditor;
    private transient int iSelectedIndex = 0;
    private transient int iStartRow = 0;

    public LineSeriesMarkerSheet(String title, ChartWizardContext context, LineSeries series) {
        super(title, context, false);
        this.series = series;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatLineChartSeriesMarkers_ID");
        Composite cmpContent = new Composite(parent, 524288);
        GridLayout layout = new GridLayout();
        cmpContent.setLayout((Layout)layout);
        Group grpTop = new Group(cmpContent, 524288);
        GridLayout layout2 = new GridLayout(5, false);
        grpTop.setLayout((Layout)layout2);
        grpTop.setLayoutData((Object)new GridData());
        grpTop.setText(Messages.getString("LineSeriesMarkerSheet.Label.Markers"));
        this.cnvMarkers = new Canvas((Composite)grpTop, 512);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 5;
        gd.widthHint = 170;
        gd.heightHint = 80;
        this.cnvMarkers.setLayoutData((Object)gd);
        Listener canvasMarkerslistener = new Listener(){

            public void handleEvent(Event event) {
                LineSeriesMarkerSheet.this.handleEventCanvasMarkers(event);
            }
        };
        int[] canvasMarkersEvents = new int[]{1, 3, 31, 9};
        for (int i = 0; i < canvasMarkersEvents.length; ++i) {
            this.cnvMarkers.addListener(canvasMarkersEvents[i], canvasMarkerslistener);
        }
        this.updateScrollBar();
        this.cnvMarkers.getVerticalBar().addSelectionListener((SelectionListener)this);
        this.btnAdd = new Button((Composite)grpTop, 0);
        this.btnAdd.setText(Messages.getString("LineSeriesMarkerSheet.Label.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.newMarkerEditor = new MarkerEditorComposite((Composite)grpTop, this.createMarker());
        this.btnRemove = new Button((Composite)grpTop, 0);
        this.btnRemove.setText(Messages.getString("LineSeriesMarkerSheet.Label.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnUp = new Button((Composite)grpTop, 132);
        this.btnUp.setToolTipText(Messages.getString("PaletteEditorComposite.Lbl.Up"));
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnDown = new Button((Composite)grpTop, 1028);
        this.btnDown.setToolTipText(Messages.getString("PaletteEditorComposite.Lbl.Down"));
        this.btnDown.addSelectionListener((SelectionListener)this);
        this.currentMarkerEditor = new MarkerEditorComposite((Composite)this.cnvMarkers, this.createMarker());
        this.currentMarkerEditor.setBounds(0, 0, 40, 25);
        this.setEnabledState();
        try {
            this.idrSWT = PluginSettings.instance().getDevice("dv.SWT");
            this.idrSWT.getDisplayServer();
        }
        catch (ChartException pex) {
            WizardBase.displayException((Throwable)pex);
        }
        return cmpContent;
    }

    void handleEventCanvasMarkers(Event event) {
        switch (event.type) {
            case 1: {
                if (event.keyCode == 0x1000003) {
                    if (this.iSelectedIndex - 1 < 0) break;
                    --this.iSelectedIndex;
                    this.setEnabledState();
                    break;
                }
                if (event.keyCode == 0x1000004) {
                    if (this.iSelectedIndex + 1 >= this.getMarkers().size()) break;
                    ++this.iSelectedIndex;
                    this.setEnabledState();
                    break;
                }
                if (event.keyCode == 0x1000001) {
                    if (this.iSelectedIndex - 4 < 0) break;
                    this.iSelectedIndex -= 4;
                    this.setEnabledState();
                    break;
                }
                if (event.keyCode == 0x1000002) {
                    if (this.iSelectedIndex + 4 >= this.getMarkers().size()) break;
                    this.iSelectedIndex += 4;
                    this.setEnabledState();
                    break;
                }
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    this.currentMarkerEditor.setFocus();
                    break;
                }
                if (event.keyCode != 27) break;
                this.cnvMarkers.getShell().close();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvMarkers.redraw();
                    }
                }
                break;
            }
            case 9: {
                this.paintControl(new PaintEvent(event));
                break;
            }
            case 3: {
                this.mouseDown(new MouseEvent(event));
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnAdd)) {
            this.iSelectedIndex = this.getMarkers().size();
            if ((this.iStartRow + 3) * 4 == this.iSelectedIndex) {
                ++this.iStartRow;
            }
            this.getMarkers().add((Object)this.newMarkerEditor.getMarker());
            this.newMarkerEditor.setMarker(this.createMarker());
            this.cnvMarkers.redraw();
            this.updateScrollBar();
            this.setEnabledState();
        } else if (e.widget.equals(this.btnRemove)) {
            if (this.iStartRow > 0 && (this.iStartRow + 3 - 1) * 4 == this.iSelectedIndex) {
                --this.iStartRow;
            }
            if (this.iSelectedIndex == this.getMarkers().size() - 1) {
                --this.iSelectedIndex;
            }
            this.getMarkers().remove((Object)this.currentMarkerEditor.getMarker());
            this.currentMarkerEditor.setMarker((Marker)this.getMarkers().get(this.iSelectedIndex));
            this.cnvMarkers.redraw();
            this.updateScrollBar();
            this.setEnabledState();
        } else if (e.widget.equals(this.btnUp)) {
            if (this.iSelectedIndex > 0) {
                --this.iSelectedIndex;
                this.getMarkers().move(this.iSelectedIndex, (Object)this.currentMarkerEditor.getMarker());
                this.cnvMarkers.redraw();
                this.setEnabledState();
            }
        } else if (e.widget.equals(this.btnDown)) {
            if (this.iSelectedIndex < this.getMarkers().size() - 1) {
                ++this.iSelectedIndex;
                this.getMarkers().move(this.iSelectedIndex, (Object)this.currentMarkerEditor.getMarker());
                this.cnvMarkers.redraw();
                this.setEnabledState();
            }
        } else if (e.widget.equals(this.cnvMarkers.getVerticalBar())) {
            this.iStartRow = this.cnvMarkers.getVerticalBar().getSelection();
            this.cnvMarkers.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Marker createMarker() {
        Marker marker = MarkerImpl.create((MarkerType)MarkerType.BOX_LITERAL, (int)4);
        marker.eAdapters().addAll((Collection)this.series.eAdapters());
        return marker;
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int markerSize = this.getMarkers().size();
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < markerSize) {
            if (i < this.iStartRow * 4) {
                i += 4;
                continue;
            }
            this.paintMarker(gc, (Marker)this.getMarkers().get(i), LocationImpl.create((double)(x + 20), (double)(y + 12)));
            if (i == this.iSelectedIndex) {
                this.currentMarkerEditor.setMarker((Marker)this.getMarkers().get(i));
                this.currentMarkerEditor.setLocation(x + 8, y);
            }
            if (++i % 4 == 0) {
                y += 25;
                x = 0;
                continue;
            }
            x += 40;
        }
    }

    private void paintMarker(GC gc, Marker currentMarker, Location location) {
        Marker renderMarker = currentMarker;
        if (currentMarker.getType() == MarkerType.ICON_LITERAL) {
            renderMarker = (Marker)EcoreUtil.copy((EObject)currentMarker);
            renderMarker.setFill((Fill)ImageImpl.create((String)UIHelper.getURL((String)"icons/obj16/marker_icon.gif").toString()));
        }
        this.idrSWT.setProperty("device.output.context", (Object)gc);
        MarkerRenderer mr = new MarkerRenderer(this.idrSWT, (Object)StructureSource.createUnknown(null), location, LineAttributesImpl.create((ColorDefinition)(renderMarker.isVisible() ? ColorDefinitionImpl.BLUE() : ColorDefinitionImpl.GREY()), (LineStyle)LineStyle.SOLID_LITERAL, (int)1), (Fill)(renderMarker.isVisible() ? ColorDefinitionImpl.create((int)80, (int)168, (int)218) : ColorDefinitionImpl.GREY()), renderMarker, 4, null, false, false);
        try {
            mr.draw((IPrimitiveRenderer)this.idrSWT);
        }
        catch (ChartException ex) {
            WizardBase.displayException((Throwable)ex);
        }
    }

    private EList getMarkers() {
        return this.series.getMarkers();
    }

    private void updateScrollBar() {
        ScrollBar vsb = this.cnvMarkers.getVerticalBar();
        vsb.setValues(this.iStartRow, 0, Math.max(0, (this.getMarkers().size() - 1) / 4 + 2 - 3), 1, 1, 1);
    }

    void mouseDown(MouseEvent e) {
        if (e.widget.equals(this.cnvMarkers)) {
            int ix = e.x / 40;
            int iy = e.y / 25 + this.iStartRow;
            this.iSelectedIndex = iy * 4 + ix;
            if (ix >= 4 || this.iSelectedIndex >= this.getMarkers().size()) {
                return;
            }
            this.cnvMarkers.redraw();
            this.setEnabledState();
        }
    }

    private void setEnabledState() {
        if (this.iSelectedIndex < 0) {
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.currentMarkerEditor.setVisible(false);
        } else {
            this.btnUp.setEnabled(this.iSelectedIndex > 0);
            this.btnDown.setEnabled(this.iSelectedIndex < this.getMarkers().size() - 1);
            this.btnRemove.setEnabled(this.getMarkers().size() > 1);
            this.currentMarkerEditor.setVisible(true);
        }
    }
}

