/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.model.api.ClientIterator;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DerivedElementIterator;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PrivateStyleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.PropertyIterator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.TemplateCommand;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public abstract class DesignElementHandle
implements IDesignElementModel {
    protected final Module module;
    private SlotHandle[] slotHandles = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DesignElementHandle(Module module) {
        this.module = module;
    }

    public ReportDesign getDesign() {
        if (this.module instanceof ReportDesign) {
            return (ReportDesign)this.module;
        }
        return null;
    }

    public Module getModule() {
        return this.module;
    }

    public ReportDesignHandle getDesignHandle() {
        if (this.getDesign() != null) {
            return (ReportDesignHandle)this.getDesign().getHandle(this.module);
        }
        return null;
    }

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.getModule().getHandle(this.getModule());
    }

    public abstract DesignElement getElement();

    public IElementDefn getDefn() {
        return this.getElement().getDefn();
    }

    public Object getProperty(String propName) {
        DesignElement element = this.getElement();
        Object value = element.getProperty(this.module, propName);
        if (value instanceof ReferenceValue) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, this.getModule());
        }
        PropertyDefn defn = (PropertyDefn)((Object)this.getPropertyDefn(propName));
        if (value instanceof List && defn != null && defn.getSubTypeCode() == 20) {
            List valueList = (List)value;
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < valueList.size(); ++i) {
                ElementRefValue item = (ElementRefValue)valueList.get(i);
                names.add(ReferenceValueUtil.needTheNamespacePrefix(item, this.getModule()));
            }
            return names;
        }
        return value;
    }

    public String getStringProperty(String propName) {
        return this.getElement().getStringProperty(this.module, propName);
    }

    public String getDisplayProperty(String propName) {
        return this.getElement().getDisplayProperty(this.module, propName);
    }

    public boolean getBooleanProperty(String propName) {
        return this.getElement().getBooleanProperty(this.module, propName);
    }

    public int getIntProperty(String propName) {
        return this.getElement().getIntProperty(this.module, propName);
    }

    public double getFloatProperty(String propName) {
        return this.getElement().getFloatProperty(this.module, propName);
    }

    public BigDecimal getNumberProperty(String propName) {
        return this.getElement().getNumberProperty(this.module, propName);
    }

    public DimensionHandle getDimensionProperty(String propName) {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        if (propDefn.getTypeCode() != 3) {
            return null;
        }
        return new DimensionHandle(this, propDefn);
    }

    public ColorHandle getColorProperty(String propName) {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        if (propDefn.getTypeCode() != 4) {
            return null;
        }
        return new ColorHandle(this, propDefn);
    }

    protected FontHandle getFontProperty() {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn("fontFamily");
        if (propDefn == null) {
            return null;
        }
        return new FontHandle(this);
    }

    public DesignElementHandle getElementProperty(String propName) {
        DesignElement target = this.getElement().getReferenceProperty(this.module, propName);
        if (target == null) {
            return null;
        }
        return target.getHandle(target.getRoot());
    }

    public List getListProperty(Module module, String propName) {
        return this.getElement().getListProperty(module, propName);
    }

    public List getListProperty(String propName) {
        return this.getElement().getListProperty(this.module, propName);
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        DesignElement element = this.getElement();
        PropertyCommand cmd = new PropertyCommand(this.module, element);
        cmd.setProperty(propName, value);
    }

    public void setIntProperty(String propName, int value) throws SemanticException {
        this.setProperty(propName, new Integer(value));
    }

    public void setStringProperty(String propName, String value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void setFloatProperty(String propName, double value) throws SemanticException {
        this.setProperty(propName, new Double(value));
    }

    public void setNumberProperty(String propName, BigDecimal value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void clearAllProperties() throws SemanticException {
        List props = this.getDefn().getProperties();
        for (int i = 0; i < props.size(); ++i) {
            PropertyHandle propHandle;
            PropertyDefn propDefn = (PropertyDefn)props.get(i);
            String propName = propDefn.getName();
            if ("name".equals(propName)) {
                NameCommand nameCmd = new NameCommand(this.module, this.getElement());
                try {
                    nameCmd.checkName(null);
                }
                catch (NameException e) {
                    continue;
                }
            }
            if (!(propHandle = this.getPropertyHandle(propName)).isLocal()) continue;
            propHandle.clearValue();
        }
    }

    public boolean hasLocalProperties() {
        return this.getElement().hasLocalPropertyValues();
    }

    public void addUserPropertyDefn(UserPropertyDefn prop) throws UserPropertyException {
        DesignElement element = this.getElement();
        UserPropertyCommand cmd = new UserPropertyCommand(this.module, element);
        cmd.addUserProperty(prop);
    }

    public void addElement(DesignElementHandle child, int slotId, int pos) throws ContentException, NameException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle != null) {
            slotHandle.add(child, pos);
        }
    }

    public void addElement(DesignElementHandle child, int slotId) throws ContentException, NameException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle != null) {
            slotHandle.add(child);
        }
    }

    public List getMethods() {
        return this.getElement().getDefn().getMethods();
    }

    public void setProperties(Map properties) throws SemanticException {
        if (properties == null) {
            return;
        }
        Iterator iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            this.setProperty(propName, properties.get(propName));
        }
    }

    public void clearContents(int slotId) throws SemanticException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle == null) {
            return;
        }
        for (int i = slotHandle.getCount() - 1; i >= 0; --i) {
            slotHandle.dropAndClear(i);
        }
    }

    public void dropUserPropertyDefn(String propName) throws UserPropertyException {
        DesignElement element = this.getElement();
        UserPropertyCommand cmd = new UserPropertyCommand(this.module, element);
        cmd.dropUserProperty(propName);
    }

    public DesignElementHandle getExtends() {
        DesignElement parent = this.getElement().getExtendsElement();
        if (parent == null) {
            return null;
        }
        return parent.getHandle(parent.getRoot());
    }

    public void setExtends(DesignElementHandle parent) throws ExtendsException {
        ExtendsCommand cmd = new ExtendsCommand(this.module, this.getElement());
        cmd.setExtendsElement(parent);
    }

    public void setExtendsName(String name) throws ExtendsException {
        DesignElement element = this.getElement();
        ExtendsCommand cmd = new ExtendsCommand(this.module, element);
        cmd.setExtendsName(name);
    }

    public void localize() throws SemanticException {
        DesignElement element = this.getElement();
        ExtendsCommand cmd = new ExtendsCommand(this.module, element);
        cmd.localizeElement();
    }

    public void setExtendsElement(DesignElement parent) throws ExtendsException {
        ExtendsCommand cmd = new ExtendsCommand(this.module, this.getElement());
        cmd.setExtendsElement(parent);
    }

    public SharedStyleHandle getStyle() {
        StyleElement style = this.getElement().getStyle(this.module);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(this.module);
    }

    public void setStyleName(String name) throws StyleException {
        DesignElement element = this.getElement();
        StyleCommand cmd = new StyleCommand(this.module, element);
        cmd.setStyle(name);
    }

    public void setStyleElement(StyleElement obj) throws StyleException {
        DesignElement element = this.getElement();
        StyleCommand cmd = new StyleCommand(this.module, element);
        cmd.setStyleElement(obj);
    }

    public void setStyle(SharedStyleHandle style) throws StyleException {
        if (style == null) {
            this.setStyleElement(null);
        } else {
            this.setStyleElement((StyleElement)style.getElement());
        }
    }

    public StyleHandle getPrivateStyle() {
        if (this.getDefn().hasStyle()) {
            return new PrivateStyleHandle(this.module, this.getElement());
        }
        return null;
    }

    public String getName() {
        return this.getElement().getName();
    }

    public String getQualifiedName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        Module rootElement = this.getElement().getRoot();
        if (rootElement instanceof Library) {
            String namespace = ((Library)rootElement).getNamespace();
            return StringUtil.buildQualifiedReference(namespace, name);
        }
        return name;
    }

    public void setName(String name) throws NameException {
        NameCommand cmd = new NameCommand(this.module, this.getElement());
        cmd.setName(name);
    }

    public long getID() {
        return this.getElement().getID();
    }

    public ElementFactory getElementFactory() {
        return new ElementFactory(this.module);
    }

    public PropertyHandle getPropertyHandle(String propName) {
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        return new PropertyHandle(this, propDefn);
    }

    public UserPropertyDefnHandle getUserPropertyDefnHandle(String propName) {
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        if (propDefn.isUserProperty()) {
            return new UserPropertyDefnHandle(this, (UserPropertyDefn)propDefn);
        }
        return null;
    }

    public List getUserProperties() {
        return this.getElement().getUserProperties();
    }

    public FactoryPropertyHandle getFactoryPropertyHandle(String propName) {
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        FactoryPropertyHandle handle = new FactoryPropertyHandle(this, propDefn);
        if (handle.isSet()) {
            return handle;
        }
        return null;
    }

    public DesignElementHandle getContainer() {
        DesignElement element = this.getElement().getContainer();
        if (element == null) {
            return null;
        }
        return element.getHandle(this.module);
    }

    public void moveTo(DesignElementHandle newContainer, int toSlot) throws ContentException {
        DesignElement element = this.getElement();
        DesignElement oldContainer = element.getContainer();
        if (oldContainer == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        int oldSlot = element.getContainerSlot();
        if (!$assertionsDisabled && oldSlot == -1) {
            throw new AssertionError();
        }
        ContentCommand cmd = new ContentCommand(this.module, oldContainer);
        cmd.move(element, oldSlot, newContainer.getElement(), toSlot);
    }

    public void dropAndClear() throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement container = element.getContainer();
        if (container == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        int slotID = element.getContainerSlot();
        if (!$assertionsDisabled && slotID == -1) {
            throw new AssertionError();
        }
        ContentCommand cmd = new ContentCommand(this.module, container);
        cmd.remove(element, slotID, false);
    }

    public void drop() throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement container = element.getContainer();
        if (container == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        int slotID = element.getContainerSlot();
        if (!$assertionsDisabled && slotID == -1) {
            throw new AssertionError();
        }
        ContentCommand cmd = new ContentCommand(this.module, container);
        cmd.remove(element, slotID, true);
    }

    public int findContentSlot(DesignElementHandle content) {
        if (content.getContainer().getElement() == this.getElement()) {
            return content.getElement().getContainerSlot();
        }
        return -1;
    }

    public SlotHandle getContainerSlotHandle() {
        DesignElementHandle containerHandle = this.getContainer();
        if (containerHandle == null) {
            return null;
        }
        int slotID = containerHandle.findContentSlot(this);
        if (!$assertionsDisabled && slotID == -1) {
            throw new AssertionError();
        }
        return containerHandle.getSlot(slotID);
    }

    public SlotHandle getSlot(int slotID) {
        int slotCount = this.getDefn().getSlotCount();
        if (slotCount == 0) {
            return null;
        }
        if (!($assertionsDisabled || 0 <= slotID && slotID < slotCount)) {
            throw new AssertionError();
        }
        if (this.slotHandles == null) {
            this.slotHandles = new SlotHandle[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.slotHandles[i] = null;
            }
        }
        if (this.slotHandles[slotID] == null) {
            this.slotHandles[slotID] = new SlotHandle(this, slotID);
        }
        return this.slotHandles[slotID];
    }

    public Iterator getPropertyIterator() {
        return new PropertyIterator(this);
    }

    public void addListener(Listener obj) {
        this.getElement().addListener(obj);
    }

    public void removeListener(Listener obj) {
        this.getElement().removeListener(obj);
    }

    public Iterator derivedIterator() {
        return new DerivedElementIterator(this.module, this);
    }

    public Iterator clientsIterator() {
        return new ClientIterator(this);
    }

    public IChoice[] getChoices(String propName) {
        PropertyHandle propertyHandle = this.getPropertyHandle(propName);
        if (propertyHandle == null) {
            return null;
        }
        return propertyHandle.getChoices();
    }

    public String getDisplayLabel() {
        return this.getDisplayLabel(1);
    }

    public String getDisplayLabel(int level) {
        if (!$assertionsDisabled && level != 0 && level != 1 && level != 2) {
            throw new AssertionError();
        }
        return this.getElement().getDisplayLabel(this.module, level);
    }

    public static void doSort(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                DesignElementHandle h1 = (DesignElementHandle)arg0;
                DesignElementHandle h2 = (DesignElementHandle)arg1;
                String s1 = h1.getDisplayLabel();
                String s2 = h2.getDisplayLabel();
                return s1.compareTo(s2);
            }
        });
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public boolean showError() {
        return this.hasSemanticError() || !this.isValid();
    }

    public void setValid(boolean isValid) {
        this.getElement().setValid(isValid);
    }

    public boolean hasSemanticError() {
        return !this.getSemanticErrors().isEmpty();
    }

    public IDesignElement copy() {
        try {
            return (DesignElement)this.getElement().clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public void copyPropertyTo(String propName, DesignElementHandle targetHandle) throws SemanticException {
        if (!$assertionsDisabled && targetHandle.getModule() != this.getModule()) {
            throw new AssertionError();
        }
        if (targetHandle.getModule() != this.getModule()) {
            throw new IllegalArgumentException("The target element should be in the same report !");
        }
        if (targetHandle.getDefn() != this.getDefn()) {
            throw new PropertyValueException((Object)targetHandle.getDefn().getName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        }
        ElementPropertyDefn propDefn = (ElementPropertyDefn)this.getDefn().getProperty(propName);
        if (propDefn == null) {
            throw new PropertyNameException(this.getElement(), propName);
        }
        propDefn = (ElementPropertyDefn)targetHandle.getDefn().getProperty(propName);
        if (propDefn == null) {
            throw new PropertyNameException(targetHandle.getElement(), propName);
        }
        Object value = this.getElement().getLocalProperty(this.module, propDefn.getName());
        if (value == null) {
            targetHandle.setProperty(propName, null);
            return;
        }
        if ("name".equals(propName) || "extends".equals(propName)) {
            throw new SemanticError(this.getElement(), new String[]{propName}, "Error.SemanticError.PROPERTY_COPY_FORBIDDEN");
        }
        switch (propDefn.getTypeCode()) {
            case 15: {
                ElementRefValue refValue = (ElementRefValue)value;
                if (refValue.isResolved()) {
                    targetHandle.setProperty(propDefn.getName(), refValue.getElement());
                    break;
                }
                String name = refValue.getName();
                name = ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, this.getModule());
                targetHandle.setProperty(propDefn.getName(), name);
                break;
            }
            case 19: {
                StructRefValue structRefValue = (StructRefValue)value;
                if (structRefValue.isResolved()) {
                    targetHandle.setProperty(propDefn.getName(), structRefValue.getStructure());
                    break;
                }
                targetHandle.setProperty(propDefn.getName(), structRefValue.getName());
                break;
            }
            case 16: {
                if (propDefn.isList()) {
                    PropertyHandle propHandle = targetHandle.getPropertyHandle(propName);
                    Iterator strcutIter = ((List)value).iterator();
                    while (strcutIter.hasNext()) {
                        Structure struct = (Structure)strcutIter.next();
                        propHandle.addItem(struct.copy());
                    }
                    break;
                }
                IStructure struct = (IStructure)value;
                targetHandle.setProperty(propName, struct.copy());
                break;
            }
            case 20: {
                if (!$assertionsDisabled && !(value instanceof List)) {
                    throw new AssertionError();
                }
                List valueList = (List)value;
                PropertyHandle propHandle = targetHandle.getPropertyHandle(propName);
                for (int i = 0; i < valueList.size(); ++i) {
                    Object item = valueList.get(i);
                    if (propDefn.getSubTypeCode() != 15) {
                        propHandle.addItem(item);
                        continue;
                    }
                    if (!$assertionsDisabled && !(item instanceof ElementRefValue)) {
                        throw new AssertionError();
                    }
                    ElementRefValue refValue = (ElementRefValue)item;
                    if (refValue.isResolved()) {
                        propHandle.addItem(refValue.getElement());
                        continue;
                    }
                    propHandle.addItem(refValue.getQualifiedReference());
                }
                break;
            }
            default: {
                targetHandle.setProperty(propName, value);
            }
        }
    }

    public List semanticCheck() {
        List exceptionList = this.getElement().validate(this.module);
        List errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    public boolean canDrop() {
        boolean flag = this.getElement().canDrop();
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public boolean canEdit() {
        boolean flag = this.getElement().canEdit();
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public boolean canTransformToTemplate() {
        boolean flag = this.getElement().canTransformToTemplate(this.getModule());
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public boolean canContain(int slotId, String type) {
        if (type == null) {
            return false;
        }
        IElementDefn defn = MetaDataDictionary.getInstance().getElement(type);
        if (defn == null) {
            defn = MetaDataDictionary.getInstance().getExtension(type);
        }
        if (defn == null) {
            return false;
        }
        boolean flag = this.getElement().canContain(this.getModule(), slotId, defn);
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public boolean canContain(int slotId, DesignElementHandle content) {
        if (content == null) {
            return false;
        }
        boolean flag = this.getElement().canContain(this.getModule(), slotId, content.getElement());
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public List getSemanticErrors() {
        List exceptionList = this.getElement().getErrors();
        if (exceptionList == null) {
            return Collections.EMPTY_LIST;
        }
        List errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return ErrorDetail.getSemanticErrors(errorDetailList, "Error.DesignFileException.SEMANTIC_ERROR");
    }

    public ModuleHandle getRoot() {
        Module module = this.getElement().getRoot();
        if (module != null) {
            return (ModuleHandle)module.getHandle(module);
        }
        return null;
    }

    public String getXPath() {
        DesignElementHandle container;
        DesignElementHandle element = this;
        StringBuffer sb = new StringBuffer();
        do {
            ElementDefn elementDefn = (ElementDefn)element.getDefn();
            container = element.getContainer();
            String slotInfo = null;
            String posnInfo = null;
            if (container != null) {
                SlotHandle slot = element.getContainerSlotHandle();
                ISlotDefn slotDefn = container.getElement().getDefn().getSlot(slot.getSlotID());
                String slotDefnName = slotDefn.getXmlName();
                int slotIndex = 1;
                slotInfo = "/" + slotDefnName + "[" + slotIndex + "]";
                int tagIndex = 1;
                for (int i = 0; i < slot.findPosn(element); ++i) {
                    DesignElementHandle tmpElement = slot.get(i);
                    if (tmpElement.getDefn() != elementDefn) continue;
                    ++tagIndex;
                }
                posnInfo = "[" + tagIndex + "]";
            }
            String elementPath = "";
            if (!StringUtil.isBlank(slotInfo)) {
                elementPath = slotInfo;
            }
            elementPath = elementPath + "/" + elementDefn.getXmlElement();
            if (!StringUtil.isBlank(posnInfo)) {
                elementPath = elementPath + posnInfo;
            }
            sb.insert(0, elementPath);
        } while ((element = container) != null);
        return sb.toString();
    }

    public String getEventHandlerClass() {
        return this.getStringProperty("eventHandlerClass");
    }

    public void setEventHandlerClass(String expr) throws SemanticException {
        this.setProperty("eventHandlerClass", expr);
    }

    public TemplateElementHandle createTemplateElement(String name) throws SemanticException {
        if (this.getRoot() == null) {
            throw new TemplateException(this.getElement(), "Error.TemplateException.CREATE_TEMPLATE_ELEMENT_FORBIDDEN");
        }
        TemplateCommand cmd = new TemplateCommand(this.getModule(), this.getContainer().getElement());
        TemplateElement template = cmd.createTemplateElement(this.getElement(), this.getElement().getContainerSlot(), name);
        if (template == null) {
            return null;
        }
        return (TemplateElementHandle)template.getHandle(this.module);
    }

    public TemplateElementHandle revertToTemplate(String name) throws SemanticException {
        if (this.getRoot() == null) {
            throw new TemplateException(this.getElement(), "Error.TemplateException.CREATE_TEMPLATE_ELEMENT_FORBIDDEN");
        }
        TemplateCommand cmd = new TemplateCommand(this.getModule(), this.getContainer().getElement());
        TemplateElement template = cmd.revertToTemplate(this.getElement(), this.getElement().getContainerSlot(), name);
        if (template == null) {
            return null;
        }
        return (TemplateElementHandle)template.getHandle(this.module);
    }

    public void revertToReportItem() throws SemanticException {
        this.clearProperty("refTemplateParameter");
    }

    public boolean isTemplateParameterValue() {
        return this.getElement().isTemplateParameterValue(this.getModule());
    }

    public IElementPropertyDefn getPropertyDefn(String propName) {
        return this.getElement().getPropertyDefn(propName);
    }

    protected Module getEffectiveModule() {
        return this.module;
    }

    public String getPropertyBinding(String propName) {
        if (propName == null) {
            return null;
        }
        DesignElement element = this.getElement();
        while (element != null && element.getRoot() != null) {
            PropertyBinding propBinding = element.getRoot().findPropertyBinding(element, propName);
            if (propBinding != null) {
                return propBinding.getValue();
            }
            if (element.isVirtualElement()) {
                element = element.getVirtualParent();
                continue;
            }
            element = element.getExtendsElement();
        }
        return null;
    }

    public List getPropertyBindings() {
        ArrayList nameList = new ArrayList();
        ArrayList resultList = new ArrayList();
        DesignElement element = this.getElement();
        while (element != null && element.getRoot() != null) {
            List propBindings = element.getRoot().getPropertyBindings(element);
            resultList.addAll(this.filterPropertyBindingName(propBindings, nameList));
            if (element.isVirtualElement()) {
                element = element.getVirtualParent();
                continue;
            }
            element = element.getExtendsElement();
        }
        return resultList;
    }

    private List filterPropertyBindingName(List propertyBindings, List nameList) {
        if (propertyBindings == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyBinding> resultList = new ArrayList<PropertyBinding>();
        Iterator iterator = propertyBindings.iterator();
        while (iterator.hasNext()) {
            PropertyBinding propBinding = (PropertyBinding)iterator.next();
            String name = propBinding.getName();
            if (nameList.contains(name)) continue;
            resultList.add(propBinding);
            nameList.add(name);
        }
        return resultList;
    }

    public void setPropertyBinding(String propName, String value) throws SemanticException {
        ElementPropertyDefn defn = (ElementPropertyDefn)this.getPropertyDefn(propName);
        if (defn == null) {
            throw new SemanticError(this.getElement(), new String[]{propName}, "Error.SemanticError.INVALID_PROPERTY_NAME");
        }
        if ("propertyBindings".equals(defn.getName())) {
            return;
        }
        Module root = this.getElement().getRoot();
        if (root == null) {
            throw new SemanticError(this.getElement(), "Error.SemanticError.PROPERTY_BINDING_FORBIDDEN");
        }
        if (!$assertionsDisabled && root.getElementByID(this.getID()) != this.getElement()) {
            throw new AssertionError();
        }
        ArrayList bindingList = (ArrayList)root.getLocalProperty(root, "propertyBindings");
        PropertyBinding binding = root.findPropertyBinding(this.getElement(), propName);
        if (binding == null && value == null) {
            return;
        }
        if (bindingList == null) {
            if (!$assertionsDisabled && value == null) {
                throw new AssertionError();
            }
            bindingList = new ArrayList();
            root.setProperty("propertyBindings", bindingList);
        }
        defn = root.getPropertyDefn("propertyBindings");
        if (!$assertionsDisabled && defn == null) {
            throw new AssertionError();
        }
        PropertyCommand cmd = new PropertyCommand(this.module, root);
        if (value == null && binding != null) {
            cmd.removeItem((MemberRef)new CachedMemberRef(defn), bindingList.indexOf(binding));
        } else if (binding == null) {
            binding = new PropertyBinding();
            binding.setName(propName);
            binding.setID(this.getID());
            binding.setValue(value);
            cmd.addItem(new CachedMemberRef(defn), binding);
        } else {
            CachedMemberRef memberRef = new CachedMemberRef(defn, bindingList.indexOf(binding), "value");
            cmd.setMember(memberRef, value);
        }
    }

    public String getExternalizedValue(String textIDProp, String textProp) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, ThreadResources.getLocale());
    }

    public String getExternalizedValue(String textIDProp, String textProp, ULocale locale) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, locale);
    }

    public String getExternalizedValue(String textIDProp, String textProp, Locale locale) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, ULocale.forLocale((Locale)locale));
    }

    static {
        $assertionsDisabled = !DesignElementHandle.class.desiredAssertionStatus();
    }
}

