/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ThemeStyleNameValidator
extends AbstractElementValidator {
    private static ThemeStyleNameValidator instance = new ThemeStyleNameValidator();

    public static ThemeStyleNameValidator getInstance() {
        return instance;
    }

    public List validateForAddingStyle(ThemeHandle theme, String styleName) {
        ArrayList<NameException> list = new ArrayList<NameException>();
        StyleHandle style = theme.findStyle(styleName);
        if (style != null) {
            list.add(new NameException(theme.getElement(), styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }

    public List validateForRenamingStyle(ThemeHandle theme, StyleHandle style, String styleName) {
        if (style.getName() == styleName || styleName != null && styleName.equals(style.getName())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<NameException> list = new ArrayList<NameException>();
        StyleHandle tmpStyle = theme.findStyle(styleName);
        if (tmpStyle != null && style != tmpStyle) {
            list.add(new NameException(theme.getElement(), styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof Theme)) {
            return Collections.EMPTY_LIST;
        }
        Theme theme = (Theme)element;
        ContainerSlot slot = theme.getSlot(0);
        ArrayList<NameException> list = new ArrayList<NameException>();
        HashSet<String> set = new HashSet<String>();
        Iterator iter = slot.iterator();
        while (iter.hasNext()) {
            StyleElement style = (StyleElement)iter.next();
            String styleName = style.getName();
            if (!set.contains(styleName)) {
                set.add(style.getName());
                continue;
            }
            list.add(new NameException((DesignElement)theme, styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }
}

