/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssErrorHandler;

public final class CssStyleSheet {
    protected LinkedHashMap styles = new LinkedHashMap();
    private ArrayList warnings = new ArrayList();
    private HashMap unsupportedStyles = new HashMap();
    private HashMap warningsForStyles = new HashMap();
    private CssErrorHandler errorHandler = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CssStyleSheetHandle handle(Module module) {
        return new CssStyleSheetHandle((ModuleHandle)module.getHandle(module), this);
    }

    public StyleElement findStyle(String name) {
        return (StyleElement)this.styles.get(name);
    }

    public void addStyle(DesignElement style) {
        if (!$assertionsDisabled && this.styles.get(style.getName()) != null) {
            throw new AssertionError();
        }
        this.styles.put(style.getName(), style);
    }

    public void removeStyle(String name) {
        if (!$assertionsDisabled && this.styles.get(name) == null) {
            throw new AssertionError();
        }
        this.styles.remove(name);
    }

    public List getStyles() {
        return new ArrayList(this.styles.values());
    }

    public void addWarning(List warnings) {
        warnings.addAll(warnings);
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void addUnsupportedStyle(String styleName, StyleSheetParserException e) {
        this.unsupportedStyles.put(styleName, e);
    }

    public List getUnsupportedStyle() {
        ArrayList styles = new ArrayList();
        styles.addAll(this.unsupportedStyles.keySet());
        return styles;
    }

    public void addWarnings(String styleName, List errors) {
        this.warningsForStyles.put(styleName, errors);
    }

    public List getWarnings(String styleName) {
        return (List)this.warningsForStyles.get(styleName);
    }

    public CssErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CssErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    static {
        $assertionsDisabled = !CssStyleSheet.class.desiredAssertionStatus();
    }
}

