/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp;

import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.actions.NewLibraryAction;
import org.eclipse.birt.report.designer.ui.internal.rcp.actions.NewReportAction;
import org.eclipse.birt.report.designer.ui.internal.rcp.actions.NewReportTemplateAction;
import org.eclipse.birt.report.designer.ui.internal.rcp.actions.OpenFileAction;
import org.eclipse.birt.report.designer.ui.rcp.nls.DesignerWorkbenchMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardDropDownAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class DesignerActionBarAdvisor
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction openFileAction;
    private ActionFactory.IWorkbenchAction newReportAction;
    private ActionFactory.IWorkbenchAction newLibraryAction;
    private ActionFactory.IWorkbenchAction newReportTemplateAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private ActionFactory.IWorkbenchAction introAction;
    private IContributionItem pinEditorContributionItem;
    private boolean isDisposed = false;

    public DesignerActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        coolBar.setContextMenuManager((IMenuManager)popUpMenu);
        coolBar.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(coolBar.getStyle());
        fileToolBar.add((IAction)new NewWizardDropDownAction(this.window));
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        ToolBarManager navToolBar = new ToolBarManager(coolBar.getStyle());
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IContributionItem)new GroupMarker("group.application"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        navToolBar.add((IContributionItem)new Separator("pin.group"));
        navToolBar.add(this.pinEditorContributionItem);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)navToolBar, "org.eclipse.ui.workbench.navigate"));
        coolBar.add((IContributionItem)new GroupMarker("group.editor"));
        coolBar.add((IContributionItem)new GroupMarker("group.help"));
        ToolBarManager helpToolBar = new ToolBarManager(coolBar.getStyle());
        helpToolBar.add((IContributionItem)new Separator("group.help"));
        helpToolBar.add((IContributionItem)new GroupMarker("group.application"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)helpToolBar, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(DesignerWorkbenchMessages.Workbench_file, "file");
        MenuManager newMenu = new MenuManager(DesignerWorkbenchMessages.Workbench_new, ActionFactory.NEW.getId());
        newMenu.add((IAction)this.newReportAction);
        newMenu.add((IAction)this.newLibraryAction);
        newMenu.add((IAction)this.newReportTemplateAction);
        menu.add((IContributionItem)newMenu);
        menu.add((IAction)this.openFileAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.quitAction);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(DesignerWorkbenchMessages.Workbench_edit, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(DesignerWorkbenchMessages.Workbench_window, "window");
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)this.openPreferencesAction);
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        MenuManager showViewMenuMgr = new MenuManager(DesignerWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(DesignerWorkbenchMessages.Workbench_help, "help");
        if (this.introAction != null) {
            menu.add((IAction)this.introAction);
        } else if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        menu.add((IAction)this.helpContentsAction);
        if (this.tipsAndTricksAction != null) {
            menu.add((IAction)this.tipsAndTricksAction);
        }
        menu.add((IContributionItem)new GroupMarker("group.tutorials"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.about"));
        menu.add((IAction)this.aboutAction);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.pinEditorContributionItem.dispose();
        this.openFileAction = null;
        this.newReportAction = null;
        this.newLibraryAction = null;
        this.newReportTemplateAction = null;
        this.closeAction = null;
        this.closeAllAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.helpContentsAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.saveAsAction = null;
        this.lockToolBarAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
        this.deleteAction = null;
        this.selectAllAction = null;
        this.findAction = null;
        this.quitAction = null;
        this.quickStartAction = null;
        this.tipsAndTricksAction = null;
        this.pinEditorContributionItem = null;
        this.introAction = null;
        super.dispose();
    }

    public boolean isApplicationMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
    }

    public void makeActions(IWorkbenchWindow window) {
        this.openFileAction = new OpenFileAction(window);
        this.register((IAction)this.openFileAction);
        this.newReportAction = new NewReportAction(window);
        this.register((IAction)this.newReportAction);
        this.newLibraryAction = new NewLibraryAction(window);
        this.register((IAction)this.newLibraryAction);
        this.newReportTemplateAction = new NewReportTemplateAction(window);
        this.register((IAction)this.newReportTemplateAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.makeFeatureDependentActions(window);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        this.pinEditorContributionItem = ContributionItemFactory.PIN_EDITOR.create(window);
    }

    private void makeFeatureDependentActions(IWorkbenchWindow window) {
        IPreferenceStore prefs = ReportPlugin.getDefault().getPreferenceStore();
        String stateKey = "platformState";
        String prevState = prefs.getString(stateKey);
        String currentState = String.valueOf(Platform.getStateStamp());
        boolean sameState = currentState.equals(prevState);
        if (!sameState) {
            prefs.putValue(stateKey, currentState);
        }
    }
}

